/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution;

import graphql.GraphQLException;
import graphql.schema.DataFetchingEnvironment;
import io.leangen.graphql.execution.ContextWrapper;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.InvocationContext;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.execution.ResolverInterceptor;
import io.leangen.graphql.execution.ResolverInterceptorFactory;
import io.leangen.graphql.execution.ResolverInterceptorFactoryParams;
import io.leangen.graphql.generator.mapping.ConverterRegistry;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OperationExecutor {
    private final Operation operation;
    private final ValueMapper valueMapper;
    private final GlobalEnvironment globalEnvironment;
    private final ConverterRegistry converterRegistry;
    private final Map<Resolver, List<ResolverInterceptor>> interceptors;

    public OperationExecutor(Operation operation, ValueMapper valueMapper, GlobalEnvironment globalEnvironment, ResolverInterceptorFactory interceptorFactory) {
        this.operation = operation;
        this.valueMapper = valueMapper;
        this.globalEnvironment = globalEnvironment;
        this.converterRegistry = this.filterConverters(globalEnvironment.converters);
        this.interceptors = operation.getResolvers().stream().collect(Collectors.toMap(Function.identity(), res -> interceptorFactory.getInterceptors(new ResolverInterceptorFactoryParams((Resolver)res))));
    }

    public Object execute(DataFetchingEnvironment env) throws Exception {
        Map arguments;
        Resolver resolver;
        if (env.getContext() instanceof ContextWrapper) {
            ContextWrapper context = (ContextWrapper)env.getContext();
            if (env.getArgument("clientMutationId") != null) {
                context.setClientMutationId((String)env.getArgument("clientMutationId"));
            }
        }
        if ((resolver = this.operation.getApplicableResolver((arguments = env.getArguments()).keySet())) == null) {
            throw new GraphQLException("Resolver for operation " + this.operation.getName() + " accepting arguments: " + arguments.keySet() + " not implemented");
        }
        ResolutionEnvironment resolutionEnvironment = new ResolutionEnvironment(env, this.valueMapper, this.globalEnvironment, this.converterRegistry);
        try {
            Object result = this.execute(resolver, resolutionEnvironment, arguments);
            return resolutionEnvironment.convertOutput(result, resolver.getReturnType());
        }
        catch (ReflectiveOperationException e) {
            OperationExecutor.sneakyThrow(this.unwrap(e));
            return null;
        }
    }

    private Object execute(Resolver resolver, ResolutionEnvironment resolutionEnvironment, Map<String, Object> rawArguments) throws Exception {
        int queryArgumentsCount = resolver.getArguments().size();
        Object[] args = new Object[queryArgumentsCount];
        for (int i = 0; i < queryArgumentsCount; ++i) {
            OperationArgument argDescriptor = resolver.getArguments().get(i);
            Object rawArgValue = rawArguments.get(argDescriptor.getName());
            args[i] = resolutionEnvironment.getInputValue(rawArgValue, argDescriptor);
        }
        InvocationContext invocationContext = new InvocationContext(this.operation, resolver, resolutionEnvironment, args);
        LinkedList<ResolverInterceptor> interceptors = new LinkedList<ResolverInterceptor>((Collection)this.interceptors.get(resolver));
        interceptors.add((ctx, cont) -> resolver.resolve(ctx.getResolutionEnvironment().context, ctx.getArguments()));
        return this.execute(invocationContext, interceptors);
    }

    private Object execute(InvocationContext context, Queue<ResolverInterceptor> interceptors) throws Exception {
        return interceptors.remove().aroundInvoke(context, ctx -> this.execute(ctx, interceptors));
    }

    private ConverterRegistry filterConverters(ConverterRegistry converters) {
        return this.operation.getResolvers().stream().allMatch(res -> this.globalEnvironment.converters.getOutputConverter(res.getReturnType()) == null) ? new ConverterRegistry(converters.getInputConverters(), Collections.emptyList()) : converters;
    }

    private Throwable unwrap(ReflectiveOperationException e) {
        Throwable cause = e.getCause();
        if (cause != null && cause != e) {
            return cause;
        }
        return e;
    }

    private static <T extends Throwable> void sneakyThrow(Throwable t) throws T {
        throw t;
    }
}

