/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import graphql.Scalars;
import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.PropertyDataFetcher;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.ContextWrapper;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.OperationExecutor;
import io.leangen.graphql.execution.ResolverInterceptorFactory;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.MappedType;
import io.leangen.graphql.generator.RelayDataFetchingEnvironmentDecorator;
import io.leangen.graphql.generator.RelayMappingConfig;
import io.leangen.graphql.generator.TypeRegistry;
import io.leangen.graphql.generator.Validator;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.metadata.Directive;
import io.leangen.graphql.metadata.DirectiveArgument;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.OperationArgument;
import io.leangen.graphql.metadata.TypedElement;
import io.leangen.graphql.metadata.exceptions.MappingException;
import io.leangen.graphql.metadata.strategy.query.DirectiveBuilderParams;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.util.Directives;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationMapper {
    private List<GraphQLFieldDefinition> queries;
    private List<GraphQLFieldDefinition> mutations;
    private List<GraphQLFieldDefinition> subscriptions;
    private List<GraphQLDirective> directives;
    private static final Logger log = LoggerFactory.getLogger(OperationMapper.class);

    public OperationMapper(BuildContext buildContext) {
        this.queries = this.generateQueries(buildContext);
        this.mutations = this.generateMutations(buildContext);
        this.subscriptions = this.generateSubscriptions(buildContext);
        this.directives = this.generateDirectives(buildContext);
    }

    private List<GraphQLFieldDefinition> generateQueries(BuildContext buildContext) {
        Map<String, String> nodeQueriesByType;
        ArrayList<Operation> rootQueries = new ArrayList<Operation>(buildContext.operationRegistry.getRootQueries());
        List<GraphQLFieldDefinition> queries = rootQueries.stream().map(query -> this.toGraphQLField((Operation)query, buildContext)).collect(Collectors.toList());
        buildContext.resolveTypeReferences();
        if (rootQueries.stream().noneMatch(query -> query.getName().equals("node")) && !(nodeQueriesByType = this.getNodeQueriesByType(rootQueries, queries, buildContext.typeRegistry, buildContext.node, buildContext)).isEmpty()) {
            queries.add(buildContext.relay.nodeField(buildContext.node, this.createNodeResolver(nodeQueriesByType, buildContext.relay)));
        }
        return queries;
    }

    private List<GraphQLFieldDefinition> generateMutations(BuildContext buildContext) {
        Collection<Operation> mutations = buildContext.operationRegistry.getMutations();
        return mutations.stream().map(mutation -> buildContext.relayMappingConfig.relayCompliantMutations ? this.toRelayMutation(this.toGraphQLField((Operation)mutation, buildContext), buildContext.relayMappingConfig) : this.toGraphQLField((Operation)mutation, buildContext)).collect(Collectors.toList());
    }

    private List<GraphQLFieldDefinition> generateSubscriptions(BuildContext buildContext) {
        return buildContext.operationRegistry.getSubscriptions().stream().map(subscription -> this.toGraphQLField((Operation)subscription, buildContext)).collect(Collectors.toList());
    }

    private List<GraphQLDirective> generateDirectives(BuildContext buildContext) {
        return buildContext.additionalDirectives.stream().map(directiveType -> buildContext.directiveBuilder.buildClientDirective((AnnotatedType)directiveType, buildContext.directiveBuilderParams())).map(directive -> this.toGraphQLDirective((Directive)directive, buildContext)).collect(Collectors.toList());
    }

    public GraphQLFieldDefinition toGraphQLField(Operation operation, BuildContext buildContext) {
        GraphQLOutputType type = this.toGraphQLType(operation.getJavaType(), buildContext);
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription()).deprecate(operation.getDeprecationReason()).type(type).withDirective(Directives.mappedOperation(operation)).withDirectives(this.toGraphQLDirectives(operation.getTypedElement(), buildContext.directiveBuilder::buildFieldDefinitionDirectives, buildContext));
        List<GraphQLArgument> arguments = operation.getArguments().stream().filter(OperationArgument::isMappable).map(argument -> this.toGraphQLArgument((OperationArgument)argument, buildContext)).collect(Collectors.toList());
        fieldBuilder.argument(arguments);
        if (GraphQLUtils.isRelayConnectionType((GraphQLType)type) && buildContext.relayMappingConfig.strictConnectionSpec) {
            this.validateConnectionSpecCompliance(operation.getName(), arguments, buildContext.relay);
        }
        Stream<AnnotatedType> inputTypes = operation.getArguments().stream().filter(OperationArgument::isMappable).map(OperationArgument::getJavaType);
        ValueMapper valueMapper = buildContext.createValueMapper(inputTypes);
        fieldBuilder.dataFetcher(this.createResolver(operation, valueMapper, buildContext.globalEnvironment, buildContext.interceptorFactory));
        return buildContext.transformers.transform(fieldBuilder.build(), operation, this, buildContext);
    }

    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, BuildContext buildContext) {
        return this.toGraphQLType(javaType, new HashSet<Class<? extends TypeMapper>>(), buildContext);
    }

    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, Set<Class<? extends TypeMapper>> mappersToSkip, BuildContext buildContext) {
        GraphQLOutputType type = buildContext.typeMappers.getTypeMapper(javaType, mappersToSkip).toGraphQLType(javaType, this, mappersToSkip, buildContext);
        this.log(buildContext.validator.checkUniqueness(type, javaType));
        buildContext.typeCache.completeType(type);
        return type;
    }

    public GraphQLInputObjectField toGraphQLInputField(InputField inputField, BuildContext buildContext) {
        GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField().name(inputField.getName()).description(inputField.getDescription()).type(this.toGraphQLInputType(inputField.getJavaType(), buildContext)).withDirectives(this.toGraphQLDirectives(inputField.getTypedElement(), buildContext.directiveBuilder::buildInputFieldDefinitionDirectives, buildContext)).defaultValue(inputField.getDefaultValue());
        return buildContext.transformers.transform(builder.build(), inputField, this, buildContext);
    }

    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, BuildContext buildContext) {
        return this.toGraphQLInputType(javaType, new HashSet<Class<? extends TypeMapper>>(), buildContext);
    }

    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, Set<Class<? extends TypeMapper>> mappersToSkip, BuildContext buildContext) {
        GraphQLInputType type = buildContext.typeMappers.getTypeMapper(javaType, mappersToSkip).toGraphQLInputType(javaType, this, mappersToSkip, buildContext);
        this.log(buildContext.validator.checkUniqueness(type, javaType));
        return type;
    }

    private GraphQLArgument toGraphQLArgument(OperationArgument operationArgument, BuildContext buildContext) {
        GraphQLArgument argument = GraphQLArgument.newArgument().name(operationArgument.getName()).description(operationArgument.getDescription()).type(this.toGraphQLInputType(operationArgument.getJavaType(), buildContext)).defaultValue(operationArgument.getDefaultValue()).withDirectives(this.toGraphQLDirectives(operationArgument.getTypedElement(), buildContext.directiveBuilder::buildArgumentDefinitionDirectives, buildContext)).build();
        return buildContext.transformers.transform(argument, operationArgument, this, buildContext);
    }

    private GraphQLDirective[] toGraphQLDirectives(TypedElement element, BiFunction<AnnotatedElement, DirectiveBuilderParams, List<Directive>> directiveBuilder, BuildContext buildContext) {
        return (GraphQLDirective[])element.getElements().stream().flatMap(el -> ((List)directiveBuilder.apply((AnnotatedElement)el, buildContext.directiveBuilderParams())).stream()).map(directive -> this.toGraphQLDirective((Directive)directive, buildContext)).toArray(GraphQLDirective[]::new);
    }

    public GraphQLDirective toGraphQLDirective(Directive directive, BuildContext buildContext) {
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(directive.getName()).description(directive.getDescription()).validLocations(directive.getLocations());
        directive.getArguments().forEach(arg -> builder.argument(this.toGraphQLArgument((DirectiveArgument)arg, buildContext)));
        return buildContext.transformers.transform(builder.build(), directive, this, buildContext);
    }

    private GraphQLArgument toGraphQLArgument(DirectiveArgument directiveArgument, BuildContext buildContext) {
        GraphQLArgument argument = GraphQLArgument.newArgument().name(directiveArgument.getName()).description(directiveArgument.getDescription()).type(this.toGraphQLInputType(directiveArgument.getJavaType(), buildContext)).value(directiveArgument.getValue()).defaultValue(directiveArgument.getDefaultValue()).withDirectives(this.toGraphQLDirectives(directiveArgument.getTypedElement(), buildContext.directiveBuilder::buildArgumentDefinitionDirectives, buildContext)).build();
        return buildContext.transformers.transform(argument, directiveArgument, this, buildContext);
    }

    private GraphQLFieldDefinition toRelayMutation(GraphQLFieldDefinition mutation, RelayMappingConfig relayMappingConfig) {
        List<GraphQLFieldDefinition> outputFields;
        if (mutation.getType() instanceof GraphQLObjectType) {
            outputFields = ((GraphQLObjectType)mutation.getType()).getFieldDefinitions();
        } else {
            outputFields = new ArrayList();
            outputFields.add(GraphQLFieldDefinition.newFieldDefinition().name(relayMappingConfig.wrapperFieldName).description(relayMappingConfig.wrapperFieldDescription).type(mutation.getType()).dataFetcher(DataFetchingEnvironment::getSource).build());
        }
        List inputFields = mutation.getArguments().stream().map(arg -> GraphQLInputObjectField.newInputObjectField().name(arg.getName()).description(arg.getDescription()).type(arg.getType()).defaultValue(arg.getDefaultValue()).build()).collect(Collectors.toList());
        GraphQLInputObjectType inputObjectType = GraphQLInputObjectType.newInputObject().name(mutation.getName() + "Input").field(GraphQLInputObjectField.newInputObjectField().name("clientMutationId").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString))).fields(inputFields).build();
        GraphQLObjectType outputType = GraphQLObjectType.newObject().name(mutation.getName() + "Payload").field(GraphQLFieldDefinition.newFieldDefinition().name("clientMutationId").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).dataFetcher(env -> env.getContext() instanceof ContextWrapper ? ((ContextWrapper)env.getContext()).getClientMutationId() : new PropertyDataFetcher("clientMutationId"))).fields(outputFields).build();
        return GraphQLFieldDefinition.newFieldDefinition().name(mutation.getName()).type((GraphQLOutputType)outputType).argument(GraphQLArgument.newArgument().name("input").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)inputObjectType))).dataFetcher(env -> {
            RelayDataFetchingEnvironmentDecorator innerEnv = new RelayDataFetchingEnvironmentDecorator(env);
            if (env.getContext() instanceof ContextWrapper) {
                ContextWrapper context = (ContextWrapper)env.getContext();
                context.setClientMutationId((String)innerEnv.getArgument("clientMutationId"));
            }
            return mutation.getDataFetcher().get((DataFetchingEnvironment)innerEnv);
        }).build();
    }

    private DataFetcher createResolver(Operation operation, ValueMapper valueMapper, GlobalEnvironment globalEnvironment, ResolverInterceptorFactory interceptorFactory) {
        if (operation.isBatched()) {
            return environment -> new OperationExecutor(operation, valueMapper, globalEnvironment, interceptorFactory).execute(environment);
        }
        return new OperationExecutor(operation, valueMapper, globalEnvironment, interceptorFactory)::execute;
    }

    private DataFetcher createNodeResolver(Map<String, String> nodeQueriesByType, Relay relay) {
        return env -> {
            String typeName;
            try {
                typeName = relay.fromGlobalId((String)env.getArgument("id")).getType();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(env.getArgument("id") + " is not a valid Relay node ID");
            }
            if (!nodeQueriesByType.containsKey(typeName)) {
                throw new IllegalArgumentException(typeName + " is not a Relay node type or no registered query can fetch it by ID");
            }
            return env.getGraphQLSchema().getQueryType().getFieldDefinition((String)nodeQueriesByType.get(typeName)).getDataFetcher().get(env);
        };
    }

    private Map<String, String> getNodeQueriesByType(List<Operation> queries, List<GraphQLFieldDefinition> graphQlQueries, TypeRegistry typeRegistry, GraphQLInterfaceType node, BuildContext buildContext) {
        HashMap<String, String> nodeQueriesByType = new HashMap<String, String>();
        for (int i = 0; i < queries.size(); ++i) {
            Operation query = queries.get(i);
            GraphQLFieldDefinition graphQlQuery = graphQlQueries.get(i);
            if (graphQlQuery.getArgument("id") == null || !GraphQLUtils.isRelayId(graphQlQuery.getArgument("id")) || query.getResolver("id") == null) continue;
            GraphQLType unwrappedQueryType = GraphQLUtils.unwrapNonNull((GraphQLType)graphQlQuery.getType());
            if ((unwrappedQueryType = buildContext.typeCache.resolveType(unwrappedQueryType.getName())) instanceof GraphQLObjectType && ((GraphQLObjectType)unwrappedQueryType).getInterfaces().contains(node)) {
                nodeQueriesByType.put(unwrappedQueryType.getName(), query.getName());
                continue;
            }
            if (unwrappedQueryType instanceof GraphQLInterfaceType) {
                typeRegistry.getOutputTypes(unwrappedQueryType.getName()).stream().map(MappedType::getAsObjectType).filter(implementation -> implementation.getInterfaces().contains(node)).forEach(nodeType -> nodeQueriesByType.putIfAbsent(nodeType.getName(), query.getName()));
                continue;
            }
            if (!(unwrappedQueryType instanceof GraphQLUnionType)) continue;
            typeRegistry.getOutputTypes(unwrappedQueryType.getName()).stream().map(MappedType::getAsObjectType).filter(implementation -> implementation.getInterfaces().contains(node)).filter(Directives::isMappedType).filter(implementation -> GenericTypeReflector.isSuperType((Type)query.getResolver("id").getReturnType().getType(), (Type)Directives.getMappedType((GraphQLType)implementation).getType())).forEach(nodeType -> nodeQueriesByType.putIfAbsent(nodeType.getName(), query.getName()));
        }
        return nodeQueriesByType;
    }

    private void log(Validator.ValidationResult result) {
        if (!result.isValid()) {
            log.warn(result.getMessage());
        }
    }

    private void validateConnectionSpecCompliance(String operationName, List<GraphQLArgument> arguments, Relay relay) {
        String errorMessageTemplate = "Operation '" + operationName + "' is incompatible with the Relay Connection spec due to %s. If this is intentional, disable strict compliance checking. For details and solutions see " + "https://github.com/leangen/graphql-spqr/wiki/Errors#relay-connection-spec-violation";
        boolean forwardPageSupported = relay.getForwardPaginationConnectionFieldArguments().stream().allMatch(specArg -> arguments.stream().anyMatch(arg -> arg.getName().equals(specArg.getName())));
        boolean backwardPageSupported = relay.getBackwardPaginationConnectionFieldArguments().stream().allMatch(specArg -> arguments.stream().anyMatch(arg -> arg.getName().equals(specArg.getName())));
        if (!forwardPageSupported && !backwardPageSupported) {
            throw new MappingException(String.format(errorMessageTemplate, "required arguments missing"));
        }
        if (relay.getConnectionFieldArguments().stream().anyMatch(specArg -> arguments.stream().anyMatch(arg -> arg.getName().equals(specArg.getName()) && !GraphQLUtils.unwrap((GraphQLType)arg.getType()).getName().equals(specArg.getType().getName())))) {
            throw new MappingException(String.format(errorMessageTemplate, "argument type mismatch"));
        }
    }

    public List<GraphQLFieldDefinition> getQueries() {
        return this.queries;
    }

    public List<GraphQLFieldDefinition> getMutations() {
        return this.mutations;
    }

    public List<GraphQLFieldDefinition> getSubscriptions() {
        return this.subscriptions;
    }

    public List<GraphQLDirective> getDirectives() {
        return this.directives;
    }
}

