/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import graphql.execution.batched.Batched;
import io.leangen.graphql.annotations.GraphQLComplexity;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLSubscription;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.metadata.execution.FieldAccessor;
import io.leangen.graphql.metadata.execution.MethodInvoker;
import io.leangen.graphql.metadata.execution.SingletonMethodInvoker;
import io.leangen.graphql.metadata.messages.MessageBundle;
import io.leangen.graphql.metadata.strategy.InclusionStrategy;
import io.leangen.graphql.metadata.strategy.query.AnnotatedArgumentBuilder;
import io.leangen.graphql.metadata.strategy.query.ArgumentBuilderParams;
import io.leangen.graphql.metadata.strategy.query.DefaultOperationNameGenerator;
import io.leangen.graphql.metadata.strategy.query.FilteredResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.OperationNameGeneratorParams;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilderParams;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.ReservedStrings;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AnnotatedResolverBuilder
extends FilteredResolverBuilder {
    public AnnotatedResolverBuilder() {
        this.operationNameGenerator = new DefaultOperationNameGenerator();
        this.argumentBuilder = new AnnotatedArgumentBuilder();
        this.withDefaultFilters();
    }

    @Override
    public Collection<Resolver> buildQueryResolvers(ResolverBuilderParams params) {
        MessageBundle messageBundle = params.getEnvironment().messageBundle;
        Stream<Resolver> methodInvokers = this.buildResolvers(params, GraphQLQuery.class, this.operationNameGenerator::generateQueryName, true).stream();
        AnnotatedType beanType = params.getBeanType();
        Stream<Resolver> fieldAccessors = ClassUtils.getAnnotatedFields(ClassUtils.getRawType(beanType.getType()), GraphQLQuery.class).stream().filter(this.getFilters().stream().reduce(Predicate::and).orElse(ACCEPT_ALL)).filter(field -> params.getInclusionStrategy().includeOperation((AnnotatedElement)field, this.getFieldType((Field)field, params))).map(field -> new Resolver(this.operationNameGenerator.generateQueryName(new OperationNameGeneratorParams<Field>((Field)field, beanType, params.getQuerySourceBean(), messageBundle)), messageBundle.interpolate(field.getAnnotation(GraphQLQuery.class).description()), messageBundle.interpolate(ReservedStrings.decode(field.getAnnotation(GraphQLQuery.class).deprecationReason())), false, new FieldAccessor((Field)field, beanType), this.getFieldType((Field)field, params), Collections.emptyList(), field.isAnnotationPresent(GraphQLComplexity.class) ? field.getAnnotation(GraphQLComplexity.class).value() : null));
        return Stream.concat(methodInvokers, fieldAccessors).collect(Collectors.toSet());
    }

    @Override
    public Collection<Resolver> buildMutationResolvers(ResolverBuilderParams params) {
        return this.buildResolvers(params, GraphQLMutation.class, this.operationNameGenerator::generateMutationName, false);
    }

    @Override
    public Collection<Resolver> buildSubscriptionResolvers(ResolverBuilderParams params) {
        return this.buildResolvers(params, GraphQLSubscription.class, this.operationNameGenerator::generateSubscriptionName, false);
    }

    private Collection<Resolver> buildResolvers(ResolverBuilderParams params, Class<? extends Annotation> annotation, Function<OperationNameGeneratorParams, String> nameGenerator, boolean batchable) {
        AnnotatedType beanType = params.getBeanType();
        Object querySourceBean = params.getQuerySourceBean();
        InclusionStrategy inclusionStrategy = params.getInclusionStrategy();
        MessageBundle messageBundle = params.getEnvironment().messageBundle;
        return ClassUtils.getAnnotatedMethods(ClassUtils.getRawType(beanType.getType()), annotation).stream().filter(this.getFilters().stream().reduce(Predicate::and).orElse(ACCEPT_ALL)).filter(method -> inclusionStrategy.includeOperation((AnnotatedElement)method, this.getReturnType((Method)method, params))).map(method -> new Resolver((String)nameGenerator.apply(new OperationNameGeneratorParams<Method>((Method)method, beanType, querySourceBean, messageBundle)), this.description((Annotation)method.getAnnotation(annotation), messageBundle), ReservedStrings.decode(this.deprecationReason((Annotation)method.getAnnotation(annotation), messageBundle)), batchable && method.isAnnotationPresent(Batched.class), querySourceBean == null ? new MethodInvoker((Method)method, beanType) : new SingletonMethodInvoker(querySourceBean, (Method)method, beanType), this.getReturnType((Method)method, params), this.argumentBuilder.buildResolverArguments(new ArgumentBuilderParams((Method)method, beanType, inclusionStrategy, params.getTypeTransformer(), params.getEnvironment())), method.isAnnotationPresent(GraphQLComplexity.class) ? method.getAnnotation(GraphQLComplexity.class).value() : null)).collect(Collectors.toSet());
    }

    private String description(Annotation annotation, MessageBundle messageBundle) {
        if (annotation instanceof GraphQLQuery) {
            return messageBundle.interpolate(((GraphQLQuery)annotation).description());
        }
        if (annotation instanceof GraphQLMutation) {
            return messageBundle.interpolate(((GraphQLMutation)annotation).description());
        }
        if (annotation instanceof GraphQLSubscription) {
            return messageBundle.interpolate(((GraphQLSubscription)annotation).description());
        }
        throw new IllegalArgumentException("Invalid operation annotations " + annotation);
    }

    private String deprecationReason(Annotation annotation, MessageBundle messageBundle) {
        if (annotation instanceof GraphQLQuery) {
            return messageBundle.interpolate(((GraphQLQuery)annotation).deprecationReason());
        }
        if (annotation instanceof GraphQLMutation) {
            return messageBundle.interpolate(((GraphQLMutation)annotation).deprecationReason());
        }
        if (annotation instanceof GraphQLSubscription) {
            return messageBundle.interpolate(((GraphQLSubscription)annotation).deprecationReason());
        }
        throw new IllegalArgumentException("Invalid operation annotations " + annotation);
    }

    public int hashCode() {
        return Objects.hash(this.operationNameGenerator.getClass(), this.argumentBuilder.getClass());
    }

    public boolean equals(Object other) {
        if (!(other instanceof AnnotatedResolverBuilder)) {
            return false;
        }
        AnnotatedResolverBuilder that = (AnnotatedResolverBuilder)other;
        return this.operationNameGenerator.getClass().equals(that.operationNameGenerator.getClass()) && this.argumentBuilder.getClass().equals(that.argumentBuilder.getClass());
    }
}

