/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchReply<K, V> {
    private long count;
    private final List<SearchResult<K, V>> results;
    private Long cursorId;
    private final List<V> warnings = new ArrayList<V>();

    public SearchReply() {
        this.count = 0L;
        this.results = new ArrayList<SearchResult<K, V>>();
        this.cursorId = null;
    }

    SearchReply(long count, List<SearchResult<K, V>> results) {
        this.count = count;
        this.results = new ArrayList<SearchResult<K, V>>(results);
        this.cursorId = null;
    }

    public long getCount() {
        return this.count;
    }

    void setCount(long count) {
        this.count = count;
    }

    public List<SearchResult<K, V>> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public void addResult(SearchResult<K, V> result) {
        this.results.add(result);
    }

    public int size() {
        return this.results.size();
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public Long getCursorId() {
        return this.cursorId;
    }

    public List<V> getWarnings() {
        return this.warnings;
    }

    void setCursorId(Long cursorId) {
        this.cursorId = cursorId;
    }

    void addWarning(V v) {
        this.warnings.add(v);
    }

    public static class SearchResult<K, V> {
        private final K id;
        private Double score;
        private V payload;
        private V sortKey;
        private final Map<K, V> fields = new HashMap();

        public SearchResult(K id) {
            this.id = id;
        }

        public SearchResult() {
            this.id = null;
        }

        public K getId() {
            return this.id;
        }

        public Double getScore() {
            return this.score;
        }

        void setScore(Double score) {
            this.score = score;
        }

        public V getPayload() {
            return this.payload;
        }

        void setPayload(V payload) {
            this.payload = payload;
        }

        public V getSortKey() {
            return this.sortKey;
        }

        void setSortKey(V sortKey) {
            this.sortKey = sortKey;
        }

        public Map<K, V> getFields() {
            return this.fields;
        }

        public void addFields(Map<K, V> fields) {
            this.fields.putAll(fields);
        }

        public void addFields(K key, V value) {
            this.fields.put(key, value);
        }
    }
}

