/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.search.arguments.DocumentLanguage;
import io.lettuce.core.search.arguments.HighlightArgs;
import io.lettuce.core.search.arguments.QueryDialects;
import io.lettuce.core.search.arguments.ScoringFunction;
import io.lettuce.core.search.arguments.SortByArgs;
import io.lettuce.core.search.arguments.SummarizeArgs;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SearchArgs<K, V> {
    private boolean noContent = false;
    private boolean verbatim = false;
    private boolean withScores = false;
    private boolean withSortKeys = false;
    private final List<K> inKeys = new ArrayList<K>();
    private final List<K> inFields = new ArrayList<K>();
    private final Map<K, Optional<K>> returnFields = new HashMap<K, Optional<K>>();
    private Optional<SummarizeArgs<K, V>> summarize = Optional.empty();
    private Optional<HighlightArgs<K, V>> highlight = Optional.empty();
    private Long slop;
    private boolean inOrder = false;
    private Optional<DocumentLanguage> language = Optional.empty();
    private Optional<V> expander = Optional.empty();
    private Optional<ScoringFunction> scorer = Optional.empty();
    private Optional<SortByArgs<K>> sortBy = Optional.empty();
    private Optional<Limit> limit = Optional.empty();
    private Optional<Duration> timeout = Optional.empty();
    private final Map<K, V> params = new HashMap();
    private QueryDialects dialect = QueryDialects.DIALECT2;

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public boolean isNoContent() {
        return this.noContent;
    }

    public boolean isWithScores() {
        return this.withScores;
    }

    public boolean isWithSortKeys() {
        return this.withSortKeys;
    }

    public void build(CommandArgs<K, V> args) {
        if (this.noContent) {
            args.add(CommandKeyword.NOCONTENT);
        }
        if (this.verbatim) {
            args.add(CommandKeyword.VERBATIM);
        }
        if (this.withScores) {
            args.add(CommandKeyword.WITHSCORES);
        }
        if (this.withSortKeys) {
            args.add(CommandKeyword.WITHSORTKEYS);
        }
        if (!this.inKeys.isEmpty()) {
            args.add(CommandKeyword.INKEYS);
            args.add(this.inKeys.size());
            args.addKeys((Iterable<K>)this.inKeys);
        }
        if (!this.inFields.isEmpty()) {
            args.add(CommandKeyword.INFIELDS);
            args.add(this.inFields.size());
            args.addKeys((Iterable<K>)this.inFields);
        }
        if (!this.returnFields.isEmpty()) {
            args.add(CommandKeyword.RETURN);
            int count = this.returnFields.size();
            args.add(count += (int)(this.returnFields.values().stream().filter(Optional::isPresent).count() * 2L));
            this.returnFields.forEach((field, as) -> {
                args.addKey(field);
                if (as.isPresent()) {
                    args.add(CommandKeyword.AS);
                    args.addKey(as.get());
                }
            });
        }
        this.summarize.ifPresent(summarizeArgs -> summarizeArgs.build(args));
        this.highlight.ifPresent(highlightArgs -> highlightArgs.build(args));
        if (this.slop != null) {
            args.add(CommandKeyword.SLOP);
            args.add(this.slop);
        }
        this.timeout.ifPresent(timeoutDuration -> {
            args.add(CommandKeyword.TIMEOUT);
            args.add(timeoutDuration.toMillis());
        });
        if (this.inOrder) {
            args.add(CommandKeyword.INORDER);
        }
        this.language.ifPresent(documentLanguage -> {
            args.add(CommandKeyword.LANGUAGE);
            args.add(documentLanguage.toString());
        });
        this.expander.ifPresent(v -> {
            args.add(CommandKeyword.EXPANDER);
            args.addValue(v);
        });
        this.scorer.ifPresent(scoringFunction -> {
            args.add(CommandKeyword.SCORER);
            args.add(scoringFunction.toString());
        });
        this.sortBy.ifPresent(sortByArgs -> sortByArgs.build(args));
        this.limit.ifPresent(limitArgs -> {
            args.add(CommandKeyword.LIMIT);
            args.add(((Limit)limitArgs).offset);
            args.add(((Limit)limitArgs).num);
        });
        if (!this.params.isEmpty()) {
            args.add(CommandKeyword.PARAMS);
            args.add((long)this.params.size() * 2L);
            this.params.forEach((name, value) -> {
                args.addKey(name);
                args.addValue(value);
            });
        }
        args.add(CommandKeyword.DIALECT);
        args.add(this.dialect.toString());
    }

    static class Limit {
        private final long offset;
        private final long num;

        Limit(long offset, long num) {
            this.offset = offset;
            this.num = num;
        }
    }

    public static class Builder<K, V> {
        private final SearchArgs<K, V> instance = new SearchArgs();
        private SummarizeArgs.Builder<K, V> summarizeArgs;
        private HighlightArgs.Builder<K, V> highlightArgs;

        public SearchArgs<K, V> build() {
            if (!((SearchArgs)this.instance).summarize.isPresent() && this.summarizeArgs != null) {
                ((SearchArgs)this.instance).summarize = Optional.of(this.summarizeArgs.build());
            }
            if (!((SearchArgs)this.instance).highlight.isPresent() && this.highlightArgs != null) {
                ((SearchArgs)this.instance).highlight = Optional.of(this.highlightArgs.build());
            }
            return this.instance;
        }

        public Builder<K, V> noContent() {
            ((SearchArgs)this.instance).noContent = true;
            return this;
        }

        public Builder<K, V> verbatim() {
            ((SearchArgs)this.instance).verbatim = true;
            return this;
        }

        public Builder<K, V> withScores() {
            ((SearchArgs)this.instance).withScores = true;
            return this;
        }

        public Builder<K, V> withSortKeys() {
            ((SearchArgs)this.instance).withSortKeys = true;
            return this;
        }

        public Builder<K, V> inKey(K key) {
            ((SearchArgs)this.instance).inKeys.add(key);
            return this;
        }

        public Builder<K, V> inField(K field) {
            ((SearchArgs)this.instance).inFields.add(field);
            return this;
        }

        public Builder<K, V> returnField(K field, K as) {
            ((SearchArgs)this.instance).returnFields.put(field, Optional.ofNullable(as));
            return this;
        }

        public Builder<K, V> returnField(K field) {
            ((SearchArgs)this.instance).returnFields.put(field, Optional.empty());
            return this;
        }

        public Builder<K, V> summarizeArgs(SummarizeArgs<K, V> summarizeFilter) {
            ((SearchArgs)this.instance).summarize = Optional.ofNullable(summarizeFilter);
            return this;
        }

        public Builder<K, V> summarizeField(K field) {
            if (this.summarizeArgs == null) {
                this.summarizeArgs = new SummarizeArgs.Builder();
            }
            this.summarizeArgs.field(field);
            return this;
        }

        public Builder<K, V> summarizeLen(long len) {
            if (this.summarizeArgs == null) {
                this.summarizeArgs = new SummarizeArgs.Builder();
            }
            this.summarizeArgs.len(len);
            return this;
        }

        public Builder<K, V> summarizeSeparator(V separator) {
            if (this.summarizeArgs == null) {
                this.summarizeArgs = new SummarizeArgs.Builder();
            }
            this.summarizeArgs.separator(separator);
            return this;
        }

        public Builder<K, V> summarizeFragments(long fragments) {
            if (this.summarizeArgs == null) {
                this.summarizeArgs = new SummarizeArgs.Builder();
            }
            this.summarizeArgs.fragments(fragments);
            return this;
        }

        public Builder<K, V> highlightArgs(HighlightArgs<K, V> highlightFilter) {
            ((SearchArgs)this.instance).highlight = Optional.ofNullable(highlightFilter);
            return this;
        }

        public Builder<K, V> highlightField(K field) {
            if (this.highlightArgs == null) {
                this.highlightArgs = new HighlightArgs.Builder();
            }
            this.highlightArgs.field(field);
            return this;
        }

        public Builder<K, V> highlightTags(V startTag, V endTag) {
            if (this.highlightArgs == null) {
                this.highlightArgs = new HighlightArgs.Builder();
            }
            this.highlightArgs.tags(startTag, endTag);
            return this;
        }

        public Builder<K, V> slop(long slop) {
            ((SearchArgs)this.instance).slop = slop;
            return this;
        }

        public Builder<K, V> inOrder() {
            ((SearchArgs)this.instance).inOrder = true;
            return this;
        }

        public Builder<K, V> language(DocumentLanguage language) {
            ((SearchArgs)this.instance).language = Optional.ofNullable(language);
            return this;
        }

        public Builder<K, V> expander(V expander) {
            ((SearchArgs)this.instance).expander = Optional.ofNullable(expander);
            return this;
        }

        public Builder<K, V> scorer(ScoringFunction scorer) {
            ((SearchArgs)this.instance).scorer = Optional.ofNullable(scorer);
            return this;
        }

        public Builder<K, V> sortBy(SortByArgs<K> sortBy) {
            ((SearchArgs)this.instance).sortBy = Optional.ofNullable(sortBy);
            return this;
        }

        public Builder<K, V> limit(long offset, long number) {
            ((SearchArgs)this.instance).limit = Optional.of(new Limit(offset, number));
            return this;
        }

        public Builder<K, V> timeout(Duration timeout) {
            ((SearchArgs)this.instance).timeout = Optional.ofNullable(timeout);
            return this;
        }

        public Builder<K, V> param(K name, V value) {
            ((SearchArgs)this.instance).params.put(name, value);
            return this;
        }

        public Builder<K, V> dialect(QueryDialects dialect) {
            ((SearchArgs)this.instance).dialect = dialect;
            return this;
        }
    }
}

