/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.StartTimeOffset;
import io.lindstrom.m3u8.parser.Attribute;
import io.lindstrom.m3u8.parser.ParserUtils;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.util.Map;

enum StartTimeOffsetAttribute implements Attribute<StartTimeOffset, StartTimeOffset.Builder>
{
    TIME_OFFSET{

        @Override
        public void read(StartTimeOffset.Builder builder, String value) {
            builder.timeOffset(Double.parseDouble(value));
        }

        @Override
        public void write(StartTimeOffset value, TextBuilder textBuilder) {
            textBuilder.add(this.key(), String.valueOf(value.timeOffset()));
        }
    }
    ,
    PRECISE{

        @Override
        public void read(StartTimeOffset.Builder builder, String value) throws PlaylistParserException {
            builder.precise(ParserUtils.yesOrNo(value));
        }

        @Override
        public void write(StartTimeOffset value, TextBuilder textBuilder) {
            if (value.precise()) {
                textBuilder.add(this.name(), "YES");
            }
        }
    };

    static final Map<String, StartTimeOffsetAttribute> attributeMap;

    static StartTimeOffset parse(String attributes, ParsingMode parsingMode) throws PlaylistParserException {
        StartTimeOffset.Builder builder = StartTimeOffset.builder();
        ParserUtils.readAttributes(attributeMap, attributes, builder, parsingMode);
        return builder.build();
    }

    static {
        attributeMap = ParserUtils.toMap(StartTimeOffsetAttribute.values(), Attribute::key);
    }
}

