/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.model.chart;

import io.meeds.analytics.model.chart.ChartAggregationLabel;
import io.meeds.analytics.model.chart.ChartAggregationResult;
import io.meeds.analytics.model.chart.ChartAggregationValue;
import io.meeds.analytics.model.chart.ChartData;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class ChartDataList
implements Serializable {
    private static final long serialVersionUID = 5490607865795348987L;
    private String lang;
    private LinkedHashSet<ChartAggregationLabel> aggregationLabels = new LinkedHashSet();
    private LinkedHashSet<ChartData> charts = new LinkedHashSet();
    private long computingTime;
    private long dataCount;

    public ChartDataList(String lang) {
        this.lang = lang;
    }

    public ChartData addAggregationResult(ChartAggregationValue chartParentAggregation, ChartAggregationResult aggregationResult) {
        ChartData chartData;
        ChartAggregationLabel chartLabel = aggregationResult.retrieveChartLabel();
        if (!this.aggregationLabels.contains(chartLabel)) {
            this.aggregationLabels.add(chartLabel);
        }
        if ((chartData = (ChartData)this.charts.stream().filter(data -> data.getKey() == null && chartParentAggregation == null || data.getKey() != null && data.getKey().equals(chartParentAggregation)).findFirst().orElse(null)) == null) {
            ArrayList<ChartAggregationResult> results = new ArrayList<ChartAggregationResult>();
            chartData = new ChartData(chartParentAggregation, results, this.lang, null);
            String chartValue = chartData.getChartValue();
            String chartKey = chartData.getChartKey();
            String label = AnalyticsUtils.compueLabel(chartKey, chartValue);
            chartData.setChartLabel(label);
            this.charts.add(chartData);
        }
        chartData.addAggregationResult(aggregationResult, -1, true);
        return chartData;
    }

    public List<String> getLabels() {
        return this.aggregationLabels.stream().map(result -> result.getLabel()).toList();
    }

    public String getLang() {
        return this.lang;
    }

    public LinkedHashSet<ChartAggregationLabel> getAggregationLabels() {
        return this.aggregationLabels;
    }

    public LinkedHashSet<ChartData> getCharts() {
        return this.charts;
    }

    public long getComputingTime() {
        return this.computingTime;
    }

    public long getDataCount() {
        return this.dataCount;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setAggregationLabels(LinkedHashSet<ChartAggregationLabel> aggregationLabels) {
        this.aggregationLabels = aggregationLabels;
    }

    public void setCharts(LinkedHashSet<ChartData> charts) {
        this.charts = charts;
    }

    public void setComputingTime(long computingTime) {
        this.computingTime = computingTime;
    }

    public void setDataCount(long dataCount) {
        this.dataCount = dataCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartDataList)) {
            return false;
        }
        ChartDataList other = (ChartDataList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getComputingTime() != other.getComputingTime()) {
            return false;
        }
        if (this.getDataCount() != other.getDataCount()) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        LinkedHashSet<ChartAggregationLabel> this$aggregationLabels = this.getAggregationLabels();
        LinkedHashSet<ChartAggregationLabel> other$aggregationLabels = other.getAggregationLabels();
        if (this$aggregationLabels == null ? other$aggregationLabels != null : !((Object)this$aggregationLabels).equals(other$aggregationLabels)) {
            return false;
        }
        LinkedHashSet<ChartData> this$charts = this.getCharts();
        LinkedHashSet<ChartData> other$charts = other.getCharts();
        return !(this$charts == null ? other$charts != null : !((Object)this$charts).equals(other$charts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChartDataList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $computingTime = this.getComputingTime();
        result = result * 59 + (int)($computingTime >>> 32 ^ $computingTime);
        long $dataCount = this.getDataCount();
        result = result * 59 + (int)($dataCount >>> 32 ^ $dataCount);
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        LinkedHashSet<ChartAggregationLabel> $aggregationLabels = this.getAggregationLabels();
        result = result * 59 + ($aggregationLabels == null ? 43 : ((Object)$aggregationLabels).hashCode());
        LinkedHashSet<ChartData> $charts = this.getCharts();
        result = result * 59 + ($charts == null ? 43 : ((Object)$charts).hashCode());
        return result;
    }

    public String toString() {
        return "ChartDataList(lang=" + this.getLang() + ", aggregationLabels=" + String.valueOf(this.getAggregationLabels()) + ", charts=" + String.valueOf(this.getCharts()) + ", computingTime=" + this.getComputingTime() + ", dataCount=" + this.getDataCount() + ")";
    }
}

