/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.model.filter;

import io.meeds.analytics.model.filter.AbstractAnalyticsFilter;
import io.meeds.analytics.model.filter.AnalyticsFilter;
import io.meeds.analytics.model.filter.AnalyticsPercentageItemFilter;
import io.meeds.analytics.model.filter.AnalyticsPeriod;
import io.meeds.analytics.model.filter.AnalyticsPeriodType;
import io.meeds.analytics.model.filter.aggregation.AnalyticsAggregation;
import io.meeds.analytics.model.filter.aggregation.AnalyticsAggregationType;
import io.meeds.analytics.model.filter.aggregation.AnalyticsPercentageLimit;
import io.meeds.analytics.model.filter.search.AnalyticsFieldFilter;
import io.meeds.analytics.model.filter.search.AnalyticsFieldFilterType;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnalyticsPercentageFilter
extends AbstractAnalyticsFilter {
    private static final long serialVersionUID = 5699550622069979910L;
    private String chartType;
    private List<String> colors;
    private String periodType;
    private AnalyticsPeriod customPeriod;
    private LocalDate periodDate;
    private AnalyticsPercentageItemFilter value;
    private AnalyticsPercentageItemFilter threshold;
    private AnalyticsPercentageLimit percentageLimit = null;
    private long currentPeriodLimit = 0L;
    private long previousPeriodLimit = 0L;
    private String lang = null;

    public AnalyticsPercentageFilter(String title, String timeZone, String chartType, List<String> colors, String periodType, AnalyticsPeriod clonedAnalyticsPeriod, LocalDate clonedPeriodDate, AnalyticsPercentageItemFilter cloneAnalyticsPercentageItemFilterValue, AnalyticsPercentageItemFilter cloneAnalyticsPercentageItemFilterThreshold, AnalyticsPercentageLimit clonedAnalyticsPercentageLimit, long currentPeriodLimit, long previousPeriodLimit, String lang) {
        this(chartType, colors, periodType, clonedAnalyticsPeriod, clonedPeriodDate, cloneAnalyticsPercentageItemFilterValue, cloneAnalyticsPercentageItemFilterThreshold, clonedAnalyticsPercentageLimit, currentPeriodLimit, previousPeriodLimit, lang);
        this.setTitle(title);
        this.setTimeZone(timeZone);
    }

    public AnalyticsPeriodType getAnalyticsPeriodType() {
        return AnalyticsPeriodType.periodTypeByName(this.periodType);
    }

    public String getAnalyticsPeriodInterval() {
        AnalyticsPeriodType analyticsPeriodType = this.getAnalyticsPeriodType();
        if (analyticsPeriodType != null && this.periodDate != null) {
            return analyticsPeriodType.getInterval();
        }
        if (this.customPeriod != null) {
            return this.customPeriod.getInterval();
        }
        return null;
    }

    public AnalyticsPeriod getCurrentAnalyticsPeriod() {
        AnalyticsPeriodType analyticsPeriodType = this.getAnalyticsPeriodType();
        if (analyticsPeriodType != null && this.periodDate != null) {
            return analyticsPeriodType.getCurrentPeriod(this.periodDate, this.zoneId());
        }
        if (this.customPeriod != null) {
            return this.customPeriod.clone();
        }
        return null;
    }

    public AnalyticsPeriod getPreviousAnalyticsPeriod() {
        AnalyticsPeriodType analyticsPeriodType = this.getAnalyticsPeriodType();
        if (analyticsPeriodType != null && this.periodDate != null) {
            return analyticsPeriodType.getPreviousPeriod(this.periodDate, this.zoneId());
        }
        if (this.customPeriod != null) {
            return this.customPeriod.previousPeriod();
        }
        return null;
    }

    public void setPeriodDateInMS(long timestampInMS) {
        this.periodDate = Instant.ofEpochMilli(timestampInMS).atZone(this.zoneId()).toLocalDate();
    }

    public AnalyticsFilter computeValueFilter() {
        return this.computeValueFilter(null, 0L);
    }

    public AnalyticsFilter computeValueFilter(AnalyticsPeriod period, long limit) {
        AnalyticsAggregation xAxisAggregation;
        ArrayList<AnalyticsAggregation> xAxisAggregations = new ArrayList<AnalyticsAggregation>();
        if (period == null && (xAxisAggregation = this.getXAxisAggregation()) != null) {
            xAxisAggregations.add(xAxisAggregation);
        }
        if (limit > 0L) {
            AnalyticsAggregation limitAggregation = new AnalyticsAggregation(this.percentageLimit.getField());
            limitAggregation.setType(AnalyticsAggregationType.TERMS);
            limitAggregation.setLimit(limit);
            xAxisAggregations.add(limitAggregation);
        }
        return new AnalyticsFilter(this.getTitle(), this.getTimeZone(), this.chartType, this.colors, this.getValueFilters(period), null, xAxisAggregations, this.getValueYAggregation(), this.lang, 0L, 0L);
    }

    public AnalyticsFilter computeThresholdFilter() {
        AnalyticsAggregation xAxisAggregation = this.getXAxisAggregation();
        return new AnalyticsFilter(this.getTitle(), this.getTimeZone(), this.chartType, this.colors, this.getThresholdFilters(), null, xAxisAggregation == null ? Collections.emptyList() : Collections.singletonList(xAxisAggregation), this.getThresholdYAggregation(), this.lang, 0L, 0L);
    }

    public AnalyticsFilter computeLimitFilter() {
        AnalyticsAggregation xAxisAggregation = this.getXAxisAggregation();
        return new AnalyticsFilter(this.getTitle(), this.getTimeZone(), this.chartType, this.colors, this.getLimitFilters(), null, xAxisAggregation == null ? Collections.emptyList() : Collections.singletonList(xAxisAggregation), this.getLimitYAggregation(), this.lang, 0L, 0L);
    }

    public AnalyticsPercentageFilter clone() {
        LocalDate clonedPeriodDate = this.periodDate == null ? null : LocalDate.from(this.periodDate);
        AnalyticsPeriod clonedAnalyticsPeriod = this.customPeriod == null ? null : this.customPeriod.clone();
        AnalyticsPercentageItemFilter cloneAnalyticsPercentageItemFilterValue = this.value == null ? null : this.value.clone();
        AnalyticsPercentageItemFilter cloneAnalyticsPercentageItemFilterThreshold = this.threshold == null ? null : this.threshold.clone();
        AnalyticsPercentageLimit clonedAnalyticsPercentageLimit = this.percentageLimit == null ? null : this.percentageLimit.clone();
        return new AnalyticsPercentageFilter(this.getTitle(), this.getTimeZone(), this.chartType, this.colors, this.periodType, clonedAnalyticsPeriod, clonedPeriodDate, cloneAnalyticsPercentageItemFilterValue, cloneAnalyticsPercentageItemFilterThreshold, clonedAnalyticsPercentageLimit, this.currentPeriodLimit, this.previousPeriodLimit, this.lang);
    }

    private AnalyticsAggregation getXAxisAggregation() {
        String interval = this.getAnalyticsPeriodInterval();
        if (interval == null) {
            return null;
        }
        AnalyticsAggregation xAxisAggregation = new AnalyticsAggregation();
        xAxisAggregation.setField("timestamp");
        xAxisAggregation.setSortDirection("DESC");
        xAxisAggregation.setType(AnalyticsAggregationType.DATE);
        xAxisAggregation.setInterval(interval);
        xAxisAggregation.setMinBound(this.getPreviousAnalyticsPeriod().getFromInMS());
        xAxisAggregation.setMaxBound(this.getCurrentAnalyticsPeriod().getToInMS() - 1000L);
        xAxisAggregation.setUseBounds(true);
        if (this.customPeriod != null) {
            long offset;
            long diffInDays = this.customPeriod.getDiffInDays();
            if (diffInDays > 0L && (offset = xAxisAggregation.getMinBound() / 86400000L % diffInDays) > 0L) {
                xAxisAggregation.setOffset(offset + "d");
            }
        } else {
            AnalyticsPeriodType analyticsPeriodType = this.getAnalyticsPeriodType();
            if (analyticsPeriodType != null && analyticsPeriodType.getOffset(xAxisAggregation.getMinBound()) > 0L) {
                long offset = analyticsPeriodType.getOffset(xAxisAggregation.getMinBound());
                xAxisAggregation.setOffset(offset + "d");
            }
        }
        return xAxisAggregation;
    }

    private AnalyticsAggregation getValueYAggregation() {
        return this.value == null ? null : this.value.getYAxisAggregation().clone();
    }

    private AnalyticsAggregation getLimitYAggregation() {
        return this.percentageLimit == null || this.percentageLimit.getAggregation() == null || this.percentageLimit.getAggregation().getYAxisAggregation() == null ? null : this.percentageLimit.getAggregation().getYAxisAggregation().clone();
    }

    private AnalyticsAggregation getThresholdYAggregation() {
        return this.threshold == null ? null : this.threshold.getYAxisAggregation().clone();
    }

    private List<AnalyticsFieldFilter> getValueFilters(AnalyticsPeriod period) {
        ArrayList<AnalyticsFieldFilter> filters = new ArrayList<AnalyticsFieldFilter>();
        AnalyticsFieldFilter periodFilter = this.getPeriodFilter(period);
        if (periodFilter != null) {
            filters.add(periodFilter);
        }
        if (this.value != null && this.value.getFilters() != null) {
            filters.addAll(this.value.getFilters());
        }
        return filters;
    }

    private List<AnalyticsFieldFilter> getThresholdFilters() {
        ArrayList<AnalyticsFieldFilter> filters = new ArrayList<AnalyticsFieldFilter>();
        AnalyticsFieldFilter periodFilter = this.getPeriodFilter(null);
        if (periodFilter != null) {
            filters.add(periodFilter);
        }
        if (this.threshold != null && this.threshold.getFilters() != null) {
            filters.addAll(this.threshold.getFilters());
        }
        return filters;
    }

    private List<AnalyticsFieldFilter> getLimitFilters() {
        ArrayList<AnalyticsFieldFilter> filters = new ArrayList<AnalyticsFieldFilter>();
        AnalyticsFieldFilter periodFilter = this.getPeriodFilter(null);
        if (periodFilter != null) {
            filters.add(periodFilter);
        }
        if (this.percentageLimit != null && this.percentageLimit.getAggregation() != null && this.percentageLimit.getAggregation().getFilters() != null) {
            filters.addAll(this.percentageLimit.getAggregation().getFilters());
        }
        return filters;
    }

    private AnalyticsFieldFilter getPeriodFilter(AnalyticsPeriod period) {
        if (period == null) {
            AnalyticsPeriod currentAnalyticsPeriod = this.getCurrentAnalyticsPeriod();
            AnalyticsPeriod previousAnalyticsPeriod = this.getPreviousAnalyticsPeriod();
            if (previousAnalyticsPeriod == null || currentAnalyticsPeriod == null) {
                return null;
            }
            period = new AnalyticsPeriod(previousAnalyticsPeriod.getFrom(), currentAnalyticsPeriod.getTo());
        }
        AnalyticsFilter.Range rangeFilter = new AnalyticsFilter.Range(period.getFromInMS(), period.getToInMS());
        return new AnalyticsFieldFilter("timestamp", AnalyticsFieldFilterType.RANGE, rangeFilter);
    }

    public String getChartType() {
        return this.chartType;
    }

    public List<String> getColors() {
        return this.colors;
    }

    public String getPeriodType() {
        return this.periodType;
    }

    public AnalyticsPeriod getCustomPeriod() {
        return this.customPeriod;
    }

    public LocalDate getPeriodDate() {
        return this.periodDate;
    }

    public AnalyticsPercentageItemFilter getValue() {
        return this.value;
    }

    public AnalyticsPercentageItemFilter getThreshold() {
        return this.threshold;
    }

    public AnalyticsPercentageLimit getPercentageLimit() {
        return this.percentageLimit;
    }

    public long getCurrentPeriodLimit() {
        return this.currentPeriodLimit;
    }

    public long getPreviousPeriodLimit() {
        return this.previousPeriodLimit;
    }

    public String getLang() {
        return this.lang;
    }

    public void setChartType(String chartType) {
        this.chartType = chartType;
    }

    public void setColors(List<String> colors) {
        this.colors = colors;
    }

    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }

    public void setCustomPeriod(AnalyticsPeriod customPeriod) {
        this.customPeriod = customPeriod;
    }

    public void setPeriodDate(LocalDate periodDate) {
        this.periodDate = periodDate;
    }

    public void setValue(AnalyticsPercentageItemFilter value) {
        this.value = value;
    }

    public void setThreshold(AnalyticsPercentageItemFilter threshold) {
        this.threshold = threshold;
    }

    public void setPercentageLimit(AnalyticsPercentageLimit percentageLimit) {
        this.percentageLimit = percentageLimit;
    }

    public void setCurrentPeriodLimit(long currentPeriodLimit) {
        this.currentPeriodLimit = currentPeriodLimit;
    }

    public void setPreviousPeriodLimit(long previousPeriodLimit) {
        this.previousPeriodLimit = previousPeriodLimit;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    @Override
    public String toString() {
        return "AnalyticsPercentageFilter(super=" + super.toString() + ", chartType=" + this.getChartType() + ", colors=" + String.valueOf(this.getColors()) + ", periodType=" + this.getPeriodType() + ", customPeriod=" + String.valueOf(this.getCustomPeriod()) + ", periodDate=" + String.valueOf(this.getPeriodDate()) + ", value=" + String.valueOf(this.getValue()) + ", threshold=" + String.valueOf(this.getThreshold()) + ", percentageLimit=" + String.valueOf(this.getPercentageLimit()) + ", currentPeriodLimit=" + this.getCurrentPeriodLimit() + ", previousPeriodLimit=" + this.getPreviousPeriodLimit() + ", lang=" + this.getLang() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyticsPercentageFilter)) {
            return false;
        }
        AnalyticsPercentageFilter other = (AnalyticsPercentageFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chartType = this.getChartType();
        String other$chartType = other.getChartType();
        if (this$chartType == null ? other$chartType != null : !this$chartType.equals(other$chartType)) {
            return false;
        }
        List<String> this$colors = this.getColors();
        List<String> other$colors = other.getColors();
        if (this$colors == null ? other$colors != null : !((Object)this$colors).equals(other$colors)) {
            return false;
        }
        String this$periodType = this.getPeriodType();
        String other$periodType = other.getPeriodType();
        if (this$periodType == null ? other$periodType != null : !this$periodType.equals(other$periodType)) {
            return false;
        }
        AnalyticsPeriod this$customPeriod = this.getCustomPeriod();
        AnalyticsPeriod other$customPeriod = other.getCustomPeriod();
        if (this$customPeriod == null ? other$customPeriod != null : !((Object)this$customPeriod).equals(other$customPeriod)) {
            return false;
        }
        LocalDate this$periodDate = this.getPeriodDate();
        LocalDate other$periodDate = other.getPeriodDate();
        if (this$periodDate == null ? other$periodDate != null : !((Object)this$periodDate).equals(other$periodDate)) {
            return false;
        }
        AnalyticsPercentageItemFilter this$value = this.getValue();
        AnalyticsPercentageItemFilter other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        AnalyticsPercentageItemFilter this$threshold = this.getThreshold();
        AnalyticsPercentageItemFilter other$threshold = other.getThreshold();
        if (this$threshold == null ? other$threshold != null : !((Object)this$threshold).equals(other$threshold)) {
            return false;
        }
        AnalyticsPercentageLimit this$percentageLimit = this.getPercentageLimit();
        AnalyticsPercentageLimit other$percentageLimit = other.getPercentageLimit();
        if (this$percentageLimit == null ? other$percentageLimit != null : !((Object)this$percentageLimit).equals(other$percentageLimit)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        return !(this$lang == null ? other$lang != null : !this$lang.equals(other$lang));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnalyticsPercentageFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chartType = this.getChartType();
        result = result * 59 + ($chartType == null ? 43 : $chartType.hashCode());
        List<String> $colors = this.getColors();
        result = result * 59 + ($colors == null ? 43 : ((Object)$colors).hashCode());
        String $periodType = this.getPeriodType();
        result = result * 59 + ($periodType == null ? 43 : $periodType.hashCode());
        AnalyticsPeriod $customPeriod = this.getCustomPeriod();
        result = result * 59 + ($customPeriod == null ? 43 : ((Object)$customPeriod).hashCode());
        LocalDate $periodDate = this.getPeriodDate();
        result = result * 59 + ($periodDate == null ? 43 : ((Object)$periodDate).hashCode());
        AnalyticsPercentageItemFilter $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        AnalyticsPercentageItemFilter $threshold = this.getThreshold();
        result = result * 59 + ($threshold == null ? 43 : ((Object)$threshold).hashCode());
        AnalyticsPercentageLimit $percentageLimit = this.getPercentageLimit();
        result = result * 59 + ($percentageLimit == null ? 43 : ((Object)$percentageLimit).hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        return result;
    }

    public AnalyticsPercentageFilter() {
    }

    public AnalyticsPercentageFilter(String chartType, List<String> colors, String periodType, AnalyticsPeriod customPeriod, LocalDate periodDate, AnalyticsPercentageItemFilter value, AnalyticsPercentageItemFilter threshold, AnalyticsPercentageLimit percentageLimit, long currentPeriodLimit, long previousPeriodLimit, String lang) {
        this.chartType = chartType;
        this.colors = colors;
        this.periodType = periodType;
        this.customPeriod = customPeriod;
        this.periodDate = periodDate;
        this.value = value;
        this.threshold = threshold;
        this.percentageLimit = percentageLimit;
        this.currentPeriodLimit = currentPeriodLimit;
        this.previousPeriodLimit = previousPeriodLimit;
        this.lang = lang;
    }
}

