/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.api.websocket.listener;

import io.meeds.analytics.api.websocket.AnalyticsWebSocketService;
import io.meeds.analytics.model.AnalyticsWebSocketMessage;
import io.meeds.analytics.utils.AnalyticsUtils;
import org.apache.commons.lang3.StringUtils;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AnalyticsWebSocketListener
implements ServerChannel.MessageListener {
    public static final String EXO_ANALYTICS_MESSAGE_EVENT = "analytics.websocket.messageReceived";
    private static final Log LOG = ExoLogger.getLogger(AnalyticsWebSocketListener.class);
    private AnalyticsWebSocketService analyticsWebSocketService;
    private ListenerService listenerService;

    public AnalyticsWebSocketListener(AnalyticsWebSocketService analyticsWebSocketService, ListenerService listenerService) {
        this.analyticsWebSocketService = analyticsWebSocketService;
        this.listenerService = listenerService;
    }

    public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
        try {
            if (message == null || message.getData() == null) {
                LOG.warn((Object)"Empty analytics WebSocket message is received");
                return false;
            }
            if (from == null) {
                LOG.warn((Object)"Empty analytics WebSocket session is received");
                return false;
            }
            if (channel == null || !StringUtils.equals((CharSequence)channel.getId(), (CharSequence)"/service/analytics")) {
                LOG.warn((Object)"Empty WebSocket channel received");
                return false;
            }
            if (!StringUtils.equals((CharSequence)channel.getId(), (CharSequence)"/service/analytics")) {
                LOG.debug((Object)"Not Analytics WebSocket channel");
                return false;
            }
            Object data = message.getData();
            AnalyticsWebSocketMessage wsMessage = AnalyticsUtils.fromJsonString(data.toString(), AnalyticsWebSocketMessage.class);
            if (StringUtils.isBlank((CharSequence)wsMessage.getUserName())) {
                LOG.warn((Object)"Empty WebSocket username received");
                return false;
            }
            if (StringUtils.isBlank((CharSequence)wsMessage.getToken())) {
                LOG.warn((Object)"Empty WebSocket user token received");
                return false;
            }
            String userToken = this.analyticsWebSocketService.getUserToken(wsMessage.getUserName());
            if (!StringUtils.equals((CharSequence)userToken, (CharSequence)wsMessage.getToken())) {
                LOG.warn("Wrong WebSocket token received for user {}", new Object[]{wsMessage.getUserName()});
                return false;
            }
            this.listenerService.broadcast(EXO_ANALYTICS_MESSAGE_EVENT, (Object)this, (Object)wsMessage);
            return true;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)"Error when parsing analytics ws message", (Throwable)e);
            } else {
                LOG.warn("Error when parsing analytics ws message: {}", new Object[]{e.getMessage()});
            }
            return false;
        }
    }
}

