/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.api.service.injection;

import io.meeds.analytics.api.service.AnalyticsService;
import io.meeds.analytics.model.StatisticWatcher;
import io.meeds.analytics.model.StatisticWatchersDescriptor;
import io.meeds.social.util.JsonUtils;
import jakarta.annotation.PostConstruct;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatisticWatcherImportService {
    @Autowired
    private AnalyticsService analyticsService;

    @PostConstruct
    public void init() {
        CompletableFuture.runAsync(this::importUIWatchers);
    }

    public void importUIWatchers() {
        Collections.list(this.getClass().getClassLoader().getResources("analytics-ui-watchers.json")).stream().map(this::parseDescriptors).flatMap(Collection::stream).forEach(this.analyticsService::addUIWatcher);
    }

    protected List<StatisticWatcher> parseDescriptors(URL url) {
        List<StatisticWatcher> list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                StatisticWatchersDescriptor list2 = (StatisticWatchersDescriptor)JsonUtils.fromJsonString((String)content, StatisticWatchersDescriptor.class);
                list = list2.getDescriptors();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            inputStream.close();
        }
        return list;
    }
}

