/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.listener.social;

import io.meeds.analytics.listener.social.BaseAttachmentAnalyticsListener;
import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.ObjectAttachmentId;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class ActivityAttachmentAnalyticsListener
extends BaseAttachmentAnalyticsListener {
    private static final List<String> SUPPORTED_OBJECT_TYPES = Collections.singletonList("activity");
    private static final List<String> EVENT_NAMES = Arrays.asList("attachment.created", "attachment.deleted");
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        EVENT_NAMES.forEach(name -> this.listenerService.addListener(name, (ListenerBase)this));
    }

    @Override
    protected void extendStatisticData(StatisticData statisticData, ObjectAttachmentId objectAttachment) {
        ExoSocialActivity activity = this.activityManager.getActivity(objectAttachment.getObjectId());
        if (activity != null) {
            AnalyticsUtils.addActivityStatisticsData((StatisticData)statisticData, (ExoSocialActivity)activity);
        }
    }

    @Override
    protected List<String> getSupportedObjectType() {
        return SUPPORTED_OBJECT_TYPES;
    }

    @Override
    protected String getModule(ObjectAttachmentId objectAttachment) {
        return "social";
    }

    @Override
    protected String getSubModule(ObjectAttachmentId objectAttachment) {
        return "activity";
    }

    @Override
    @Generated
    public AttachmentService getAttachmentService() {
        return this.attachmentService;
    }

    @Override
    @Generated
    public SpaceService getSpaceService() {
        return this.spaceService;
    }
}

