/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.portlet;

import io.meeds.analytics.model.chart.TableColumnResult;
import io.meeds.analytics.model.filter.AbstractAnalyticsFilter;
import io.meeds.analytics.model.filter.AnalyticsFilter;
import io.meeds.analytics.model.filter.AnalyticsPeriod;
import io.meeds.analytics.model.filter.AnalyticsPeriodType;
import io.meeds.analytics.model.filter.AnalyticsTableColumnFilter;
import io.meeds.analytics.model.filter.AnalyticsTableFilter;
import io.meeds.analytics.model.filter.search.AnalyticsFieldFilter;
import io.meeds.analytics.model.filter.search.AnalyticsFieldFilterType;
import io.meeds.analytics.portlet.AbstractAnalyticsPortlet;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class AnalyticsTablePortlet
extends AbstractAnalyticsPortlet<AnalyticsTableFilter> {
    protected String getViewPagePath() {
        return "/WEB-INF/jsp/analytics-table.jsp";
    }

    protected Class<AnalyticsTableFilter> getFilterClass() {
        return AnalyticsTableFilter.class;
    }

    protected void readSettingsReadOnly(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsTableFilter filter = (AnalyticsTableFilter)this.getFilterFromPreferences(request);
        JSONObject jsonResponse = new JSONObject();
        this.addJSONParam(jsonResponse, "title", (Object)filter.getTitle());
        this.addJSONParam(jsonResponse, "pageSize", (Object)filter.getPageSize());
        this.addJSONParam(jsonResponse, "canEdit", (Object)this.canModifySettings((PortletRequest)request));
        this.addJSONParam(jsonResponse, "scope", (Object)this.getSearchScope((PortletRequest)request).name());
        response.setContentType("application/json");
        response.getWriter().write(jsonResponse.toString());
    }

    protected void readSettings(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsTableFilter filter = (AnalyticsTableFilter)this.getFilterFromPreferences(request);
        response.setContentType("application/json");
        response.getWriter().write(AnalyticsUtils.toJsonString((Object)filter));
    }

    protected void readData(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        int limit;
        AnalyticsTableFilter tableFilter = (AnalyticsTableFilter)this.getFilterFromPreferences(request);
        if (tableFilter == null || tableFilter.getMainColumn() == null || tableFilter.getMainColumn().getValueAggregation() == null || tableFilter.getMainColumn().getValueAggregation().getAggregation() == null || tableFilter.getMainColumn().getValueAggregation().getAggregation().getField() == null) {
            response.setContentType("application/json");
            response.getWriter().write("{}");
            return;
        }
        this.addTimeZoneFilter(request, (AbstractAnalyticsFilter)tableFilter);
        String column = request.getParameter("column");
        int columnIndex = 0;
        if (StringUtils.isNotBlank((CharSequence)column)) {
            columnIndex = Integer.parseInt(column);
        }
        String fromDateString = request.getParameter("min");
        String toDateString = request.getParameter("max");
        AnalyticsPeriod period = new AnalyticsPeriod(Long.parseLong(fromDateString), Long.parseLong(toDateString));
        AnalyticsPeriodType periodType = null;
        String analyticsPeriodType = request.getParameter("periodType");
        if (StringUtils.isNotBlank((CharSequence)analyticsPeriodType)) {
            periodType = AnalyticsPeriodType.periodTypeByName((String)analyticsPeriodType);
            period = tableFilter.getCurrentPeriod(period, periodType);
        }
        AnalyticsFieldFilter fieldFilter = null;
        String fieldFilterName = request.getParameter("fieldFilter");
        String fieldFilterValues = request.getParameter("fieldValues");
        if (StringUtils.isNotBlank((CharSequence)fieldFilterName) && StringUtils.isNotBlank((CharSequence)fieldFilterValues)) {
            fieldFilter = new AnalyticsFieldFilter(fieldFilterName, AnalyticsFieldFilterType.IN_SET, fieldFilterValues);
        }
        try {
            limit = Integer.parseInt(request.getParameter("limit"));
        }
        catch (NumberFormatException e) {
            limit = 0;
        }
        String sort = request.getParameter("sort");
        AnalyticsFilter filter = tableFilter.buildColumnFilter(period, periodType, fieldFilter, limit, sort, columnIndex, true);
        this.addScopeFilter(request, filter);
        this.addLanguageFilter(request, filter);
        TableColumnResult result = this.getAnalyticsService().computeTableColumnData(null, tableFilter, filter, period, periodType, columnIndex, true);
        AnalyticsTableColumnFilter columnFilter = tableFilter.getColumnFilter(columnIndex);
        if (columnFilter.getThresholdAggregation() != null && columnFilter.getThresholdAggregation().getAggregation() != null && columnFilter.getThresholdAggregation().getAggregation().getType() != null && columnFilter.getThresholdAggregation().getAggregation().getField() != null) {
            filter = tableFilter.buildColumnFilter(period, periodType, fieldFilter, limit, sort, columnIndex, false);
            this.addScopeFilter(request, filter);
            this.addLanguageFilter(request, filter);
            this.getAnalyticsService().computeTableColumnData(result, tableFilter, filter, period, periodType, columnIndex, false);
        }
        response.setContentType("application/json");
        response.getWriter().write(AnalyticsUtils.toJsonString((Object)result));
    }
}

