/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.portlet;

import io.meeds.analytics.model.chart.ChartDataList;
import io.meeds.analytics.model.filter.AbstractAnalyticsFilter;
import io.meeds.analytics.model.filter.AnalyticsFilter;
import io.meeds.analytics.portlet.AbstractAnalyticsPortlet;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class AnalyticsPortlet
extends AbstractAnalyticsPortlet<AnalyticsFilter> {
    protected String getViewPagePath() {
        return "/WEB-INF/jsp/analytics.jsp";
    }

    protected Class<AnalyticsFilter> getFilterClass() {
        return AnalyticsFilter.class;
    }

    protected void readSettings(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsFilter filter = (AnalyticsFilter)this.getFilterFromPreferences(request);
        response.setContentType("application/json");
        response.getWriter().write(AnalyticsUtils.toJsonString((Object)filter));
    }

    protected void readSettingsReadOnly(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsFilter filter = (AnalyticsFilter)this.getFilterFromPreferences(request);
        JSONObject jsonResponse = new JSONObject();
        this.addJSONParam(jsonResponse, "title", (Object)filter.getTitle());
        this.addJSONParam(jsonResponse, "chartType", (Object)filter.getChartType());
        List colors = filter.getColors() == null ? Collections.emptyList() : filter.getColors();
        this.addJSONParam(jsonResponse, "colors", (Object)new JSONArray((Collection)colors));
        this.addJSONParam(jsonResponse, "canEdit", (Object)this.canModifySettings((PortletRequest)request));
        this.addJSONParam(jsonResponse, "scope", (Object)this.getSearchScope((PortletRequest)request).name());
        response.setContentType("application/json");
        response.getWriter().write(jsonResponse.toString());
    }

    protected void readSamples(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsFilter filter = (AnalyticsFilter)this.getFilterFromPreferences(request);
        this.addPeriodFilter(request, filter);
        this.addScopeFilter(request, filter);
        this.addLanguageFilter(request, filter);
        this.addLimitFilter(request, filter);
        this.addTimeZoneFilter(request, (AbstractAnalyticsFilter)filter);
        this.addSortFilter(filter, "desc");
        List statisticDatas = this.getAnalyticsService().retrieveData(filter);
        List<JSONObject> objectMappings = statisticDatas.stream().map(statisticData -> {
            JSONObject object = new JSONObject(statisticData);
            object.remove("class");
            return object;
        }).toList();
        JSONArray jsonArrayResponse = new JSONArray(objectMappings);
        response.setContentType("application/json");
        response.getWriter().write(jsonArrayResponse.toString());
    }

    protected void readData(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsFilter filter = (AnalyticsFilter)this.getFilterFromPreferences(request);
        this.addPeriodFilter(request, filter);
        this.addScopeFilter(request, filter);
        this.addLanguageFilter(request, filter);
        this.addTimeZoneFilter(request, (AbstractAnalyticsFilter)filter);
        ChartDataList result = this.getAnalyticsService().computeChartData(filter);
        response.setContentType("application/json");
        response.getWriter().write(AnalyticsUtils.toJsonString((Object)result));
    }
}

