/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.service;

import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationImage;
import io.meeds.appcenter.model.ApplicationList;
import io.meeds.appcenter.model.ApplicationOrder;
import io.meeds.appcenter.model.GeneralSettings;
import io.meeds.appcenter.model.UserApplication;
import io.meeds.appcenter.model.exception.ApplicationAlreadyExistsException;
import io.meeds.appcenter.model.exception.ApplicationNotFoundException;
import io.meeds.appcenter.service.ApplicationCenterService;
import io.meeds.appcenter.storage.ApplicationCenterStorage;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={ApplicationCenterService.class})
@ExtendWith(value={MockitoExtension.class})
public class ApplicationCenterServiceTest {
    private static final String KEYWORD = "keyword";
    private static final String ADMIN_USERNAME = "admin";
    private static final long IMAGE_FILE_ID = 5L;
    private static final long IMAGE_LAST_MODIFIED = 588L;
    private static final String IMAGE_FILE_CONTENT = "content";
    private static final String HELP_PAGE_URL = "./helpPageUrl";
    private static final String URL = "./url";
    private static final String PERMISSIONS_2 = "/permissions2";
    private static final String PERMISSIONS_1 = "/permissions1";
    private static final String DESCRIPTION = "description";
    private static final String TITLE = "title";
    private static final String TEST_USER = "testuser";
    private static final Long ID = 2L;
    @MockBean
    private ConfigurationManager configurationManager;
    @MockBean
    private SettingService settingService;
    @MockBean
    private Authenticator authenticator;
    @MockBean
    private IdentityRegistry identityRegistry;
    @MockBean
    private ApplicationCenterStorage appCenterStorage;
    @Autowired
    private ApplicationCenterService applicationCenterService;

    @BeforeEach
    void setup() {
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        Identity adminIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.lenient().when((Object)adminIdentity.isMemberOf((MembershipEntry)ArgumentMatchers.argThat(m -> m.getGroup().equals("/platform/administrators") || m.getGroup().equals(PERMISSIONS_1)))).thenReturn((Object)true);
        Mockito.lenient().when((Object)userIdentity.isMemberOf((MembershipEntry)ArgumentMatchers.argThat(m -> m.getGroup().equals(PERMISSIONS_2)))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.identityRegistry.getIdentity(ADMIN_USERNAME)).thenReturn((Object)adminIdentity);
        Mockito.lenient().when((Object)this.identityRegistry.getIdentity(TEST_USER)).thenReturn((Object)userIdentity);
    }

    @Test
    void createApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.createApplication(null));
        Application existingApplication = this.application();
        existingApplication.setTitle("title2");
        Mockito.when((Object)this.appCenterStorage.getApplicationByTitle(existingApplication.getTitle())).thenReturn((Object)existingApplication);
        Assertions.assertThrows(ApplicationAlreadyExistsException.class, () -> this.applicationCenterService.createApplication(existingApplication));
        existingApplication.setTitle("titleTest");
        existingApplication.setUrl("test");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.createApplication(existingApplication));
        existingApplication.setUrl("./test/");
        existingApplication.setHelpPageURL("test");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.createApplication(existingApplication));
        Application application = this.application();
        this.applicationCenterService.createApplication(application);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).createApplication(application);
    }

    @Test
    void updateApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.updateApplication(null, ADMIN_USERNAME));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.updateApplication(this.application(null), null));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterService.updateApplication(this.application(), ADMIN_USERNAME));
        Mockito.when((Object)this.appCenterStorage.getApplicationById(ID.longValue())).thenReturn((Object)this.application());
        Assertions.assertThrows(IllegalAccessException.class, () -> this.applicationCenterService.updateApplication(this.application(), null));
        Assertions.assertThrows(IllegalAccessException.class, () -> this.applicationCenterService.updateApplication(this.application(), TEST_USER));
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage, (VerificationMode)Mockito.never())).updateApplication((Application)ArgumentMatchers.any());
        this.applicationCenterService.updateApplication(this.application(), ADMIN_USERNAME);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).updateApplication((Application)ArgumentMatchers.any());
    }

    @Test
    void deleteApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.deleteApplication(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.deleteApplication(null, ADMIN_USERNAME));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.deleteApplication(ID, null));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterService.deleteApplication(ID, ADMIN_USERNAME));
        Mockito.when((Object)this.appCenterStorage.getApplicationById(ID.longValue())).thenReturn((Object)this.application());
        Assertions.assertThrows(IllegalAccessException.class, () -> this.applicationCenterService.deleteApplication(ID, TEST_USER));
        this.applicationCenterService.deleteApplication(ID, ADMIN_USERNAME);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).deleteApplication(ID.longValue());
    }

    @Test
    void getMaxFavoriteApps() {
        long originalMaxFavoriteApps = this.applicationCenterService.getMaxFavoriteApps();
        this.applicationCenterService.setMaxFavoriteApps(originalMaxFavoriteApps + 1L);
        Assertions.assertEquals((long)(originalMaxFavoriteApps + 1L), (long)this.applicationCenterService.getMaxFavoriteApps());
        this.applicationCenterService.setMaxFavoriteApps(0L);
        Assertions.assertEquals((long)0L, (long)this.applicationCenterService.getMaxFavoriteApps());
    }

    @Test
    void setDefaultAppImage() {
        ApplicationImage applicationImage = this.applicationCenterService.setDefaultAppImage(null);
        Assertions.assertNull((Object)applicationImage);
        applicationImage = new ApplicationImage(null, null, null);
        applicationImage = this.applicationCenterService.setDefaultAppImage(applicationImage);
        Assertions.assertNull((Object)applicationImage);
        applicationImage = new ApplicationImage(null, "name", IMAGE_FILE_CONTENT);
        Mockito.when((Object)this.appCenterStorage.saveAppImageFileItem(applicationImage)).thenAnswer(invocation -> {
            ApplicationImage img = (ApplicationImage)invocation.getArgument(0);
            img.setId(Long.valueOf(5L));
            return img;
        });
        applicationImage = this.applicationCenterService.setDefaultAppImage(applicationImage);
        Assertions.assertNotNull((Object)applicationImage);
        Assertions.assertEquals((long)5L, (Long)applicationImage.getId());
    }

    @Test
    void getAppGeneralSettings() {
        this.applicationCenterService.setDefaultAppImage(null);
        this.applicationCenterService.setMaxFavoriteApps(0L);
        GeneralSettings generalSettings = this.applicationCenterService.getSettings();
        Assertions.assertNotNull((Object)generalSettings);
        Assertions.assertEquals((long)0L, (long)generalSettings.getMaxFavoriteApps());
        Assertions.assertNull((Object)generalSettings.getDefaultApplicationImage());
        this.applicationCenterService.setDefaultAppImage(new ApplicationImage(null, null, null));
        generalSettings = this.applicationCenterService.getSettings();
        Assertions.assertEquals((long)0L, (long)generalSettings.getMaxFavoriteApps());
        Assertions.assertNull((Object)generalSettings.getDefaultApplicationImage());
        Mockito.when((Object)this.appCenterStorage.getAppImageFile(Long.valueOf(5L))).thenReturn((Object)new ApplicationImage(Long.valueOf(5L), "name", IMAGE_FILE_CONTENT));
        Mockito.when((Object)this.settingService.get(ApplicationCenterService.APP_CENTER_CONTEXT, ApplicationCenterService.APP_CENTER_SCOPE, "defaultAppImageId")).thenReturn((Object)new SettingValue((Object)String.valueOf(5L)));
        generalSettings = this.applicationCenterService.getSettings();
        Assertions.assertEquals((long)0L, (long)generalSettings.getMaxFavoriteApps());
        Assertions.assertNotNull((Object)generalSettings.getDefaultApplicationImage());
        Assertions.assertEquals((Object)"name", (Object)generalSettings.getDefaultApplicationImage().getFileName());
        Assertions.assertFalse((boolean)generalSettings.getDefaultApplicationImage().getFileBody().isEmpty());
        Assertions.assertNotNull((Object)generalSettings.getDefaultApplicationImage().getId());
    }

    @Test
    void addFavoriteApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.addFavoriteApplication(0L, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.addFavoriteApplication(0L, TEST_USER));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterService.addFavoriteApplication(ID.longValue(), TEST_USER));
        Application application = this.application();
        Mockito.when((Object)this.appCenterStorage.getApplicationById(ID.longValue())).thenReturn((Object)application);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.applicationCenterService.addFavoriteApplication(ID.longValue(), TEST_USER));
        this.applicationCenterService.addFavoriteApplication(ID.longValue(), ADMIN_USERNAME);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).addApplicationToUserFavorite(ID.longValue(), ADMIN_USERNAME);
        application.setPermissions(Collections.singletonList(TEST_USER));
        this.applicationCenterService.addFavoriteApplication(ID.longValue(), TEST_USER);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).addApplicationToUserFavorite(ID.longValue(), TEST_USER);
    }

    @Test
    void deleteFavoriteApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.deleteFavoriteApplication(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.deleteFavoriteApplication(Long.valueOf(0L), TEST_USER));
        this.applicationCenterService.deleteFavoriteApplication(ID, TEST_USER);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).deleteApplicationFavorite(ID, TEST_USER);
    }

    @Test
    void getApplicationsList() {
        ApplicationList applicationsList = this.applicationCenterService.getApplications(0, 0, KEYWORD);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)0, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)0L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)0L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)0L, (long)applicationsList.getLimit());
        Application application = this.application();
        Mockito.when((Object)this.appCenterStorage.getApplications(KEYWORD)).thenReturn(Collections.singletonList(application));
        applicationsList = this.applicationCenterService.getApplications(1, 2, KEYWORD);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)0, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)0L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)1L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)2L, (long)applicationsList.getLimit());
        applicationsList = this.applicationCenterService.getApplications(0, 2, KEYWORD);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)1, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)1L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)0L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)2L, (long)applicationsList.getLimit());
    }

    @Test
    void getMandatoryAndFavoriteApplicationsList() {
        UserApplication application1 = new UserApplication(this.application(6L));
        UserApplication application2 = new UserApplication(this.application(7L));
        UserApplication application3 = new UserApplication(this.application(8L));
        UserApplication application4 = new UserApplication(this.application(9L));
        UserApplication application5 = new UserApplication(this.application(10L));
        Mockito.when((Object)this.appCenterStorage.getMandatoryApplications()).thenReturn(Arrays.asList(application1, application2, application3));
        Mockito.when((Object)this.appCenterStorage.countFavorites(ADMIN_USERNAME)).thenReturn((Object)1L);
        Mockito.when((Object)this.appCenterStorage.getFavoriteApplicationsByUser(ADMIN_USERNAME)).thenReturn(Arrays.asList(application4, application5));
        this.applicationCenterService.setMaxFavoriteApps(1L);
        ApplicationList applicationList = this.applicationCenterService.getMandatoryAndFavoriteApplicationsList(ADMIN_USERNAME);
        Assertions.assertFalse((boolean)applicationList.isCanAddFavorite());
        Assertions.assertEquals((int)5, (int)applicationList.getApplications().size());
        Assertions.assertEquals((long)5L, (long)applicationList.getSize());
        applicationList = this.applicationCenterService.getMandatoryAndFavoriteApplicationsList(TEST_USER);
        Assertions.assertTrue((boolean)applicationList.isCanAddFavorite());
        Assertions.assertEquals((int)0, (int)applicationList.getApplications().size());
        Assertions.assertEquals((long)0L, (long)applicationList.getSize());
        application1.setPermissions(Collections.singletonList(PERMISSIONS_2));
        application2.setPermissions(Collections.singletonList(PERMISSIONS_2));
        applicationList = this.applicationCenterService.getMandatoryAndFavoriteApplicationsList(TEST_USER);
        Assertions.assertTrue((boolean)applicationList.isCanAddFavorite());
        Assertions.assertEquals((int)2, (int)applicationList.getApplications().size());
        Assertions.assertEquals((long)2L, (long)applicationList.getSize());
    }

    @Test
    void updateFavoriteApplicationOrder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(ID, Long.valueOf(1L)), ""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(Long.valueOf(0L), Long.valueOf(1L)), ADMIN_USERNAME));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(ID, Long.valueOf(1L)), ADMIN_USERNAME));
        Mockito.when((Object)this.appCenterStorage.getApplicationById(ID.longValue())).thenReturn((Object)this.application());
        this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(ID, Long.valueOf(1L)), ADMIN_USERNAME);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).updateFavoriteApplicationOrder(ID.longValue(), ADMIN_USERNAME, Long.valueOf(1L));
    }

    @Test
    void getActiveApplications() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.getActiveApplications(0, 0, null, null));
        ApplicationList applicationsList = this.applicationCenterService.getActiveApplications(0, 0, null, TEST_USER);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)0, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)0L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)0L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)0L, (long)applicationsList.getLimit());
        applicationsList = this.applicationCenterService.getActiveApplications(2, 3, null, ADMIN_USERNAME);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)0, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)0L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)2L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)3L, (long)applicationsList.getLimit());
        String keyword1 = "keyword1";
        Application application = this.application();
        Mockito.when((Object)this.appCenterStorage.getApplications(keyword1)).thenReturn(Collections.singletonList(application));
        application.setActive(false);
        applicationsList = this.applicationCenterService.getActiveApplications(0, 0, keyword1, ADMIN_USERNAME);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)0, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)0L, (long)applicationsList.getSize());
        application.setActive(true);
        applicationsList = this.applicationCenterService.getActiveApplications(0, 0, keyword1, ADMIN_USERNAME);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)1, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)1L, (long)applicationsList.getSize());
    }

    @Test
    void getLastUpdated() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.getApplicationImageLastUpdated(50000L, null));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterService.getApplicationImageLastUpdated(50000L, TEST_USER));
        Application application = this.application();
        application.setImageFileName("name");
        application.setImageFileBody(IMAGE_FILE_CONTENT);
        Mockito.when((Object)this.appCenterStorage.getApplicationById(ID.longValue())).thenReturn((Object)this.application());
        Assertions.assertThrows(IllegalAccessException.class, () -> this.applicationCenterService.getApplicationImageLastUpdated(application.getId().longValue(), TEST_USER));
        Long lastUpdated = this.applicationCenterService.getApplicationImageLastUpdated(application.getId().longValue(), ADMIN_USERNAME);
        Assertions.assertNotNull((Object)lastUpdated);
    }

    @Test
    void getImageStream() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.getApplicationImageLastUpdated(50000L, null));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterService.getApplicationImageInputStream(50000L, TEST_USER));
        Application application = this.application();
        application.setImageFileName("name");
        application.setImageFileBody(IMAGE_FILE_CONTENT);
        Mockito.when((Object)this.appCenterStorage.getApplicationById(ID.longValue())).thenReturn((Object)this.application());
        Mockito.when((Object)this.appCenterStorage.getApplicationImageInputStream(5L)).thenReturn((Object)((InputStream)Mockito.mock(InputStream.class)));
        Assertions.assertThrows(IllegalAccessException.class, () -> this.applicationCenterService.getApplicationImageInputStream(application.getId().longValue(), TEST_USER));
        InputStream stream = this.applicationCenterService.getApplicationImageInputStream(application.getId().longValue(), ADMIN_USERNAME);
        Assertions.assertNotNull((Object)stream);
    }

    private Application application() {
        return this.application(ID);
    }

    private Application application(Long id) {
        return new Application(id, TITLE, URL, HELP_PAGE_URL, Long.valueOf(5L), Long.valueOf(588L), "", "", DESCRIPTION, false, true, false, true, false, new String[]{PERMISSIONS_1});
    }
}

