/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.upgrade;

import io.meeds.appcenter.upgrade.CleanFavoriteApplications;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={CleanFavoriteApplications.class})
@ExtendWith(value={MockitoExtension.class})
public class CleanFavoriteApplicationsTest {
    @MockBean
    private EntityManagerService entityManagerService;
    @MockBean
    private EntityManager entityManager;
    @MockBean
    private Query query;
    @Autowired
    private CleanFavoriteApplications cleanFavoriteApplications;

    @BeforeEach
    void setUp() {
        this.cleanFavoriteApplications = new CleanFavoriteApplications(this.entityManagerService);
        Mockito.when((Object)this.entityManagerService.getEntityManager()).thenReturn((Object)this.entityManager);
        Mockito.when((Object)this.entityManager.createNativeQuery(ArgumentMatchers.anyString())).thenReturn((Object)this.query);
    }

    @Test
    void processUpgradeCleanDuplicatedFavoriteApps() {
        List<Object[]> results = List.of(new Object[]{1L, 100L, "user1"}, new Object[]{2L, 100L, "user1"}, new Object[]{3L, 101L, "test"}, new Object[]{4L, 101L, "test"});
        Mockito.when((Object)this.query.getResultList()).thenReturn(results);
        Mockito.when((Object)this.query.executeUpdate()).thenReturn((Object)2);
        this.cleanFavoriteApplications.processUpgrade("v1", "v1");
        ((EntityManager)Mockito.verify((Object)this.entityManager, (VerificationMode)Mockito.times((int)3))).createNativeQuery(ArgumentMatchers.anyString());
        ((Query)Mockito.verify((Object)this.query, (VerificationMode)Mockito.times((int)2))).executeUpdate();
        ((EntityManagerService)Mockito.verify((Object)this.entityManagerService, (VerificationMode)Mockito.times((int)1))).getEntityManager();
    }

    @Test
    void processUpgradeNoDuplicatedFavoriteApps() {
        List<Object[]> results = List.of(new Object[]{1L, 100L, "user1"}, new Object[]{2L, 101L, "test"});
        Mockito.when((Object)this.query.getResultList()).thenReturn(results);
        this.cleanFavoriteApplications.processUpgrade("v1", "v1");
        ((Query)Mockito.verify((Object)this.query, (VerificationMode)Mockito.never())).executeUpdate();
    }
}

