/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.plugin;

import io.meeds.appcenter.plugin.MyApplicationsHeaderTranslationPlugin;
import io.meeds.appcenter.service.ApplicationCenterService;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.service.TranslationService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={MyApplicationsHeaderTranslationPlugin.class})
@ExtendWith(value={MockitoExtension.class})
public class MyApplicationsHeaderTranslationPluginTest {
    private static final String TEST_USER = "testuser";
    @MockBean
    private TranslationService translationService;
    @MockBean
    private ApplicationCenterService applicationCenterService;
    @Autowired
    private MyApplicationsHeaderTranslationPlugin translationPlugin;

    @Test
    void init() {
        this.translationPlugin.init();
        ((TranslationService)Mockito.verify((Object)this.translationService)).addPlugin((TranslationPlugin)this.translationPlugin);
    }

    @Test
    void getObjectType() {
        Assertions.assertEquals((Object)"myApplicationsPortlet", (Object)this.translationPlugin.getObjectType());
    }

    @Test
    void hasEditPermission() {
        Assertions.assertFalse((boolean)this.translationPlugin.hasEditPermission(15L, TEST_USER));
        Mockito.when((Object)this.applicationCenterService.canEdit(TEST_USER)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.translationPlugin.hasEditPermission(15L, TEST_USER));
    }

    @Test
    void hasAccessPermission() {
        Assertions.assertTrue((boolean)this.translationPlugin.hasAccessPermission(15L, TEST_USER));
    }

    @Test
    void getAudienceId() {
        Assertions.assertEquals((long)0L, (long)this.translationPlugin.getAudienceId(15L));
    }

    @Test
    void getSpaceId() {
        Assertions.assertEquals((long)0L, (long)this.translationPlugin.getSpaceId(15L));
    }
}

