/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.service;

import io.meeds.appcenter.constant.ApplicationType;
import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationList;
import io.meeds.appcenter.model.ApplicationOrder;
import io.meeds.appcenter.model.UserApplication;
import io.meeds.appcenter.model.exception.ApplicationNotFoundException;
import io.meeds.appcenter.service.ApplicationCenterService;
import io.meeds.appcenter.storage.ApplicationCenterStorage;
import io.meeds.social.category.service.CategoryLinkService;
import io.meeds.social.translation.service.TranslationService;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.thumbnail.ImageThumbnailService;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

@SpringBootTest(classes={ApplicationCenterService.class})
@ExtendWith(value={MockitoExtension.class})
public class ApplicationCenterServiceTest {
    private static final String SHORTCUT = "G";
    private static final String KEYWORD = "keyword";
    private static final String ADMIN_USERNAME = "admin";
    private static final long IMAGE_FILE_ID = 5L;
    private static final String HELP_PAGE_URL = "./helpPageUrl";
    private static final String URL = "./url";
    private static final String PERMISSIONS_2 = "/permissions2";
    private static final String PERMISSIONS_1 = "/permissions1";
    private static final String DESCRIPTION = "description";
    private static final String TITLE = "title";
    private static final String TEST_USER = "testuser";
    private static final Long ID = 2L;
    @MockBean
    private ConfigurationManager configurationManager;
    @MockBean
    private SettingService settingService;
    @MockBean
    private TranslationService translationService;
    @MockBean
    private FileService fileService;
    @MockBean
    private ImageThumbnailService imageThumbnailService;
    @MockBean
    private UserACL userAcl;
    @MockBean
    private ApplicationCenterStorage appCenterStorage;
    @MockBean
    private CategoryLinkService categoryLinkService;
    @MockBean
    private PortalContainer portalContainer;
    @Autowired
    private ApplicationCenterService applicationCenterService;

    @BeforeEach
    void setup() {
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        Identity adminIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.lenient().when((Object)adminIdentity.isMemberOf((MembershipEntry)ArgumentMatchers.argThat(m -> m.getGroup().equals("/platform/administrators") || m.getGroup().equals(PERMISSIONS_1)))).thenReturn((Object)true);
        Mockito.lenient().when((Object)userIdentity.isMemberOf((MembershipEntry)ArgumentMatchers.argThat(m -> m.getGroup().equals(PERMISSIONS_2)))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.userAcl.getUserIdentity(ADMIN_USERNAME)).thenReturn((Object)adminIdentity);
        Mockito.lenient().when((Object)this.userAcl.getUserIdentity(TEST_USER)).thenReturn((Object)userIdentity);
        Mockito.lenient().when((Object)this.userAcl.isAdministrator(adminIdentity)).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.userAcl.hasPermission(adminIdentity, PERMISSIONS_1)).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.userAcl.hasPermission(adminIdentity, PERMISSIONS_2)).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.userAcl.hasPermission(userIdentity, ADMIN_USERNAME)).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.userAcl.hasPermission(userIdentity, PERMISSIONS_2)).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.userAcl.hasPermission(userIdentity, TEST_USER)).thenReturn((Object)true);
        Mockito.lenient().when((Object)((CategoryLinkService)this.portalContainer.getComponentInstanceOfType(CategoryLinkService.class))).thenReturn((Object)this.categoryLinkService);
    }

    @Test
    void createApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.createApplication(null));
        Application application = this.application(null);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.applicationCenterService.createApplication(application, TEST_USER));
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.userAcl.getUserIdentity(TEST_USER)).thenReturn((Object)identity);
        Mockito.when((Object)this.userAcl.isAdministrator(identity)).thenReturn((Object)true);
        this.applicationCenterService.createApplication(application, TEST_USER);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).createApplication(application);
    }

    @Test
    void getApplication() {
        this.applicationCenterService.getApplication(5L);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).getApplication(5L);
    }

    @Test
    void findSystemApplicationByUrl() {
        this.applicationCenterService.findSystemApplicationByUrl("url");
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).findSystemApplicationByUrl("url");
    }

    @Test
    void updateApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.updateApplication(null, ADMIN_USERNAME));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.updateApplication(this.application(null), null));
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage, (VerificationMode)Mockito.never())).updateApplication((Application)ArgumentMatchers.any());
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterService.updateApplication(this.application(ID), TEST_USER));
        Mockito.when((Object)this.appCenterStorage.getApplication(ID.longValue())).thenReturn((Object)this.application());
        Assertions.assertThrows(IllegalAccessException.class, () -> this.applicationCenterService.updateApplication(this.application(ID), null));
        Assertions.assertThrows(IllegalAccessException.class, () -> this.applicationCenterService.updateApplication(this.application(ID), TEST_USER));
        this.applicationCenterService.updateApplication(this.application(ID), ADMIN_USERNAME);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).updateApplication((Application)ArgumentMatchers.any());
    }

    @Test
    void deleteApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.deleteApplication(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.deleteApplication(null, ADMIN_USERNAME));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.deleteApplication(ID, null));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterService.deleteApplication(ID, ADMIN_USERNAME));
        Application application = this.application();
        Mockito.when((Object)this.appCenterStorage.getApplication(ID.longValue())).thenReturn((Object)application);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.applicationCenterService.deleteApplication(ID, TEST_USER));
        this.applicationCenterService.deleteApplication(ID, ADMIN_USERNAME);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).deleteApplication(ID.longValue());
        application.setSystem(true);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.applicationCenterService.deleteApplication(ID, ADMIN_USERNAME));
    }

    @Test
    void addFavoriteApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.addFavoriteApplication(0L, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.addFavoriteApplication(0L, TEST_USER));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterService.addFavoriteApplication(ID.longValue(), TEST_USER));
        Application application = this.application();
        Mockito.when((Object)this.appCenterStorage.getApplication(ID.longValue())).thenReturn((Object)application);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.applicationCenterService.addFavoriteApplication(ID.longValue(), TEST_USER));
        this.applicationCenterService.addFavoriteApplication(ID.longValue(), ADMIN_USERNAME);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).addApplicationToUserFavorite(ID.longValue(), ADMIN_USERNAME);
        application.setPermissions(Collections.singletonList(TEST_USER));
        this.applicationCenterService.addFavoriteApplication(ID.longValue(), TEST_USER);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).addApplicationToUserFavorite(ID.longValue(), TEST_USER);
    }

    @Test
    void deleteFavoriteApplication() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.deleteFavoriteApplication(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.deleteFavoriteApplication(Long.valueOf(5L), null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.deleteFavoriteApplication(null, TEST_USER));
        this.applicationCenterService.deleteFavoriteApplication(ID, TEST_USER);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).deleteApplicationFavorite(ID, TEST_USER);
    }

    @Test
    void getApplicationsList() {
        ApplicationList applicationsList = this.applicationCenterService.getApplications(0, 0, KEYWORD);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)0, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)0L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)0L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)0L, (long)applicationsList.getLimit());
        Application application = this.application();
        Mockito.when((Object)this.appCenterStorage.getApplications(KEYWORD)).thenReturn(Collections.singletonList(application));
        applicationsList = this.applicationCenterService.getApplications(1, 2, KEYWORD);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)0, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)1L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)1L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)2L, (long)applicationsList.getLimit());
        applicationsList = this.applicationCenterService.getApplications(0, 2, KEYWORD);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)1, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)1L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)0L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)2L, (long)applicationsList.getLimit());
    }

    @Test
    void getPaginatedApplicationsList() {
        Application application1 = this.application(11L);
        Application application2 = this.application(12L);
        Application application3 = this.application(13L);
        Application application4 = this.application(14L);
        Application application5 = this.application(15L);
        Mockito.when((Object)this.appCenterStorage.getApplications(null)).thenReturn(Arrays.asList(application1, application2, application3, application4, application5));
        ApplicationList applicationsList = this.applicationCenterService.getApplications(0, 2, null);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)2, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)5L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)0L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)2L, (long)applicationsList.getLimit());
        applicationsList = this.applicationCenterService.getApplications(2, 2, null);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)2, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)5L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)2L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)2L, (long)applicationsList.getLimit());
        applicationsList = this.applicationCenterService.getApplications(4, 2, null);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)1, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)5L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)4L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)2L, (long)applicationsList.getLimit());
    }

    @Test
    void updateFavoriteApplicationOrder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(ID, Long.valueOf(1L)), ""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(Long.valueOf(0L), Long.valueOf(1L)), ADMIN_USERNAME));
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(ID, Long.valueOf(1L)), ADMIN_USERNAME));
        Mockito.when((Object)this.appCenterStorage.getApplication(ID.longValue())).thenReturn((Object)this.application());
        this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(ID, Long.valueOf(1L)), ADMIN_USERNAME);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).updateFavoriteApplicationOrder(ID.longValue(), ADMIN_USERNAME, Long.valueOf(1L));
    }

    @Test
    void updateFavoriteApplicationOrderWhenMandatory() {
        Application application = this.application();
        Mockito.when((Object)this.appCenterStorage.getApplication(ID.longValue())).thenReturn((Object)application);
        this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(ID, Long.valueOf(1L)), ADMIN_USERNAME);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).updateFavoriteApplicationOrder(ID.longValue(), ADMIN_USERNAME, Long.valueOf(1L));
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage, (VerificationMode)Mockito.never())).addApplicationToUserFavorite(ID.longValue(), ADMIN_USERNAME);
        application.setMandatory(false);
        this.applicationCenterService.updateFavoriteApplicationOrder(new ApplicationOrder(ID, Long.valueOf(1L)), ADMIN_USERNAME);
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).addApplicationToUserFavorite(ID.longValue(), ADMIN_USERNAME);
    }

    @Test
    void getActiveApplications() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.getActiveApplications(0, 0, null, null));
        ApplicationList applicationsList = this.applicationCenterService.getActiveApplications(0, 0, null, Locale.ENGLISH, TEST_USER);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)0, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)0L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)0L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)0L, (long)applicationsList.getLimit());
        applicationsList = this.applicationCenterService.getActiveApplications(2, 3, null, ADMIN_USERNAME);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)0, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)0L, (long)applicationsList.getSize());
        Assertions.assertEquals((long)2L, (long)applicationsList.getOffset());
        Assertions.assertEquals((long)3L, (long)applicationsList.getLimit());
        String keyword1 = "keyword1";
        Application application = this.application();
        application.setActive(false);
        Mockito.when((Object)this.appCenterStorage.getApplications(keyword1)).thenReturn(Collections.singletonList(application));
        applicationsList = this.applicationCenterService.getActiveApplications(0, 0, keyword1, ADMIN_USERNAME);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)0, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)0L, (long)applicationsList.getSize());
        application.setActive(true);
        String englishTitle = "titleEN";
        String englishDesc = "descEN";
        applicationsList = this.applicationCenterService.getActiveApplications(0, 0, keyword1, Locale.ENGLISH, ADMIN_USERNAME);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)1, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)1L, (long)applicationsList.getSize());
        Assertions.assertEquals((Object)TITLE, (Object)((Application)applicationsList.getApplications().get(0)).getTitle());
        Assertions.assertEquals((Object)DESCRIPTION, (Object)((Application)applicationsList.getApplications().get(0)).getDescription());
        Mockito.when((Object)this.translationService.getTranslationLabelOrDefault("appCenter", application.getId().longValue(), TITLE, Locale.ENGLISH)).thenReturn((Object)englishTitle);
        Mockito.when((Object)this.translationService.getTranslationLabelOrDefault("appCenter", application.getId().longValue(), DESCRIPTION, Locale.ENGLISH)).thenReturn((Object)englishDesc);
        applicationsList = this.applicationCenterService.getActiveApplications(0, 0, keyword1, Locale.ENGLISH, ADMIN_USERNAME);
        Assertions.assertEquals((Object)englishTitle, (Object)((Application)applicationsList.getApplications().get(0)).getTitle());
        Assertions.assertEquals((Object)englishDesc, (Object)((Application)applicationsList.getApplications().get(0)).getDescription());
        application.setPermissions(null);
        applicationsList = this.applicationCenterService.getActiveApplications(0, 0, keyword1, ADMIN_USERNAME);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)0, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)0L, (long)applicationsList.getSize());
        applicationsList = this.applicationCenterService.getActiveApplications(0, 0, keyword1, "anotherUser");
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)0, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)0L, (long)applicationsList.getSize());
        Mockito.when((Object)this.userAcl.hasPermission(this.userAcl.getUserIdentity(ADMIN_USERNAME), "*:/platform/users")).thenReturn((Object)true);
        applicationsList = this.applicationCenterService.getActiveApplications(0, 0, keyword1, ADMIN_USERNAME);
        Assertions.assertNotNull((Object)applicationsList);
        Assertions.assertNotNull((Object)applicationsList.getApplications());
        Assertions.assertEquals((int)1, (int)applicationsList.getApplications().size());
        Assertions.assertEquals((long)1L, (long)applicationsList.getSize());
    }

    @Test
    void getLastUpdated() {
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterService.getApplicationImageLastUpdated(50000L));
        Application application = this.application();
        Mockito.when((Object)this.appCenterStorage.getApplication(ID.longValue())).thenReturn((Object)application);
        Long lastUpdated = this.applicationCenterService.getApplicationImageLastUpdated(application.getId().longValue());
        Assertions.assertNotNull((Object)lastUpdated);
        application.setImageFileId(null);
        Assert.assertNull((Object)this.applicationCenterService.getApplicationImageLastUpdated(application.getId().longValue()));
    }

    @Test
    void getImageStream() {
        Assertions.assertThrows(ApplicationNotFoundException.class, () -> this.applicationCenterService.getApplicationImageInputStream(50000L));
        Application application = this.application();
        Mockito.when((Object)this.appCenterStorage.getApplication(ID.longValue())).thenReturn((Object)application);
        Mockito.when((Object)this.appCenterStorage.getApplicationImageInputStream(5L)).thenReturn((Object)((InputStream)Mockito.mock(InputStream.class)));
        InputStream stream = this.applicationCenterService.getApplicationImageInputStream(application.getId().longValue());
        Assertions.assertNotNull((Object)stream);
        application.setImageFileId(null);
        Assert.assertNull((Object)this.applicationCenterService.getApplicationImageInputStream(application.getId().longValue()));
    }

    @Test
    void getSystemApplications() {
        this.applicationCenterService.getSystemApplications();
        ((ApplicationCenterStorage)Mockito.verify((Object)this.appCenterStorage)).getSystemApplications();
    }

    @Test
    void getApplicationShortcuts() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.applicationCenterService.getActiveApplications(0, 0, null, null));
        Application application = this.application();
        Mockito.when((Object)this.appCenterStorage.getApplications(null)).thenReturn(Collections.singletonList(application));
        List shortcuts = this.applicationCenterService.getApplicationShortcuts(ADMIN_USERNAME);
        Assertions.assertNotNull((Object)shortcuts);
        Assertions.assertEquals((int)1, (int)shortcuts.size());
        Assertions.assertEquals((Object)SHORTCUT, shortcuts.get(0));
    }

    @Test
    void testGetMandatoryAndFavoriteApplications() {
        PageRequest pageable = PageRequest.of((int)0, (int)5);
        UserApplication application1 = new UserApplication(this.application(1L));
        UserApplication application2 = new UserApplication(this.application(2L));
        UserApplication application3 = new UserApplication(this.application(3L));
        UserApplication application4 = new UserApplication(this.application(4L));
        UserApplication application5 = new UserApplication(this.application(5L));
        application1.setPermissions(Collections.singletonList(PERMISSIONS_2));
        application2.setPermissions(Collections.singletonList(PERMISSIONS_2));
        application3.setPermissions(Collections.singletonList(PERMISSIONS_2));
        application4.setPermissions(Collections.singletonList(PERMISSIONS_2));
        Mockito.when((Object)this.appCenterStorage.getMandatoryAndFavoriteApplications(TEST_USER, (Pageable)pageable)).thenReturn(Arrays.asList(application1, application2, application3, application4, application5));
        Mockito.when((Object)this.appCenterStorage.countFavorites(TEST_USER)).thenReturn((Object)3L);
        ApplicationList applicationList = this.applicationCenterService.getMandatoryAndFavoriteApplications((Pageable)pageable, TEST_USER, null);
        Assertions.assertNotNull((Object)applicationList);
        Assertions.assertNotNull((Object)applicationList.getApplications());
        Assertions.assertEquals((int)4, (int)applicationList.getApplications().size());
        Assertions.assertEquals((long)4L, (long)applicationList.getSize());
        Assertions.assertEquals((long)4L, (long)applicationList.getLimit());
        Assertions.assertEquals((long)0L, (long)applicationList.getOffset());
    }

    private Application application() {
        return this.application(ID);
    }

    private Application application(Long id) {
        return new Application(id, TITLE, URL, true, HELP_PAGE_URL, DESCRIPTION, SHORTCUT, ApplicationType.LINK, true, true, false, true, false, true, Collections.singletonList(PERMISSIONS_1), null, Long.valueOf(5L), "icon", null, null, false);
    }
}

