/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.service;

import io.meeds.billing.utils.Utils;
import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SubscriptionEmailReminderService {
    private static final Log LOG = ExoLogger.getLogger(SubscriptionEmailReminderService.class);
    private static final Pattern I18N_LABEL_PATTERN = Pattern.compile("\\$\\{([a-zA-Z0-9\\.]+)\\}");
    private static final String USER_FULL_NAME_PARAM = "$USER_FULL_NAME";
    private static final String RECIPIENT_FULL_NAME_PARAM = "$RECIPIENT_FULL_NAME";
    private static final String SITE_NAME_PARAM = "$SITE_NAME";
    private static final String COMPANY_LINK_PARAM = "$COMPANY_LINK";
    private static final String BODY_FIRST_PART_PARAM = "$BODY_FIRST_PART";
    private static final String BODY_SECOND_PART_PARAM = "$BODY_SECOND_PART";
    private static final String PRIMARY_COLOR_PARAM = "$PRIMARY_COLOR";
    @Value(value="${meeds.billing.subscription.reminder.email.templatePath:assets/subscription-email-reminder.html}")
    private String emailBodyPath;
    private String emailBodyTemplate;
    @Autowired
    private MailService mailService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private ResourceBundleService resourceBundleService;
    @Autowired
    private BrandingService brandingService;
    @Autowired
    private PermanentLinkService permanentLinkService;

    public void sendEmailNotification(String userName, List<String> recipients, long spaceId, String context) {
        String senderEmail = userName != null ? this.getUserMail(userName) : MailUtils.getSenderEmail();
        String senderFullName = userName != null ? this.getUserFullName(userName) : MailUtils.getSenderName();
        String from = userName == null && senderFullName != null ? senderFullName + "<" + senderEmail + ">" : senderEmail;
        String lang = this.getUserLang(userName);
        String subject = this.getEmailSubject(context, lang);
        for (String recipient : recipients) {
            try {
                this.sendEmail(from, userName, senderFullName, recipient, spaceId, context, lang, subject);
            }
            catch (Exception e) {
                LOG.warn("Unable to send email to {} , {}", new Object[]{recipient, e.getMessage()});
            }
        }
    }

    private void sendEmail(String from, String senderUserName, String senderFullName, String recipient, long spaceId, String context, String lang, String subject) throws Exception {
        String body = this.getEmailBody(senderUserName, senderFullName, this.getUserFullName(recipient), spaceId, context, lang);
        MimeMessage mimeMessage = new MimeMessage(this.mailService.getMailSession());
        mimeMessage.setFrom(from);
        mimeMessage.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.getUserMail(recipient)));
        mimeMessage.setSubject(StringEscapeUtils.unescapeHtml4((String)subject), "UTF-8");
        mimeMessage.setSentDate(new Date());
        mimeMessage.setContent((Object)body, "text/html; charset=utf-8");
        this.mailService.sendMessage(mimeMessage);
    }

    private String getEmailBody(String username, String userFullName, String recipientFullName, long spaceId, String context, String lang) {
        String content = this.getEmailBody();
        content = content.replace(BODY_FIRST_PART_PARAM, this.getBodyFirstPart(username, userFullName, spaceId, context, lang));
        content = content.replace(BODY_SECOND_PART_PARAM, this.getBodySecondPart(spaceId, context, lang));
        content = content.replace(USER_FULL_NAME_PARAM, userFullName);
        content = content.replace(RECIPIENT_FULL_NAME_PARAM, recipientFullName);
        content = content.replace(SITE_NAME_PARAM, this.brandingService.getCompanyName());
        content = content.replace(COMPANY_LINK_PARAM, LinkProviderUtils.getBaseUrl());
        content = content.replace(PRIMARY_COLOR_PARAM, (CharSequence)this.brandingService.getThemeStyle().get("primaryColor"));
        content = this.replaceI18nKey(content, lang);
        return content;
    }

    private String getEmailBody() {
        if (this.emailBodyTemplate == null) {
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.emailBodyPath);){
                this.emailBodyTemplate = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            }
        }
        return this.emailBodyTemplate;
    }

    private String getUserMail(String userName) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(userName);
        if (user == null) {
            throw new IllegalArgumentException();
        }
        return user.getEmail();
    }

    private String getUserFullName(String userName) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(userName);
        if (user == null) {
            throw new IllegalArgumentException();
        }
        return user.getDisplayName();
    }

    private String getEmailSubject(String context, String lang) {
        Locale locale = LocaleUtils.toLocale((String)lang);
        switch (context) {
            case "trialEnding": {
                return this.resourceBundleService.getSharedString("Notification.subject.billing.subscription.trialEnding", locale);
            }
            case "subscriptionRenewal": {
                return this.resourceBundleService.getSharedString("Notification.subject.billing.subscription.renewal", locale);
            }
            case "trialExpired": {
                return this.resourceBundleService.getSharedString("Notification.subject.billing.subscription.trialExpired", locale);
            }
            case "subscriptionPastDue": {
                return this.resourceBundleService.getSharedString("Notification.subject.billing.subscription.pastDue", locale);
            }
            case "maxOfUsersExceeded": {
                return this.resourceBundleService.getSharedString("Notification.subject.billing.hub.maxOfUsersExceeded", locale);
            }
            case "hubPlanChanged": {
                return this.resourceBundleService.getSharedString("Notification.subject.billing.hub.planChanged", locale);
            }
            case "subscriptionCanceled": {
                return this.resourceBundleService.getSharedString("Notification.subject.billing.hub.subscriptionCanceled", locale);
            }
        }
        return "";
    }

    private String getBodyFirstPart(String username, String userFullName, long spaceId, String context, String lang) {
        if (StringUtils.isBlank((CharSequence)context)) {
            return "";
        }
        Locale locale = LocaleUtils.toLocale((String)lang);
        boolean userTriggered = username != null;
        String contentKey = switch (context) {
            case "hubPlanChanged" -> "Notification.body.firstPart.hub.planChanged";
            case "subscriptionCanceled" -> {
                if (userTriggered) {
                    yield "Notification.body.subscription.cancelled.userTriggered";
                }
                yield "Notification.body.subscription.cancelled.systemTriggered";
            }
            case "subscriptionRenewal" -> "Notification.body.subscription.renewal";
            case "trialEnding" -> "Notification.body.subscription.trialEnding";
            case "trialExpired" -> "Notification.body.subscription.trialExpired";
            case "subscriptionPastDue" -> "Notification.body.subscription.pastDue";
            case "maxOfUsersExceeded" -> "Notification.body.firstPart.hub.maxOfUsersExceeded";
            default -> "";
        };
        String content = this.resourceBundleService.getSharedString(contentKey, locale);
        if (!userTriggered) {
            return content.replace("{0}", this.getSpaceFullLink(spaceId, null, null, null));
        }
        content = (content = content.replace("{0}", this.getSenderFullNameLink(username, userFullName))).contains("{1}") ? content.replace("{1}", this.getSpaceFullLink(spaceId, null, null, null)) : content;
        return content;
    }

    private String getBodySecondPart(long spaceId, String context, String lang) {
        String linkPart = "";
        linkPart = context.equalsIgnoreCase("trialEnding") || context.equalsIgnoreCase("subscriptionRenewal") ? this.getSpaceFullLink(spaceId, "settings", "Notification.body.subscription.settings", lang) : this.getSpaceFullLink(spaceId, null, "Notification.body.subscription.homeAccess", lang);
        Locale locale = LocaleUtils.toLocale((String)lang);
        String bodySecondPart = "";
        switch (context) {
            case "trialEnding": 
            case "subscriptionRenewal": {
                bodySecondPart = this.resourceBundleService.getSharedString("Notification.body.subscription.manage", locale);
                break;
            }
            case "trialExpired": 
            case "subscriptionPastDue": {
                bodySecondPart = this.resourceBundleService.getSharedString("Notification.body.subscription.expiration.manage", locale);
                break;
            }
            case "maxOfUsersExceeded": {
                bodySecondPart = this.resourceBundleService.getSharedString("Notification.body.secondPart.hub.maxOfUsersExceeded", locale);
                break;
            }
            case "hubPlanChanged": {
                bodySecondPart = this.resourceBundleService.getSharedString("Notification.body.secondPart.planChanged", locale);
                break;
            }
            case "subscriptionCanceled": {
                bodySecondPart = this.resourceBundleService.getSharedString("Notification.body.secondPart.subscription.cancelled", locale);
            }
        }
        return bodySecondPart.replace("{0}", linkPart);
    }

    private String getSenderFullNameLink(String username, String userFullName) {
        String profileLink = LinkProviderUtils.getRedirectUrl((String)"user", (String)username);
        return "<strong><a target=\"_blank\" style=\"color: #2f5e92; text-decoration: none; font-family: 'HelveticaNeue Bold', Helvetica, Arial, sans-serif\" href=\"" + profileLink + "\">" + userFullName + "</a></strong>";
    }

    private String getUserLang(String userName) throws Exception {
        UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(userName);
        if (userProfile != null && userProfile.getAttribute("user.language") != null) {
            return userProfile.getAttribute("user.language");
        }
        return ResourceBundleService.DEFAULT_CROWDIN_LANGUAGE;
    }

    private String replaceI18nKey(String content, String lang) {
        Matcher matcher = I18N_LABEL_PATTERN.matcher(content);
        while (matcher.find()) {
            String i18nKey = matcher.group(1);
            String label = this.resourceBundleService.getSharedString(i18nKey, LocaleUtils.toLocale((String)lang));
            content = content.replace(matcher.group(), label);
        }
        return content;
    }

    private String getSpaceFullLink(long spaceId, String applicationUri, String i18nKey, String lang) {
        PermanentLinkObject object = new PermanentLinkObject("space", String.valueOf(spaceId));
        if (applicationUri != null) {
            object.addParameter("applicationUri", applicationUri);
        }
        String spaceLink = CommonsUtils.getCurrentDomain() + this.permanentLinkService.getPermanentLink(object);
        String linkLabel = i18nKey != null ? this.resourceBundleService.getSharedString(i18nKey, LocaleUtils.toLocale((String)lang)) : Utils.getSpaceDisplayName(spaceId);
        return "<strong><a target=\"_blank\" " + "style=\"color: #2f5e92; text-decoration: none; font-family: 'HelveticaNeue Bold', Helvetica, Arial, sans-serif\" " + "href=\"" + spaceLink + "\">" + linkLabel + "</a></strong>";
    }

    @Generated
    public String getEmailBodyPath() {
        return this.emailBodyPath;
    }

    @Generated
    public void setEmailBodyPath(String emailBodyPath) {
        this.emailBodyPath = emailBodyPath;
    }

    @Generated
    public void setEmailBodyTemplate(String emailBodyTemplate) {
        this.emailBodyTemplate = emailBodyTemplate;
    }
}

