/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.LoginLinkCreateOnAccountParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class LoginLink
extends ApiResource {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="url")
    String url;

    public static LoginLink createOnAccount(String account) throws StripeException {
        return LoginLink.createOnAccount(account, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static LoginLink createOnAccount(String account, RequestOptions options) throws StripeException {
        return LoginLink.createOnAccount(account, (Map<String, Object>)null, options);
    }

    public static LoginLink createOnAccount(String account, Map<String, Object> params) throws StripeException {
        return LoginLink.createOnAccount(account, params, (RequestOptions)null);
    }

    public static LoginLink createOnAccount(String account, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/login_links", ApiResource.urlEncodeId(account));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (LoginLink)LoginLink.getGlobalResponseGetter().request(request, (Type)((Object)LoginLink.class));
    }

    public static LoginLink createOnAccount(String account, LoginLinkCreateOnAccountParams params) throws StripeException {
        return LoginLink.createOnAccount(account, params, (RequestOptions)null);
    }

    public static LoginLink createOnAccount(String account, LoginLinkCreateOnAccountParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/login_links", ApiResource.urlEncodeId(account));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (LoginLink)LoginLink.getGlobalResponseGetter().request(request, (Type)((Object)LoginLink.class));
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginLink)) {
            return false;
        }
        LoginLink other = (LoginLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LoginLink;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }
}

