/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.core;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.Event;
import com.stripe.model.v2.EventDestination;
import com.stripe.model.v2.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.core.EventDestinationCreateParams;
import com.stripe.param.v2.core.EventDestinationListParams;
import com.stripe.param.v2.core.EventDestinationRetrieveParams;
import com.stripe.param.v2.core.EventDestinationUpdateParams;
import java.lang.reflect.Type;

public final class EventDestinationService
extends ApiService {
    public EventDestinationService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<EventDestination> list(EventDestinationListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<EventDestination> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<EventDestination> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<EventDestination> list(EventDestinationListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/core/event_destinations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<EventDestination>>(){}.getType());
    }

    public EventDestination create(EventDestinationCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public EventDestination create(EventDestinationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/core/event_destinations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (EventDestination)this.request(request, (Type)((Object)EventDestination.class));
    }

    public EventDestination delete(String id) throws StripeException {
        return this.delete(id, null);
    }

    public EventDestination delete(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/event_destinations/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options);
        return (EventDestination)this.request(request, (Type)((Object)EventDestination.class));
    }

    public EventDestination retrieve(String id, EventDestinationRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public EventDestination retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public EventDestination retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public EventDestination retrieve(String id, EventDestinationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/event_destinations/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (EventDestination)this.request(request, (Type)((Object)EventDestination.class));
    }

    public EventDestination update(String id, EventDestinationUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public EventDestination update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public EventDestination update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public EventDestination update(String id, EventDestinationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/event_destinations/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (EventDestination)this.request(request, (Type)((Object)EventDestination.class));
    }

    public EventDestination disable(String id) throws StripeException {
        return this.disable(id, null);
    }

    public EventDestination disable(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/event_destinations/%s/disable", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (EventDestination)this.request(request, (Type)((Object)EventDestination.class));
    }

    public EventDestination enable(String id) throws StripeException {
        return this.enable(id, null);
    }

    public EventDestination enable(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/event_destinations/%s/enable", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (EventDestination)this.request(request, (Type)((Object)EventDestination.class));
    }

    public Event ping(String id) throws StripeException {
        return this.ping(id, null);
    }

    public Event ping(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/event_destinations/%s/ping", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (Event)this.request(request, (Type)((Object)Event.class));
    }
}

