export function getCustomerPortalLink(spaceId) {
  return fetch(`/billing/rest/billing/customer-portal/${spaceId}`, {
    credentials: 'include',
    method: 'GET',
  }).then((resp) => {
    if ((resp && resp.ok)) {
      return resp.text();
    } else {
      throw new Error('Error while opening customer portal');
    }
  });
}
export function cancelSubscription(spaceId) {
  return fetch(`/billing/rest/billing/subscription/${spaceId}/cancel`, {
    credentials: 'include',
    method: 'DELETE',
  }).then((resp) => {
    if (!resp?.ok) {
      throw new Error('Error while opening customer portal');
    }
  });
}

export function notifyOnSubscriptionState(spaceId, maxOfUsersExceeded) {
  return fetch(`/billing/rest/billing/notify/subscription-status/${spaceId}?maxOfUsersExceeded=${maxOfUsersExceeded || false}`, {
    credentials: 'include',
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify('{}'),
  }).then((resp) => {
    if (!resp?.ok) {
      throw new Error('Error while notifying admin on subscription state');
    }
  });
}