/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billig.service;

import com.stripe.StripeClient;
import com.stripe.model.Price;
import com.stripe.model.Subscription;
import io.meeds.billing.model.HubBilling;
import io.meeds.billing.model.HubBillingSettings;
import io.meeds.billing.service.BillingService;
import io.meeds.billing.service.HubSettingService;
import io.meeds.billing.service.SubscriptionEmailReminderService;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.config.serialize.model.SiteLayout;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.bean.override.mockito.MockitoBean;

@SpringBootTest(classes={BillingService.class})
@ExtendWith(value={MockitoExtension.class})
public class BillingServiceTest {
    @MockitoBean
    private SpaceService spaceService;
    @MockitoBean
    private HubSettingService hubSettingService;
    @MockitoBean
    private SubscriptionEmailReminderService subscriptionEmailReminderService;
    @MockitoBean
    private IdentityManager identityManager;
    @MockitoBean
    private LayoutService layoutService;
    @MockitoBean
    private HubBilling hubBilling;
    @MockitoBean
    private StripeClient stripeClient;
    private BillingService billingService;

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.hubBilling.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.hubBilling.getSecretKey()).thenReturn((Object)"secret");
        this.billingService = (BillingService)Mockito.spy((Object)new BillingService(this.hubBilling, this.subscriptionEmailReminderService, this.spaceService, this.hubSettingService, this.identityManager, this.layoutService));
    }

    @Test
    public void billingServiceEnablementTest() {
        TestCase.assertTrue((boolean)this.billingService.isEnabled());
    }

    @Test
    public void enableExistingSpaceBillingTest() throws Exception {
        long spaceId = 1L;
        String priceId = "priceId";
        String spaceManager = "john";
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)space.getId()).thenReturn((Object)String.valueOf(spaceId));
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)"groupId");
        Mockito.when((Object)this.spaceService.getSpaceById(spaceId)).thenReturn(null).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.canManageSpace(space, spaceManager)).thenReturn((Object)true);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.billingService.enableExistingSpaceBilling(spaceId, priceId, spaceManager));
        HubBillingSettings hubBillingSettings = (HubBillingSettings)Mockito.mock(HubBillingSettings.class);
        Mockito.when((Object)this.hubSettingService.getSettingsBySpaceId(space.getId())).thenReturn((Object)hubBillingSettings).thenReturn(null);
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.billingService.enableExistingSpaceBilling(spaceId, priceId, spaceManager));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.billingService.enableExistingSpaceBilling(spaceId, null, spaceManager));
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(spaceManager)).thenReturn((Object)identity);
        Price price = (Price)Mockito.mock(Price.class);
        Subscription subscription = (Subscription)Mockito.mock(Subscription.class);
        Mockito.when((Object)price.getId()).thenReturn((Object)priceId);
        ((BillingService)Mockito.doReturn((Object)price).when((Object)this.billingService)).getPriceById(priceId);
        ((BillingService)Mockito.doReturn((Object)"customer_id").when((Object)this.billingService)).createCustomer(space, identity);
        ((BillingService)Mockito.doReturn((Object)subscription).when((Object)this.billingService)).subscribe(space, "customer_id", priceId);
        ((HubSettingService)Mockito.doNothing().when((Object)this.hubSettingService)).createSettings(space, subscription, identity);
        ((BillingService)Mockito.doNothing().when((Object)this.billingService)).updateBillableSpaceLayout((SiteKey)ArgumentMatchers.any(SiteKey.class));
        this.billingService.enableExistingSpaceBilling(spaceId, priceId, spaceManager);
        ((BillingService)Mockito.verify((Object)this.billingService, (VerificationMode)Mockito.times((int)1))).getPriceById(priceId);
        ((BillingService)Mockito.verify((Object)this.billingService, (VerificationMode)Mockito.times((int)1))).createCustomer(space, identity);
        ((BillingService)Mockito.verify((Object)this.billingService, (VerificationMode)Mockito.times((int)1))).subscribe(space, "customer_id", priceId);
        ((HubSettingService)Mockito.verify((Object)this.hubSettingService, (VerificationMode)Mockito.times((int)1))).createSettings(space, subscription, identity);
        ((BillingService)Mockito.verify((Object)this.billingService, (VerificationMode)Mockito.times((int)1))).updateBillableSpaceLayout((SiteKey)ArgumentMatchers.any(SiteKey.class));
    }

    @Test
    void updateBillableSpaceLayoutTest() {
        SiteKey siteKey = (SiteKey)Mockito.mock(SiteKey.class);
        SiteLayout existingLayout = new SiteLayout();
        Application existingApp = new Application();
        existingLayout.setChildren(new ArrayList<Application>(List.of(existingApp)));
        PortalConfig portalConfig = new PortalConfig();
        portalConfig.setAccessPermissions(new String[]{"*:/spaces"});
        portalConfig.setPortalLayout((Container)existingLayout);
        Mockito.when((Object)this.layoutService.getPortalConfig(siteKey)).thenReturn((Object)portalConfig);
        this.billingService.updateBillableSpaceLayout(siteKey);
        ArrayList children = portalConfig.getPortalLayout().getChildren();
        TestCase.assertEquals((int)2, (int)children.size());
        Application addedApp = (Application)children.get(1);
        TestCase.assertEquals((String)"billing/HubSubscriptionRestriction", (String)((TransientApplicationState)addedApp.getState()).getContentId());
        Assert.assertArrayEquals((Object[])portalConfig.getAccessPermissions(), (Object[])addedApp.getAccessPermissions());
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save(portalConfig);
    }
}

