/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billig.rest;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.billing.rest.BillingRest;
import io.meeds.billing.service.BillingService;
import io.meeds.billing.service.HubSettingService;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={BillingRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
public class BillingRestTest {
    private static final String BILLING_PATH = "/billing";
    private static final String SIMPLE_USER = "simple";
    private static final String ADMIN_USER = "admin";
    private static final String TEST_PASSWORD = "testPassword";
    static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @MockitoBean
    private IdentityManager identityManager;
    @MockitoBean
    HubSettingService hubSettingService;
    @MockitoBean
    BillingService billingService;
    private MockMvc mockMvc;

    @BeforeEach
    public void setUp() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    public void shouldReturnNotFoundIfNoHubSettings() throws Exception {
        Mockito.when((Object)this.billingService.createCustomerPortalSession(ArgumentMatchers.anyLong(), ArgumentMatchers.anyString())).thenThrow(ObjectNotFoundException.class);
        try (MockedStatic<ConversationState> conversationStateMock = this.mockCurrentIdentityId();){
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/billing/customer-portal/123", (Object[])new Object[0]).with(this.testSimpleUser())).andExpect(MockMvcResultMatchers.status().isNotFound());
        }
    }

    @Test
    public void shouldReturnForbiddenIfUserIsNotManager() throws Exception {
        Mockito.when((Object)this.billingService.createCustomerPortalSession(ArgumentMatchers.anyLong(), ArgumentMatchers.anyString())).thenThrow(IllegalAccessException.class);
        try (MockedStatic<ConversationState> conversationStateMock = this.mockCurrentIdentityId();){
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/billing/customer-portal/123", (Object[])new Object[0]).with(this.testSimpleUser())).andExpect(MockMvcResultMatchers.status().isForbidden());
        }
    }

    @Test
    public void shouldReturnCustomerPortalUrl() throws Exception {
        Mockito.when((Object)this.billingService.createCustomerPortalSession(ArgumentMatchers.anyLong(), ArgumentMatchers.anyString())).thenReturn((Object)"customerPortalUrl");
        try (MockedStatic<ConversationState> conversationStateMock = this.mockCurrentIdentityId();){
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/billing/customer-portal/123", (Object[])new Object[0]).with(this.testSimpleUser())).andExpect(MockMvcResultMatchers.status().isOk());
        }
    }

    @Test
    public void testCancelSubscription() throws Exception {
        ((BillingService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.billingService)).cancelSubscription(ArgumentMatchers.anyLong(), ArgumentMatchers.anyString());
        try (MockedStatic<ConversationState> conversationStateMock = this.mockCurrentIdentityId();){
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/billing/subscription/123/cancel", (Object[])new Object[0]).with(this.testSimpleUser())).andExpect(MockMvcResultMatchers.status().isForbidden());
            ((BillingService)Mockito.doNothing().when((Object)this.billingService)).cancelSubscription(ArgumentMatchers.anyLong(), ArgumentMatchers.anyString());
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/billing/subscription/123/cancel", (Object[])new Object[0]).with(this.testSimpleUser())).andExpect(MockMvcResultMatchers.status().isNoContent());
        }
    }

    @Test
    public void testNotifyOnSubscriptionStatus() throws Exception {
        ((BillingService)Mockito.doThrow(IllegalAccessException.class).doNothing().when((Object)this.billingService)).notifyOnSubscriptionStatus(ArgumentMatchers.anyLong(), ArgumentMatchers.anyString(), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue());
        try (MockedStatic<ConversationState> conversationStateMock = this.mockCurrentIdentityId();){
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/billing/notify/subscription-status/123", (Object[])new Object[0]).with(this.testSimpleUser())).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/billing/notify/subscription-status/123", (Object[])new Object[0]).with(this.testSimpleUser())).andExpect(MockMvcResultMatchers.status().isNoContent());
        }
    }

    @Test
    public void testNotifyHubAdminsOnUsersLimitExceeded() throws Exception {
        ((BillingService)Mockito.doNothing().when((Object)this.billingService)).notifyOnSubscriptionStatus(ArgumentMatchers.anyLong(), ArgumentMatchers.anyString(), ((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue());
        try (MockedStatic<ConversationState> conversationStateMock = this.mockCurrentIdentityId();){
            this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/billing/notify/subscription-status/123?maxOfUsersExceeded=true", (Object[])new Object[0]).with(this.testSimpleUser())).andExpect(MockMvcResultMatchers.status().isNoContent());
        }
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }

    public static MockedStatic<ConversationState> mockConversationState() {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        ConversationState conversationState = (ConversationState)Mockito.mock(ConversationState.class);
        MockedStatic conversationStateStatic = Mockito.mockStatic(ConversationState.class);
        conversationStateStatic.when(ConversationState::getCurrent).thenReturn((Object)conversationState);
        Mockito.when((Object)conversationState.getIdentity()).thenReturn((Object)identity);
        return conversationStateStatic;
    }

    public MockedStatic<ConversationState> mockCurrentIdentityId() {
        MockedStatic<ConversationState> conversationStateStatic = BillingRestTest.mockConversationState();
        Mockito.when((Object)ConversationState.getCurrent().getIdentity().getUserId()).thenReturn((Object)SIMPLE_USER);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.lenient().when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(SIMPLE_USER)).thenReturn((Object)identity);
        return conversationStateStatic;
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

