/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.billing.utils;

import com.stripe.model.Plan;
import com.stripe.model.Subscription;
import com.stripe.model.SubscriptionItem;
import com.stripe.model.SubscriptionItemCollection;
import io.meeds.billing.entity.HubBillingPlanEntity;
import io.meeds.billing.entity.HubBillingSettingsEntity;
import io.meeds.billing.model.HubBillingPlan;
import io.meeds.billing.model.HubBillingSettings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class Utils {
    public static final String PUBLIC_KEY_PROPERTY = "meeds.billing.publicKey";
    public static final String PRICING_TABLE_ID_PROPERTY = "meeds.billing.pricingTable.id";
    public static final String BILLING_ENABLED_PROPERTY = "meeds.billing.enabled";
    public static final String SUBSCRIPTION_RENEWAL = "subscriptionRenewal";
    public static final String TRIAL_ENDING = "trialEnding";
    public static final String TRIAL_EXPIRED = "trialExpired";
    public static final String SUBSCRIPTION_PAST_DUE = "subscriptionPastDue";
    public static final String HUB_USERS_LIMIT_EXCEEDED = "maxOfUsersExceeded";
    public static final String HUB_PLAN_CHANGED = "hubPlanChanged";
    public static final String SUBSCRIPTION_CANCELED = "subscriptionCanceled";

    private Utils() {
    }

    public static HubBillingSettings fromEntity(HubBillingSettingsEntity s) {
        return new HubBillingSettings(s.getId(), s.getSpaceId(), s.getUserIdentityId(), s.getCreatedDate(), s.getUpdatedDate(), s.getCustomerId(), s.getSubscriptionId(), s.getSubscriptionStatus(), s.getSubscriptionPreviousStatus(), s.getSubscriptionCurrentPeriodEnd(), Utils.fromEntity(s.getPlan()));
    }

    public static HubBillingSettingsEntity toEntity(HubBillingSettings s) {
        HubBillingSettingsEntity hubBillingSettingsEntity = new HubBillingSettingsEntity();
        hubBillingSettingsEntity.setId(s.getId());
        hubBillingSettingsEntity.setSpaceId(s.getSpaceId());
        hubBillingSettingsEntity.setUserIdentityId(s.getUserIdentityId());
        hubBillingSettingsEntity.setCreatedDate(s.getCreatedDate());
        hubBillingSettingsEntity.setUpdatedDate(s.getUpdatedDate());
        hubBillingSettingsEntity.setCustomerId(s.getCustomerId());
        hubBillingSettingsEntity.setSubscriptionId(s.getSubscriptionId());
        hubBillingSettingsEntity.setSubscriptionStatus(s.getSubscriptionStatus());
        hubBillingSettingsEntity.setSubscriptionPreviousStatus(s.getSubscriptionPreviousStatus());
        hubBillingSettingsEntity.setSubscriptionCurrentPeriodEnd(s.getSubscriptionCurrentPeriodEnd());
        hubBillingSettingsEntity.setPlan(Utils.toEntity(s.getHubBillingPlan()));
        return hubBillingSettingsEntity;
    }

    public static Date getCurrentPeriodEndDate(Subscription subscription) {
        SubscriptionItemCollection items = subscription.getItems();
        if (items != null && items.getData() != null && !items.getData().isEmpty()) {
            SubscriptionItem firstItem = (SubscriptionItem)items.getData().getFirst();
            long stripeTimestampInSeconds = firstItem.getCurrentPeriodEnd();
            Instant instant = Instant.ofEpochSecond(stripeTimestampInSeconds);
            return Date.from(instant);
        }
        return null;
    }

    public static List<String> getSpaceManagers(long spaceId) {
        try {
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            if (space == null || space.getManagers() == null) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(Arrays.asList(space.getManagers()));
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static String getSpaceDisplayName(long spaceId) {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceService.getSpaceById(spaceId);
        if (space != null) {
            return space.getDisplayName();
        }
        return null;
    }

    public static HubBillingPlan fromEntity(HubBillingPlanEntity entity) {
        if (entity == null) {
            return null;
        }
        HubBillingPlan plan = new HubBillingPlan();
        plan.setId(entity.getId());
        plan.setPlanId(entity.getPlanId());
        plan.setProductId(entity.getProductId());
        plan.setMaxUsers(entity.getMaxUsers());
        plan.setMeterId(entity.getMeterId());
        return plan;
    }

    public static HubBillingPlanEntity toEntity(HubBillingPlan plan) {
        if (plan == null) {
            return null;
        }
        HubBillingPlanEntity entity = new HubBillingPlanEntity();
        entity.setId(plan.getId());
        entity.setPlanId(plan.getPlanId());
        entity.setProductId(plan.getProductId());
        entity.setMaxUsers(plan.getMaxUsers());
        entity.setMeterId(plan.getMeterId());
        return entity;
    }

    public static Plan getPlanFromSubscription(Subscription subscription) {
        try {
            return ((SubscriptionItem)subscription.getItems().getData().getFirst()).getPlan();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get plan from subscription " + subscription.getId(), e);
        }
    }

    public static List<String> getAdministrators() {
        try {
            ListAccess membershipsListAccess;
            int membershipSize;
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            Group admins = organizationService.getGroupHandler().findGroupById("/platform/administrators");
            if (admins != null && (membershipSize = (membershipsListAccess = organizationService.getMembershipHandler().findAllMembershipsByGroup(admins)).getSize()) > 0) {
                Membership[] memberships = (Membership[])membershipsListAccess.load(0, membershipSize);
                return Arrays.stream(memberships).filter(Objects::nonNull).map(Membership::getUserName).distinct().toList();
            }
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public static String getTemplatePriceId(long templateId) {
        return PropertyManager.getProperty((String)("meeds.billing.spaceTemplate." + templateId + ".priceId"));
    }

    public static String getTemplateTrialDays(long templateId) {
        return PropertyManager.getProperty((String)("meeds.billing.spaceTemplate." + templateId + ".trialDays"));
    }

    public static enum SubscriptionStatus {
        INCOMPLETE,
        TRIALING,
        ACTIVE,
        CANCELED,
        PAST_DUE;

    }
}

