/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.plugin;

import java.util.Arrays;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;

public class ObjectsCloneTest
extends TestCase {
    public void testCloneUserSettting() {
        String channelId = "channel_test";
        String channelId1 = "channel_test1";
        String pluginId = "NewUserPlugin";
        UserSetting setting = UserSetting.getInstance();
        setting.setUserId("test");
        setting.setChannelActive(channelId);
        Arrays.stream(new String[]{"ActivityMentionPlugin", "PostActivityPlugin", "ActivityCommentPlugin", "SpaceInvitationPlugin", "RequestJoinSpacePlugin"}).forEach(id -> setting.addChannelPlugin(channelId, id));
        UserSetting clone = setting.clone();
        ObjectsCloneTest.assertEquals((String)setting.getUserId(), (String)clone.getUserId());
        clone.setUserId("test1");
        clone.setChannelActive(channelId1);
        clone.addChannelPlugin(channelId, pluginId);
        clone.addChannelPlugin(channelId1, pluginId);
        ObjectsCloneTest.assertFalse((boolean)setting.getUserId().equals(clone.getUserId()));
        ObjectsCloneTest.assertFalse((boolean)setting.getPlugins(channelId).contains(pluginId));
        ObjectsCloneTest.assertTrue((boolean)clone.getPlugins(channelId).contains(pluginId));
        ObjectsCloneTest.assertTrue((boolean)setting.getPlugins(channelId1).isEmpty());
        ObjectsCloneTest.assertTrue((boolean)clone.getPlugins(channelId1).contains(pluginId));
        ObjectsCloneTest.assertTrue((boolean)setting.getChannelActives().contains(channelId));
        ObjectsCloneTest.assertFalse((boolean)setting.getChannelActives().contains(channelId1));
        ObjectsCloneTest.assertTrue((boolean)clone.getChannelActives().contains(channelId));
        ObjectsCloneTest.assertTrue((boolean)clone.getChannelActives().contains(channelId1));
    }

    public void testNotificationInfoClone() {
        HashMap<String, String> ownerParameter = new HashMap<String, String>();
        ownerParameter.put("test", "value test");
        NotificationInfo info = NotificationInfo.instance();
        info.setFrom("demo").key("notifiId").setOrder(1).setOwnerParameter(ownerParameter).setSendToDaily(new String[]{"plugin1", "plugin2"}).setSendToWeekly(new String[]{"plugin2", "plugin3"}).setTo("root");
        NotificationInfo clone = info.clone();
        ObjectsCloneTest.assertEquals((String)info.getId(), (String)clone.getId());
        ObjectsCloneTest.assertEquals((String)info.getId(), (String)clone.getId());
        ObjectsCloneTest.assertEquals((String)info.getFrom(), (String)clone.getFrom());
        ObjectsCloneTest.assertEquals((String)info.getTo(), (String)clone.getTo());
        ObjectsCloneTest.assertTrue((boolean)Arrays.equals(info.getSendToDaily(), clone.getSendToDaily()));
        ObjectsCloneTest.assertTrue((boolean)Arrays.equals(info.getSendToWeekly(), clone.getSendToWeekly()));
        ObjectsCloneTest.assertTrue((boolean)CollectionUtils.isEqualCollection(info.getOwnerParameter().keySet(), clone.getOwnerParameter().keySet()));
        ObjectsCloneTest.assertTrue((boolean)CollectionUtils.isEqualCollection(info.getOwnerParameter().values(), clone.getOwnerParameter().values()));
        ObjectsCloneTest.assertEquals((String)info.getValueOwnerParameter("test"), (String)clone.getValueOwnerParameter("test"));
        clone.getSendToDaily()[0] = "plugin4";
        clone.getOwnerParameter().put("test", "value clone");
        ObjectsCloneTest.assertFalse((boolean)Arrays.equals(info.getSendToDaily(), clone.getSendToDaily()));
        ObjectsCloneTest.assertFalse((boolean)CollectionUtils.isEqualCollection(info.getOwnerParameter().values(), clone.getOwnerParameter().values()));
        ObjectsCloneTest.assertFalse((boolean)info.getValueOwnerParameter("test").equals(clone.getValueOwnerParameter("test")));
    }
}

