/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jpa.notifications.email.dao;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailDigestEntity;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailNotifEntity;
import org.exoplatform.jpa.CommonsDAOJPAImplTest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MailNotifDAOTest
extends CommonsDAOJPAImplTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mailParamsDAO.deleteAll();
        this.mailDigestDAO.deleteAll();
        this.mailNotifDAO.deleteAll();
    }

    @Override
    @After
    public void tearDown() {
        this.mailParamsDAO.deleteAll();
        this.mailDigestDAO.deleteAll();
        this.mailNotifDAO.deleteAll();
    }

    @Test
    public void testGetNotifsByPluginAndDay() {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(new Date(calendar2.getTime().getTime() - 100L));
        Calendar calendar3 = Calendar.getInstance();
        calendar3.set(5, calendar3.get(5) + 1);
        this.createNotification(calendar, "plugin1", "daily");
        this.createNotification(calendar2, "plugin1", "daily");
        this.createNotification(calendar2, "plugin2", "daily");
        this.createNotification(calendar3, "plugin1", "daily");
        List mailNotifEntities1 = this.mailNotifDAO.getNotifsByPluginAndDay("plugin1", String.valueOf(Calendar.getInstance().get(5)));
        List mailNotifEntities2 = this.mailNotifDAO.getNotifsByPluginAndDay("plugin2", String.valueOf(Calendar.getInstance().get(5)));
        Assert.assertThat((Object)mailNotifEntities1.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)mailNotifEntities2.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testGetNotifsByPluginAndWeek() {
        Calendar today = Calendar.getInstance();
        Calendar yesterday = Calendar.getInstance();
        yesterday.set(5, yesterday.get(5) - 1);
        Calendar fourDaysAgo = Calendar.getInstance();
        fourDaysAgo.set(5, fourDaysAgo.get(5) - 4);
        Calendar eightDaysAgo = Calendar.getInstance();
        eightDaysAgo.set(5, eightDaysAgo.get(5) - 8);
        this.createNotification(today, "plugin1", "weekly");
        this.createNotification(yesterday, "plugin1", "weekly");
        this.createNotification(fourDaysAgo, "plugin1", "weekly");
        this.createNotification(eightDaysAgo, "plugin1", "weekly");
        this.createNotification(fourDaysAgo, "plugin2", "weekly");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        List mailNotifEntities1 = this.mailNotifDAO.getNotifsByPluginAndWeek("plugin1", calendar);
        List mailNotifEntities2 = this.mailNotifDAO.getNotifsByPluginAndWeek("plugin2", calendar);
        Assert.assertThat((Object)mailNotifEntities1.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)mailNotifEntities2.size(), (Matcher)Is.is((Object)1));
    }

    private void createNotification(Calendar today, String pluginName1, String digestType) {
        MailNotifEntity notif = new MailNotifEntity().setCreationDate(today).setType(pluginName1);
        this.mailNotifDAO.create((Object)notif);
        MailDigestEntity digest = new MailDigestEntity().setType(digestType).setNotification(notif);
        this.mailDigestDAO.create((Object)digest);
    }
}

