/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.commons.component.core-local-configuration.xml")})
public abstract class BaseNotificationTestCase
extends BaseCommonsTestCase {
    protected static final String NOTIFICATIONS = "notifications";
    protected List<String> userIds = new ArrayList<String>();
    protected WebNotificationStorage storage;

    protected void beforeClass() {
        super.beforeClass();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
        this.storage = (WebNotificationStorage)this.getContainer().getComponentInstanceOfType(WebNotificationStorage.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.userIds = new ArrayList<String>();
    }

    protected NotificationInfo makeWebNotificationInfo(String userId) {
        NotificationInfo info = NotificationInfo.instance();
        info.key(new PluginKey("TestPlugin"));
        info.setTitle("The title");
        info.setFrom("mary");
        info.setTo(userId);
        info.setRead(false);
        info.setOnPopOver(true);
        info.with("activityId", "TheActivityId").with("accessLink", "http://fsdfsdf.com/fsdfsf");
        return info;
    }
}

