/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.thumbnail;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.thumbnail.ImageResizeService;
import org.imgscalr.Scalr;

public class ImageResizeServiceImpl
implements ImageResizeService {
    private static final Log LOG = ExoLogger.getLogger(ImageResizeServiceImpl.class);

    public byte[] scaleImage(byte[] image, int width, int height, boolean fitExact, boolean ultraQuality) throws Exception {
        if (width == 0 && height == 0) {
            return image;
        }
        Scalr.Method resizeMethod = ultraQuality ? Scalr.Method.ULTRA_QUALITY : Scalr.Method.QUALITY;
        BufferedImage bufferedImage = this.toBufferedImage(image);
        if (bufferedImage == null) {
            LOG.warn("Image could not be loaded using ImageIO API, original image will be returned instead of {}x{}", new Object[]{width, height});
            return image;
        }
        int originWidth = bufferedImage.getWidth();
        int originHeight = bufferedImage.getHeight();
        if (!(fitExact || width <= originWidth && height <= originHeight)) {
            return image;
        }
        if (width == 0) {
            bufferedImage = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)resizeMethod, (Scalr.Mode)Scalr.Mode.FIT_TO_HEIGHT, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        } else if (height == 0) {
            bufferedImage = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)resizeMethod, (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        } else if (fitExact) {
            bufferedImage = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)resizeMethod, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        } else {
            Scalr.Mode fitMode;
            float ratio = (float)originHeight / (float)originWidth;
            int calculatedTargetHeight = Math.round((float)width * ratio);
            Scalr.Mode mode = fitMode = width > height ? Scalr.Mode.FIT_TO_WIDTH : Scalr.Mode.FIT_TO_HEIGHT;
            if (calculatedTargetHeight < height) {
                fitMode = Scalr.Mode.FIT_TO_HEIGHT;
            }
            bufferedImage = Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)resizeMethod, (Scalr.Mode)fitMode, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        }
        try {
            ImageReader imageReader = this.getImageReader(image);
            byte[] response = this.toByteArray(bufferedImage, imageReader);
            if (response.length == 0) {
                response = this.toByteArray(bufferedImage);
                imageReader = this.getImageReader(response);
                response = this.toByteArray(bufferedImage, imageReader);
            }
            if (!(fitExact || response.length != 0 && response.length <= image.length)) {
                return image;
            }
            return response;
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to read image to resize, return original size", (Throwable)e);
            return image;
        }
    }

    private ImageReader getImageReader(byte[] bytes) throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
        Iterator<ImageReader> readers = ImageIO.getImageReaders(imageInputStream);
        ImageReader reader = readers.next();
        reader.setInput(imageInputStream);
        return reader;
    }

    private BufferedImage toBufferedImage(byte[] imageBytes) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);
            return ImageIO.read(bis);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to read image", (Throwable)e);
            return null;
        }
    }

    private byte[] toByteArray(BufferedImage targetBufferedImage, ImageReader sourceImageReader) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageWriter writer = ImageIO.getImageWriter(sourceImageReader);
        writer.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
        IIOMetadata metadata = sourceImageReader.getImageMetadata(0);
        ImageWriteParam param = writer.getDefaultWriteParam();
        if (param instanceof JPEGImageWriteParam) {
            ((JPEGImageWriteParam)param).setOptimizeHuffmanTables(true);
        }
        writer.write(null, new IIOImage(targetBufferedImage, null, metadata), param);
        writer.dispose();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] toByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

