/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.listener;

import java.util.Collections;
import org.exoplatform.listener.UserLogoutListener;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.user.UserStateWSMessage;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class UserLogoutListenerTest {
    @Mock
    private ContinuationService continuationService;
    @InjectMocks
    private UserLogoutListener listener;
    @Mock
    private Event<ConversationRegistry, ConversationState> event;
    @Mock
    private ConversationState conversationState;
    @Mock
    private Identity identity;
    @Mock
    private ConversationRegistry conversationRegistry;
    @Captor
    private ArgumentCaptor<UserStateWSMessage> wsMessageCaptor;

    @Test
    public void testBroadcastOfflineStatus() {
        String userId = "john";
        Mockito.when((Object)((ConversationState)this.event.getData())).thenReturn((Object)this.conversationState);
        Mockito.when((Object)((ConversationRegistry)this.event.getSource())).thenReturn((Object)this.conversationRegistry);
        Mockito.when((Object)this.conversationState.getIdentity()).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)userId);
        Mockito.when((Object)this.conversationRegistry.getStateKeys(userId)).thenReturn(Collections.emptyList());
        this.listener.onEvent(this.event);
        ((ContinuationService)Mockito.verify((Object)this.continuationService)).sendBroadcastMessage((String)Mockito.eq((Object)"/meeds/Application/UserState"), this.wsMessageCaptor.capture());
        UserStateWSMessage message = (UserStateWSMessage)this.wsMessageCaptor.getValue();
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"user-status-updated", (Object)message.getWsEventName());
        Assert.assertEquals((Object)userId, (Object)message.getUserId());
        Assert.assertEquals((Object)"offline", (Object)message.getStatus());
        Mockito.reset((Object[])new ContinuationService[]{this.continuationService});
        Mockito.when((Object)((ConversationState)this.event.getData())).thenReturn((Object)this.conversationState);
        Mockito.when((Object)this.conversationState.getIdentity()).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identity.getUserId()).thenReturn(null);
        this.listener.onEvent(this.event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.continuationService});
    }
}

