/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.listener;

import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateWSMessage;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;

@Asynchronous
public class UserLogoutListener
extends Listener<ConversationRegistry, ConversationState> {
    private final ContinuationService continuationService;

    public UserLogoutListener(ContinuationService continuationService) {
        this.continuationService = continuationService;
    }

    public void onEvent(Event<ConversationRegistry, ConversationState> event) {
        ConversationState state = (ConversationState)event.getData();
        ConversationRegistry conversationRegistry = (ConversationRegistry)event.getSource();
        String userId = this.getUserIdFromState(state);
        if (userId != null && conversationRegistry.getStateKeys(userId).isEmpty()) {
            UserStateWSMessage offlineState = new UserStateWSMessage(new UserStateModel(userId, 0L, "offline"), "user-status-updated");
            this.continuationService.sendBroadcastMessage("/meeds/Application/UserState", (Object)offlineState);
        }
    }

    private String getUserIdFromState(ConversationState state) {
        if (state == null || state.getIdentity() == null) {
            return null;
        }
        return state.getIdentity().getUserId();
    }
}

