/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jpa.settings.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.jpa.BaseTest;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.settings.jpa.JPAPluginSettingServiceImpl;
import org.exoplatform.settings.jpa.JPAUserSettingServiceImpl;

public class JPAUserSettingServiceTest
extends BaseTest {
    private static final String GROUP_PROVIDER_ID = "groupId";
    private static final String PLUGIN_ID = "pluginAllowedId";
    private static final String CHANNEL_ID = "channelId";
    private static final PluginConfig PLUGIN_CONFIG = new PluginConfig();
    JPAUserSettingServiceImpl userSettingService;
    JPAPluginSettingServiceImpl pluginSettingServiceImpl;
    ChannelManager channelManager;
    OrganizationService organizationService;
    Set<String> teardownUsers;
    List<String> dispatchedUsers;
    List<String> dispatchedPlugins;
    AbstractChannel specificChannel = new AbstractChannel(){

        public void registerTemplateProvider(TemplateProvider provider) {
        }

        protected AbstractTemplateBuilder getTemplateBuilderInChannel(PluginKey key) {
            return null;
        }

        public ChannelKey getKey() {
            return ChannelKey.key((String)JPAUserSettingServiceTest.CHANNEL_ID);
        }

        public String getId() {
            return JPAUserSettingServiceTest.CHANNEL_ID;
        }

        public void dispatch(NotificationContext ctx, String userId) {
            JPAUserSettingServiceTest.this.dispatchedUsers.add(userId);
            JPAUserSettingServiceTest.this.dispatchedPlugins.add(ctx.getNotificationInfo().getKey().getId());
        }

        public boolean isDefaultChannel() {
            return false;
        }
    };

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.userSettingService = this.getService(JPAUserSettingServiceImpl.class);
        this.pluginSettingServiceImpl = this.getService(JPAPluginSettingServiceImpl.class);
        this.channelManager = this.getService(ChannelManager.class);
        this.organizationService = this.getService(OrganizationService.class);
        this.pluginSettingServiceImpl.registerPluginConfig(PLUGIN_CONFIG);
        this.channelManager.register(this.specificChannel);
        this.dispatchedUsers = new ArrayList<String>();
        this.dispatchedPlugins = new ArrayList<String>();
        this.teardownUsers = new HashSet<String>();
    }

    @Override
    protected void tearDown() throws Exception {
        for (String username : this.teardownUsers) {
            this.organizationService.getUserHandler().removeUser(username, false);
        }
        this.channelManager.unregister(this.specificChannel);
        this.pluginSettingServiceImpl.unregisterPluginConfig(PLUGIN_CONFIG);
        super.tearDown();
    }

    public void test_1_GetDefautSetting() throws Exception {
        for (int i = 0; i < 10; ++i) {
            UserImpl user = new UserImpl("userTestSetting_" + i);
            this.organizationService.getUserHandler().createUser((User)user, true);
            String userName = user.getUserName();
            this.teardownUsers.add(userName);
            this.restartTransaction();
        }
        List list = this.userSettingService.getDigestDefaultSettingForAllUser(0, 5);
        JPAUserSettingServiceTest.assertEquals((int)5, (int)list.size());
        list = this.userSettingService.getDigestDefaultSettingForAllUser(0, 0);
        JPAUserSettingServiceTest.assertTrue((list.size() >= 10 ? 1 : 0) != 0);
        Set defaultDigestUsers = list.stream().map(UserSetting::getUserId).collect(Collectors.toSet());
        for (String username : this.teardownUsers) {
            JPAUserSettingServiceTest.assertTrue((boolean)defaultDigestUsers.contains(username));
        }
    }

    public void testChannelEnablement() throws Exception {
        String username = "testChannelEnablement";
        UserImpl user = new UserImpl(username);
        this.organizationService.getUserHandler().createUser((User)user, false);
        UserSetting userSetting = this.userSettingService.get(username);
        JPAUserSettingServiceTest.assertNotNull((Object)userSetting);
        Set channelActives = userSetting.getChannelActives();
        JPAUserSettingServiceTest.assertTrue((boolean)channelActives.contains(CHANNEL_ID));
        for (String channelId : channelActives) {
            JPAUserSettingServiceTest.assertTrue((boolean)userSetting.isActive(channelId, PLUGIN_ID));
            JPAUserSettingServiceTest.assertTrue((boolean)this.pluginSettingServiceImpl.isActive(channelId, PLUGIN_ID));
        }
        this.pluginSettingServiceImpl.saveChannelStatus(CHANNEL_ID, false);
        JPAUserSettingServiceTest.assertFalse((boolean)this.pluginSettingServiceImpl.isActive(CHANNEL_ID, PLUGIN_ID));
        JPAUserSettingServiceTest.assertFalse((boolean)this.pluginSettingServiceImpl.isChannelActive(CHANNEL_ID));
        userSetting = this.userSettingService.get(username);
        channelActives = userSetting.getChannelActives();
        JPAUserSettingServiceTest.assertFalse((boolean)channelActives.contains(CHANNEL_ID));
        this.pluginSettingServiceImpl.saveChannelStatus(CHANNEL_ID, true);
        JPAUserSettingServiceTest.assertTrue((boolean)this.pluginSettingServiceImpl.isActive(CHANNEL_ID, PLUGIN_ID));
        JPAUserSettingServiceTest.assertTrue((boolean)this.pluginSettingServiceImpl.isChannelActive(CHANNEL_ID));
        userSetting = this.userSettingService.get(username);
        channelActives = userSetting.getChannelActives();
        JPAUserSettingServiceTest.assertTrue((boolean)channelActives.contains(CHANNEL_ID));
    }

    public void testNotAllowedChannel() throws Exception {
        String username = "userAllowedTest";
        UserImpl user = new UserImpl(username);
        this.organizationService.getUserHandler().createUser((User)user, true);
        UserSetting userSetting = this.userSettingService.get(username);
        JPAUserSettingServiceTest.assertNotNull((Object)userSetting);
        Set channelActives = userSetting.getChannelActives();
        JPAUserSettingServiceTest.assertTrue((boolean)channelActives.contains(CHANNEL_ID));
        for (String channelId : channelActives) {
            JPAUserSettingServiceTest.assertTrue((boolean)userSetting.isActive(channelId, PLUGIN_ID));
            JPAUserSettingServiceTest.assertTrue((boolean)this.pluginSettingServiceImpl.isActive(channelId, PLUGIN_ID));
        }
        List allowedPlugins = (List)userSetting.getAllChannelPlugins().get(CHANNEL_ID);
        JPAUserSettingServiceTest.assertEquals(Collections.singletonList(PLUGIN_ID), (Object)allowedPlugins);
        JPAUserSettingServiceTest.assertTrue((boolean)this.pluginSettingServiceImpl.isActive(CHANNEL_ID, PLUGIN_ID));
        JPAUserSettingServiceTest.assertTrue((boolean)this.pluginSettingServiceImpl.isAllowed(CHANNEL_ID, PLUGIN_ID));
        for (String channelId : channelActives) {
            this.pluginSettingServiceImpl.saveActivePlugin(channelId, PLUGIN_ID, false);
            JPAUserSettingServiceTest.assertFalse((boolean)this.pluginSettingServiceImpl.isActive(channelId, PLUGIN_ID));
            userSetting = this.userSettingService.get(username);
            JPAUserSettingServiceTest.assertFalse((boolean)userSetting.isActive(channelId, PLUGIN_ID));
        }
        for (String channelId : channelActives) {
            this.pluginSettingServiceImpl.saveActivePlugin(channelId, PLUGIN_ID, true);
            JPAUserSettingServiceTest.assertTrue((boolean)this.pluginSettingServiceImpl.isActive(channelId, PLUGIN_ID));
            userSetting = this.userSettingService.get(username);
            JPAUserSettingServiceTest.assertTrue((boolean)userSetting.isActive(channelId, PLUGIN_ID));
        }
    }

    public void testDisabledUser() throws Exception {
        User u = ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().createUserInstance("binh");
        u.setEmail("email@test");
        u.setFirstName("first");
        u.setLastName("last");
        u.setPassword("pwdADDSomeSaltToBeCompliantWithSomeIS00");
        ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().createUser(u, true);
        String pluginId = "TestPlugin";
        this.userSettingService.save(this.createUserSetting("binh", Arrays.asList(pluginId), null, null));
        UserSetting userSetting = this.userSettingService.get("binh");
        JPAUserSettingServiceTest.assertTrue((boolean)userSetting.isEnabled());
        JPAUserSettingServiceTest.assertTrue((boolean)userSetting.isChannelActive("MAIL_CHANNEL", pluginId));
        ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().setEnabled("binh", false, true);
        userSetting = this.userSettingService.get("binh");
        JPAUserSettingServiceTest.assertFalse((boolean)userSetting.isEnabled());
        JPAUserSettingServiceTest.assertFalse((boolean)userSetting.isChannelActive("MAIL_CHANNEL", pluginId));
        ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().setEnabled("binh", true, true);
        userSetting = this.userSettingService.get("binh");
        JPAUserSettingServiceTest.assertTrue((boolean)userSetting.isEnabled());
        JPAUserSettingServiceTest.assertTrue((boolean)userSetting.isChannelActive("MAIL_CHANNEL", pluginId));
        ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().removeUser("binh", false);
        JPAUserSettingServiceTest.assertNull((Object)((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().findUserByName("binh"));
    }

    private UserSetting createUserSetting(String userId, List<String> instantly, List<String> daily, List<String> weekly) {
        UserSetting model = new UserSetting();
        model.setUserId(userId);
        model.setChannelActive("MAIL_CHANNEL");
        model.setDailyPlugins(daily);
        model.setChannelPlugins("MAIL_CHANNEL", instantly);
        model.setWeeklyPlugins(weekly);
        return model;
    }

    public void testChannelDefaultValue() throws Exception {
        String username = "testChannelDefaultValue";
        UserImpl user = new UserImpl(username);
        this.organizationService.getUserHandler().createUser((User)user, false);
        UserSetting userSetting = this.userSettingService.get(username);
        JPAUserSettingServiceTest.assertNotNull((Object)userSetting);
        this.pluginSettingServiceImpl.saveChannelDefaultValue(CHANNEL_ID, false);
        JPAUserSettingServiceTest.assertTrue((boolean)this.pluginSettingServiceImpl.isChannelActive(CHANNEL_ID));
        userSetting = this.userSettingService.get(username);
        Set channelActives = userSetting.getChannelActives();
        JPAUserSettingServiceTest.assertFalse((boolean)channelActives.contains(CHANNEL_ID));
    }

    static {
        PLUGIN_CONFIG.setPluginId(PLUGIN_ID);
        PLUGIN_CONFIG.setGroupId(GROUP_PROVIDER_ID);
        PLUGIN_CONFIG.setDefaultConfig(Collections.singletonList(UserSetting.FREQUENCY.INSTANTLY.name()));
        PLUGIN_CONFIG.addAdditionalChannel(CHANNEL_ID);
    }
}

