/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class CommonsUtilsMockingTest {
    private MockedStatic<CommonsUtils> COMMONS_UTILS;
    private MockedStatic<Util> UTIL;

    @Before
    public void beforeTest() {
        this.COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
        this.UTIL = Mockito.mockStatic(Util.class);
    }

    @After
    public void afterTest() {
        this.COMMONS_UTILS.close();
        this.UTIL.close();
    }

    @Test
    public void testShouldReturnDefaultPortalSite() {
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        Mockito.when((Object)userPortalConfigService.getMetaPortal()).thenReturn((Object)"intranet");
        this.COMMONS_UTILS.when(() -> CommonsUtils.getService(UserPortalConfigService.class)).thenReturn((Object)userPortalConfigService);
        this.COMMONS_UTILS.when(() -> CommonsUtils.getCurrentSite()).thenCallRealMethod();
        SiteKey site = CommonsUtils.getCurrentSite();
        Assert.assertEquals((Object)"intranet", (Object)site.getName());
        Assert.assertEquals((Object)SiteType.PORTAL, (Object)site.getType());
    }

    @Test
    public void testShouldReturnCurrentSite() {
        UserPortalConfigService userPortalConfig = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        Mockito.when((Object)userPortalConfig.getMetaPortal()).thenReturn((Object)"intranet");
        PortalRequestContext requestContext = (PortalRequestContext)Mockito.mock(PortalRequestContext.class);
        this.UTIL.when(() -> Util.getPortalRequestContext()).thenReturn((Object)requestContext);
        this.COMMONS_UTILS.when(() -> CommonsUtils.getService(UserPortalConfigService.class)).thenReturn((Object)userPortalConfig);
        this.COMMONS_UTILS.when(() -> CommonsUtils.getCurrentSite()).thenCallRealMethod();
        Mockito.when((Object)requestContext.getSiteKey()).thenReturn((Object)SiteKey.portal((String)"test_site"));
        SiteKey site = CommonsUtils.getCurrentSite();
        Assert.assertEquals((Object)"test_site", (Object)site.getName());
        Assert.assertEquals((Object)SiteType.PORTAL, (Object)site.getType());
        Mockito.when((Object)requestContext.getSiteKey()).thenReturn((Object)SiteKey.group((String)"group_site"));
        site = CommonsUtils.getCurrentSite();
        Assert.assertEquals((Object)"group_site", (Object)site.getName());
        Assert.assertEquals((Object)SiteType.GROUP, (Object)site.getType());
        Mockito.when((Object)requestContext.getSiteKey()).thenReturn((Object)SiteKey.user((String)"user_site"));
        site = CommonsUtils.getCurrentSite();
        Assert.assertEquals((Object)"user_site", (Object)site.getName());
        Assert.assertEquals((Object)SiteType.USER, (Object)site.getType());
    }

    public void testShouldReturnDefaultPortalOwner() {
        UserPortalConfigService userPortalConfig = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        Mockito.when((Object)userPortalConfig.getMetaPortal()).thenReturn((Object)"intranet");
        this.COMMONS_UTILS.when(() -> CommonsUtils.getService(UserPortalConfigService.class)).thenReturn((Object)userPortalConfig);
        this.COMMONS_UTILS.when(() -> CommonsUtils.getCurrentSite()).thenCallRealMethod();
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        Assert.assertEquals((Object)"intranet", (Object)portalOwner);
    }

    public void testShouldReturnCurrentPortalOwner() {
        UserPortalConfigService userPortalConfig = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        Mockito.when((Object)userPortalConfig.getMetaPortal()).thenReturn((Object)"intranet");
        PortalRequestContext requestContext = (PortalRequestContext)Mockito.mock(PortalRequestContext.class);
        this.UTIL.when(() -> Util.getPortalRequestContext()).thenReturn((Object)requestContext);
        this.COMMONS_UTILS.when(() -> CommonsUtils.getService(UserPortalConfigService.class)).thenReturn((Object)userPortalConfig);
        this.COMMONS_UTILS.when(() -> CommonsUtils.getCurrentSite()).thenCallRealMethod();
        Mockito.when((Object)requestContext.getPortalOwner()).thenReturn((Object)"current_portal_owner");
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        Assert.assertEquals((Object)"current_portal_owner", (Object)portalOwner);
    }
}

