/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.diff;

import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.commons.diff.DiffResult;
import org.exoplatform.commons.diff.DiffService;
import org.suigeneris.jrcs.diff.delta.Chunk;
import org.suigeneris.jrcs.diff.delta.Delta;

public class TestDiffService
extends TestCase {
    private DiffService diffService;

    protected void setUp() {
        this.diffService = new DiffService();
    }

    public void testSimpleLineDiff() throws Exception {
        String text1 = "A\nB\nC";
        String text2 = "A\nB B\nC";
        List diffs = this.diffService.getDifferencesAsList(text1, text2);
        TestDiffService.assertEquals((String)"There should be one difference", (int)1, (int)diffs.size());
        Delta delta = (Delta)diffs.get(0);
        Chunk orig = delta.getOriginal();
        Chunk revised = delta.getRevised();
        TestDiffService.assertEquals((String)"Original should be", (String)"B", (String)orig.toString());
        TestDiffService.assertEquals((String)"Revised should be", (String)"B B", (String)revised.toString());
    }

    public void testSimpleWordDiff() throws Exception {
        String text1 = "I love Paris and London";
        String text2 = "I live in Paris and London";
        List diffs = this.diffService.getWordDifferencesAsList(text1, text2);
        TestDiffService.assertEquals((String)"There should be two differences", (int)1, (int)diffs.size());
        Delta delta1 = (Delta)diffs.get(0);
        Chunk orig1 = delta1.getOriginal();
        Chunk revised1 = delta1.getRevised();
        TestDiffService.assertEquals((String)"Original 1 should be", (String)"love", (String)orig1.toString());
        TestDiffService.assertEquals((String)"Revised 1 should be", (String)"livein", (String)revised1.toString());
    }

    public void testSimpleWordDiffAsHTML() throws Exception {
        String text1 = "A B C D E F";
        String text2 = "A C B D E G";
        DiffResult result = this.diffService.getWordDifferencesAsHTML(text1, text2);
        String html = result.getDiffHTML();
        TestDiffService.assertEquals((String)"Diff is incorrect", (String)"<div class=\"diffmodifiedline\">A <span class=\"diffremoveword\">B</span> C <span class=\"diffaddword\">B</span> D E <span class=\"diffremoveword\">F</span><span class=\"diffaddword\">G</span></div>", (String)html);
        TestDiffService.assertEquals((String)"Diff is incorrect", (int)3, (int)result.getChanges());
    }

    public void testSimpleLineDiffAsHTML() throws Exception {
        String text1 = "A B C\nD E F\nG H I\nJ K L\n";
        String text2 = "A B C\nG H I\nD E F\nJ K L\n";
        DiffResult result = this.diffService.getDifferencesAsHTML(text1, text2, true);
        String html = result.getDiffHTML();
        TestDiffService.assertEquals((String)"Diff is incorrect", (String)"<div class=\"diff\"><div class=\"diffunmodifiedline\">A B C</div><div class=\"diffmodifiedline\"><span class=\"diffremoveword\">D E F</span></div><div class=\"diffunmodifiedline\">G H I</div><div class=\"diffmodifiedline\"><span class=\"diffaddword\">D E F</span></div><div class=\"diffunmodifiedline\">J K L</div></div>", (String)html);
        TestDiffService.assertEquals((String)"Diff is incorrect", (int)2, (int)result.getChanges());
    }
}

