/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.bench;

import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.services.bench.FakeDataInjector;

public class TestDataInjector
extends TestCase {
    FakeDataInjector dataInjector;
    HashMap<String, String> queryParams;

    protected void setUp() throws Exception {
        this.dataInjector = new FakeDataInjector();
        this.queryParams = new HashMap();
        this.queryParams.put("groups", "validator:/platform/administrators,manager:/platform/users");
        this.queryParams.put("users", "root,john,marry,james,demo");
        this.queryParams.put("memship", "manager,member,validator");
        super.setUp();
    }

    public void testRandomUser() {
        TestDataInjector.assertNotNull((Object)this.dataInjector.randomUser());
    }

    public void testRandomWords() {
        TestDataInjector.assertNotNull((Object)this.dataInjector.randomWords(10));
    }

    public void testRandomParagraph() {
        TestDataInjector.assertNotNull((Object)this.dataInjector.randomParagraphs(10));
    }

    public void testCreateTextResource() {
        TestDataInjector.assertTrue((this.dataInjector.createTextResource(10).getBytes().length == 10240 ? 1 : 0) != 0);
    }

    public void testReadGroupsIfExist() {
        List groups = this.dataInjector.readGroupsIfExist(this.queryParams);
        TestDataInjector.assertNotNull((Object)groups);
        TestDataInjector.assertEquals((int)2, (int)groups.size());
        TestDataInjector.assertEquals((String)"validator:/platform/administrators", (String)((String)groups.get(0)));
        TestDataInjector.assertEquals((String)"manager:/platform/users", (String)((String)groups.get(1)));
    }

    public void testReadUsersIfExist() {
        List users = this.dataInjector.readUsersIfExist(this.queryParams);
        TestDataInjector.assertNotNull((Object)users);
        TestDataInjector.assertEquals((int)5, (int)users.size());
        TestDataInjector.assertEquals((String)"root", (String)((String)users.get(0)));
        TestDataInjector.assertEquals((String)"john", (String)((String)users.get(1)));
        TestDataInjector.assertEquals((String)"marry", (String)((String)users.get(2)));
        TestDataInjector.assertEquals((String)"james", (String)((String)users.get(3)));
        TestDataInjector.assertEquals((String)"demo", (String)((String)users.get(4)));
    }

    public void testReadMembershipIfExist() {
        List memberships = this.dataInjector.readMembershipIfExist(this.queryParams);
        TestDataInjector.assertNotNull((Object)memberships);
        TestDataInjector.assertEquals((int)3, (int)memberships.size());
        TestDataInjector.assertEquals((String)"manager", (String)((String)memberships.get(0)));
        TestDataInjector.assertEquals((String)"member", (String)((String)memberships.get(1)));
        TestDataInjector.assertEquals((String)"validator", (String)((String)memberships.get(2)));
    }

    protected void tearDown() throws Exception {
        this.dataInjector = null;
        this.queryParams = null;
    }
}

