/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.version.util;

import java.util.Locale;
import junit.framework.TestCase;
import org.exoplatform.commons.version.util.ComparableVersion;

public class ComparableVersionTest
extends TestCase {
    private static final String[] VERSIONS_QUALIFIER = new String[]{"1-SNAPSHOT", "1-alpha2snapshot", "1-alpha2", "1-alpha-123", "1-beta-2", "1-beta123", "1-m2", "1-m11", "1-rc", "1-cr2", "1-rc123", "1", "1-sp", "1-sp2", "1-sp123", "1-abc", "1-def", "1-1-snapshot", "1-1", "1-2", "1-123"};
    private static final String[] VERSIONS_NUMBER = new String[]{"2.0.0", "2.0.0.a", "2.0.2", "2.0.123", "2.1.0", "2.1.0-a", "2.1.0b", "2.1.0-c", "2.1.0-1", "2.1.0.1", "2.2.0", "2.123", "11.a2", "11.a11", "11.b2", "11.b11", "11.m2", "11.m11", "11", "11.a", "11b", "11c", "11m"};

    private Comparable newComparable(String version) {
        return new ComparableVersion(version);
    }

    private void checkVersionsOrder(String[] versions) {
        int i;
        Comparable[] c = new Comparable[versions.length];
        for (i = 0; i < versions.length; ++i) {
            c[i] = this.newComparable(versions[i]);
        }
        for (i = 1; i < versions.length; ++i) {
            Comparable low = c[i - 1];
            for (int j = i; j < versions.length; ++j) {
                Comparable high = c[j];
                ComparableVersionTest.assertTrue((String)("expected " + String.valueOf(low) + " < " + String.valueOf(high)), (low.compareTo(high) < 0 ? 1 : 0) != 0);
                ComparableVersionTest.assertTrue((String)("expected " + String.valueOf(high) + " > " + String.valueOf(low)), (high.compareTo(low) > 0 ? 1 : 0) != 0);
            }
        }
    }

    private void checkVersionsEqual(String v1, String v2) {
        Comparable c1 = this.newComparable(v1);
        Comparable c2 = this.newComparable(v2);
        ComparableVersionTest.assertTrue((String)("expected " + v1 + " == " + v2), (c1.compareTo(c2) == 0 ? 1 : 0) != 0);
        ComparableVersionTest.assertTrue((String)("expected " + v2 + " == " + v1), (c2.compareTo(c1) == 0 ? 1 : 0) != 0);
        ComparableVersionTest.assertTrue((String)("expected same hashcode for " + v1 + " and " + v2), (c1.hashCode() == c2.hashCode() ? 1 : 0) != 0);
        ComparableVersionTest.assertTrue((String)("expected " + v1 + ".equals( " + v2 + " )"), (boolean)c1.equals(c2));
        ComparableVersionTest.assertTrue((String)("expected " + v2 + ".equals( " + v1 + " )"), (boolean)c2.equals(c1));
    }

    private void checkVersionsOrder(String v1, String v2) {
        Comparable c1 = this.newComparable(v1);
        Comparable c2 = this.newComparable(v2);
        ComparableVersionTest.assertTrue((String)("expected " + v1 + " < " + v2), (c1.compareTo(c2) < 0 ? 1 : 0) != 0);
        ComparableVersionTest.assertTrue((String)("expected " + v2 + " > " + v1), (c2.compareTo(c1) > 0 ? 1 : 0) != 0);
    }

    public void testVersionsQualifier() {
        this.checkVersionsOrder(VERSIONS_QUALIFIER);
    }

    public void testVersionsNumber() {
        this.checkVersionsOrder(VERSIONS_NUMBER);
    }

    public void testVersionsEqual() {
        this.checkVersionsEqual("1", "1");
        this.checkVersionsEqual("1a", "1.a");
        this.checkVersionsEqual("1a", "1-a");
        this.checkVersionsEqual("1.0a", "1.0.a");
        this.checkVersionsEqual("1.0.0a", "1.0.0.a");
        this.checkVersionsEqual("1ga", "1");
        this.checkVersionsEqual("1final", "1");
        this.checkVersionsEqual("1cr", "1rc");
        this.checkVersionsEqual("1a1", "1alpha1");
        this.checkVersionsEqual("1b2", "1beta2");
        this.checkVersionsEqual("1m3", "1milestone3");
        this.checkVersionsEqual("1.5.0-meed-20230818", "1.5.0-meed-20230818");
        this.checkVersionsEqual("6.5.0-exo-20230818", "6.5.0-exo-20230818");
    }

    public void testVersionComparing() {
        this.checkVersionsOrder("1", "2");
        this.checkVersionsOrder("1.5", "2");
        this.checkVersionsOrder("1", "2.5");
        this.checkVersionsOrder("1.0", "1.1");
        this.checkVersionsOrder("1.1", "1.2");
        this.checkVersionsOrder("1.0.0", "1.1");
        this.checkVersionsOrder("1.0.1", "1.1");
        this.checkVersionsOrder("1.1", "1.2.0");
        this.checkVersionsOrder("1.0-alpha-1", "1.0");
        this.checkVersionsOrder("1.0-alpha-1", "1.0-alpha-2");
        this.checkVersionsOrder("1.0-alpha-1", "1.0-beta-1");
        this.checkVersionsOrder("1.0-SNAPSHOT", "1.0-beta-1");
        this.checkVersionsOrder("1.0-SNAPSHOT", "1.0");
        this.checkVersionsOrder("1.0-alpha-1-SNAPSHOT", "1.0-alpha-1");
        this.checkVersionsOrder("1.0", "1.0-1");
        this.checkVersionsOrder("1.0-1", "1.0-2");
        this.checkVersionsOrder("1.0.0", "1.0.0-1");
        this.checkVersionsOrder("2.0-1", "2.0.1");
        this.checkVersionsOrder("2.0.1-klm", "2.0.1-lmn");
        this.checkVersionsOrder("2.0.1", "2.0.1-xyz");
        this.checkVersionsOrder("2.0.1", "2.0.1-123");
        this.checkVersionsOrder("2.0.1-xyz", "2.0.1-123");
        this.checkVersionsOrder("1.5.0-meed-20230818", "1.5.0");
        this.checkVersionsOrder("1.5.0-meed-20230817", "1.5.0-meed-20230818");
        this.checkVersionsOrder("6.5.0-exo-20230818", "6.5.0");
        this.checkVersionsOrder("6.5.0-exo-20230817", "6.5.0-exo-20230818");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocaleIndependent() {
        Locale orig = Locale.getDefault();
        Locale[] locales = new Locale[]{Locale.ENGLISH, new Locale("tr"), Locale.getDefault()};
        try {
            for (int i = 0; i < locales.length; ++i) {
                Locale.setDefault(locales[i]);
                this.checkVersionsEqual("1-abcdefghijklmnopqrstuvwxyz", "1-ABCDEFGHIJKLMNOPQRSTUVWXYZ");
            }
        }
        finally {
            Locale.setDefault(orig);
        }
    }

    public void testReuse() {
        ComparableVersion c1 = new ComparableVersion("1");
        c1.parseVersion("2");
        Comparable c2 = this.newComparable("2");
        ComparableVersionTest.assertEquals((String)"reused instance should be equivalent to new instance", (Object)c1, (Object)c2);
    }
}

