/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.index;

import org.exoplatform.commons.search.dao.IndexingOperationDAO;
import org.exoplatform.commons.search.domain.IndexingOperation;
import org.exoplatform.commons.search.domain.OperationType;
import org.exoplatform.commons.search.index.impl.QueueIndexingService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class QueueIndexingServiceTest {
    private QueueIndexingService queueIndexingService;
    @Mock
    private IndexingOperationDAO indexingOperationDAO;
    @Captor
    private ArgumentCaptor<String> stringCaptor;

    @Before
    public void initMocks() {
        MockitoAnnotations.initMocks((Object)this);
        this.queueIndexingService = new QueueIndexingService(this.indexingOperationDAO);
    }

    @After
    public void clean() {
        this.queueIndexingService.clearIndexingQueue();
    }

    @Test
    public void init_ifInitOperation_initIndexingQueueCreated() {
        IndexingOperation indexingOperation = new IndexingOperation(null, "post", OperationType.INIT);
        this.queueIndexingService.init("post");
        ((IndexingOperationDAO)Mockito.verify((Object)this.indexingOperationDAO, (VerificationMode)Mockito.times((int)1))).create((Object)indexingOperation);
    }

    @Test
    public void unindex_ifDeleteOperation_deleteIndexingQueueCreated() {
        IndexingOperation indexingOperation = new IndexingOperation("1", "post", OperationType.DELETE);
        this.queueIndexingService.unindex("post", "1");
        ((IndexingOperationDAO)Mockito.verify((Object)this.indexingOperationDAO, (VerificationMode)Mockito.times((int)1))).create((Object)indexingOperation);
    }

    @Test
    public void reindex_ifUpdateOperation_updateIndexingQueueCreated() {
        IndexingOperation indexingOperation = new IndexingOperation("1", "post", OperationType.UPDATE);
        this.queueIndexingService.reindex("post", "1");
        ((IndexingOperationDAO)Mockito.verify((Object)this.indexingOperationDAO, (VerificationMode)Mockito.times((int)1))).create((Object)indexingOperation);
    }

    @Test
    public void index_ifCreateOperation_createIndexingQueueCreated() {
        IndexingOperation indexingOperation = new IndexingOperation("1", "post", OperationType.CREATE);
        this.queueIndexingService.index("post", "1");
        ((IndexingOperationDAO)Mockito.verify((Object)this.indexingOperationDAO, (VerificationMode)Mockito.times((int)1))).create((Object)indexingOperation);
    }

    @Test(expected=IllegalArgumentException.class)
    public void index_ifEntityIdNull_IllegalArgumentException() {
        this.queueIndexingService.index("post", null);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=IllegalArgumentException.class)
    public void index_ifEntityIdBlank_IllegalArgumentException() {
        this.queueIndexingService.index("post", "");
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=IllegalArgumentException.class)
    public void reindex_ifEntityIdNull_IllegalArgumentException() {
        this.queueIndexingService.reindex("post", null);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=IllegalArgumentException.class)
    public void reindex_ifEntityIdBlank_IllegalArgumentException() {
        this.queueIndexingService.reindex("post", "");
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unindex_ifEntityIdNull_IllegalArgumentException() {
        this.queueIndexingService.unindex("post", null);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unindex_ifEntityIdBlank_IllegalArgumentException() {
        this.queueIndexingService.unindex("post", "");
        Assert.fail((String)"Exception expected");
    }
}

