/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es.client;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.exoplatform.commons.search.es.client.ElasticClient;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticResponse;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ElasticSearchingClient
extends ElasticClient {
    private static final Log LOG = ExoLogger.getLogger(ElasticSearchingClient.class);
    private static final String ES_SEARCH_CLIENT_PROPERTY_NAME = "exo.es.search.server.url";
    private static final String ES_SEARCH_CLIENT_PROPERTY_USERNAME = "exo.es.search.server.username";
    private static final String ES_SEARCH_CLIENT_PROPERTY_PASSWORD = "exo.es.search.server.password";
    private static final String ES_SEARCH_CLIENT_PROPERTY_MAX_CONNECTIONS = "exo.es.search.http.connections.max";
    private int maxPoolConnections;

    public ElasticSearchingClient(ElasticIndexingAuditTrail auditTrail) {
        super(auditTrail);
        if (StringUtils.isNotBlank((CharSequence)PropertyManager.getProperty((String)ES_SEARCH_CLIENT_PROPERTY_NAME))) {
            this.urlClient = PropertyManager.getProperty((String)ES_SEARCH_CLIENT_PROPERTY_NAME);
            LOG.info("Using {} as Searching URL", new Object[]{this.urlClient});
        } else {
            LOG.info((Object)"Using default as Searching URL");
        }
        this.initHttpClient();
    }

    public String countRequest(String esQuery, String index) {
        return this.sendRequest(esQuery, index, "/_count");
    }

    public String sendRequest(String esQuery, String index) {
        return this.sendRequest(esQuery, index, "/_search");
    }

    @Override
    protected String getEsUsernameProperty() {
        return PropertyManager.getProperty((String)ES_SEARCH_CLIENT_PROPERTY_USERNAME);
    }

    @Override
    protected String getEsPasswordProperty() {
        return PropertyManager.getProperty((String)ES_SEARCH_CLIENT_PROPERTY_PASSWORD);
    }

    @Override
    protected HttpClientConnectionManager getClientConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(this.getMaxConnections());
        return connectionManager;
    }

    @Override
    protected int getMaxConnections() {
        if (this.maxPoolConnections <= 0) {
            String maxConnectionsValue = PropertyManager.getProperty((String)ES_SEARCH_CLIENT_PROPERTY_MAX_CONNECTIONS);
            if (StringUtils.isNotBlank((CharSequence)maxConnectionsValue) && StringUtils.isNumeric((CharSequence)maxConnectionsValue.trim())) {
                this.maxPoolConnections = Integer.parseInt(maxConnectionsValue.trim());
            }
            if (this.maxPoolConnections <= 0) {
                LOG.info("Using default HTTP max connections for property {}={}.", new Object[]{ES_SEARCH_CLIENT_PROPERTY_MAX_CONNECTIONS, 100});
                this.maxPoolConnections = 100;
            }
        }
        return this.maxPoolConnections;
    }

    private String sendRequest(String esQuery, String index, String uri) {
        long startTime = System.currentTimeMillis();
        StringBuilder url = new StringBuilder();
        url.append(this.urlClient);
        if (StringUtils.isNotBlank((CharSequence)index)) {
            url.append("/" + index);
        }
        url.append(uri);
        ElasticResponse elasticResponse = this.sendHttpPostRequest(url.toString(), esQuery);
        String response = elasticResponse.getMessage();
        int statusCode = elasticResponse.getStatusCode();
        if (ElasticIndexingAuditTrail.isError(statusCode) || StringUtils.isBlank((CharSequence)response)) {
            if (StringUtils.isBlank((CharSequence)response)) {
                response = "Empty response was sent by ES";
            }
            this.auditTrail.logRejectedSearchOperation("search_type", index, statusCode, response, System.currentTimeMillis() - startTime);
        } else {
            Integer httpStatusCode;
            JSONParser parser = new JSONParser();
            Map json = null;
            try {
                json = (Map)parser.parse(response);
            }
            catch (ParseException e) {
                this.auditTrail.logRejectedSearchOperation("search_type", index, statusCode, "Error parsing response to JSON, content = " + response, System.currentTimeMillis() - startTime);
                throw new IllegalStateException("Error occured while requesting ES HTTP code: '" + statusCode + "', Error parsing response to JSON format, content = '" + response + "'", e);
            }
            Long status = json.get("status") == null ? null : (Long)json.get("status");
            String error = json.get("error") == null ? null : (String)((JSONObject)json.get("error")).get((Object)"reason");
            Integer n = httpStatusCode = status == null ? null : Integer.valueOf(status.intValue());
            if (ElasticIndexingAuditTrail.isError(httpStatusCode)) {
                this.auditTrail.logRejectedSearchOperation("search_type", index, httpStatusCode, error, System.currentTimeMillis() - startTime);
                throw new IllegalStateException("Error occured while requesting ES HTTP error code: '" + statusCode + "', HTTP response: '" + response + "'");
            }
            if (this.auditTrail.isFullLogEnabled()) {
                this.auditTrail.logAcceptedSearchOperation("search_type", index, statusCode, response, System.currentTimeMillis() - startTime);
            }
        }
        return response;
    }

    protected void resetMaxConnections() {
        this.maxPoolConnections = 0;
    }
}

