/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es.client;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TimeZone;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.es.client.ElasticContentRequestBuilder;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ElasticContentRequestBuilderTest {
    private ElasticContentRequestBuilder elasticContentRequestBuilder;
    @Mock
    private ElasticIndexingServiceConnector elasticIndexingServiceConnector;
    @Mock
    private Document document;
    @Captor
    private ArgumentCaptor<String> stringArgumentCaptor;

    @Before
    public void initMocks() throws java.text.ParseException {
        MockitoAnnotations.initMocks((Object)this);
        this.elasticContentRequestBuilder = new ElasticContentRequestBuilder();
        this.initElasticServiceConnectorMock();
    }

    @Test
    public void getCreateIndexRequestContent_ifSimpleConnector_shouldReturnIndexJSONSettings() throws ParseException {
        String request = this.elasticContentRequestBuilder.getCreateIndexRequestContent(this.elasticIndexingServiceConnector);
        JSONObject parsedRequest = (JSONObject)JSONValue.parseWithException((String)request);
        Assert.assertThat((Object)parsedRequest.get((Object)"number_of_replicas"), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)parsedRequest.get((Object)"number_of_shards"), (Matcher)Is.is((Object)3L));
        Assert.assertNotNull((Object)parsedRequest.get((Object)"analysis"));
        Assert.assertNotNull((Object)((JSONObject)parsedRequest.get((Object)"analysis")).get((Object)"analyzer"));
        Assert.assertNotNull((Object)((JSONObject)((JSONObject)parsedRequest.get((Object)"analysis")).get((Object)"analyzer")).get((Object)"default"));
    }

    @Test
    public void getDeleteDocumentRequestContent_ifSimpleConnectorAndEntityId_shouldReturnDeleteQuery() throws ParseException {
        String request = this.elasticContentRequestBuilder.getDeleteDocumentRequestContent(this.elasticIndexingServiceConnector, "1");
        JSONObject parsedRequest = (JSONObject)JSONValue.parseWithException((String)request);
        JSONObject delete = (JSONObject)parsedRequest.get((Object)"delete");
        Assert.assertThat((Object)((String)delete.get((Object)"_id")), (Matcher)Is.is((Object)"1"));
        Assert.assertThat((Object)((String)delete.get((Object)"_index")), (Matcher)Is.is((Object)"test"));
    }

    @Test
    public void getCreateDocumentRequestContent_ifSimpleConnectorAndEntityId_shouldReturnCreateQuery() throws java.text.ParseException, ParseException {
        this.initDocumentMock();
        String request = this.elasticContentRequestBuilder.getCreateDocumentRequestContent(this.elasticIndexingServiceConnector, "1");
        String[] lines = request.split("\n");
        JSONObject parsedRequestLine1 = (JSONObject)JSONValue.parseWithException((String)lines[0]);
        JSONObject create = (JSONObject)parsedRequestLine1.get((Object)"create");
        Assert.assertThat((Object)((String)create.get((Object)"_id")), (Matcher)Is.is((Object)"1"));
        Assert.assertThat((Object)((String)create.get((Object)"_index")), (Matcher)Is.is((Object)"test"));
        JSONObject parsedRequestLine2 = (JSONObject)JSONValue.parseWithException((String)lines[1]);
        Assert.assertThat((Object)((String)parsedRequestLine2.get((Object)"author")), (Matcher)Is.is((Object)"Michael Jordan"));
        Assert.assertThat((Object)((String)parsedRequestLine2.get((Object)"quote")), (Matcher)Is.is((Object)"I've missed more than 9000 shots in my career. I've lost almost 300 games. 26 times, I've been trusted to take the game winning shot and missed. I've failed over and over and over again in my life. And that is why I succeed."));
        JSONArray permissions = (JSONArray)parsedRequestLine2.get((Object)"permissions");
        Assert.assertTrue((boolean)permissions.contains((Object)"vizir"));
        Assert.assertTrue((boolean)permissions.contains((Object)"goleador"));
        Assert.assertThat((Object)((Long)parsedRequestLine2.get((Object)"lastUpdatedDate")), (Matcher)Is.is((Object)601171200000L));
        Assert.assertThat((Object)((String)parsedRequestLine2.get((Object)"url")), (Matcher)Is.is((Object)"MyUrlBaby"));
    }

    @Test
    public void getUpdateDocumentRequestContent_ifSimpleConnectorAndEntityId_shouldReturnUpdateQuery() throws java.text.ParseException, ParseException {
        this.initDocumentMock();
        String request = this.elasticContentRequestBuilder.getUpdateDocumentRequestContent(this.elasticIndexingServiceConnector, "1");
        String[] lines = request.split("\n");
        JSONObject parsedRequestLine1 = (JSONObject)JSONValue.parseWithException((String)lines[0]);
        JSONObject create = (JSONObject)parsedRequestLine1.get((Object)"index");
        Assert.assertThat((Object)((String)create.get((Object)"_id")), (Matcher)Is.is((Object)"1"));
        Assert.assertThat((Object)((String)create.get((Object)"_index")), (Matcher)Is.is((Object)"test"));
        JSONObject parsedRequestLine2 = (JSONObject)JSONValue.parseWithException((String)lines[1]);
        Assert.assertThat((Object)((String)parsedRequestLine2.get((Object)"author")), (Matcher)Is.is((Object)"Michael Jordan"));
        Assert.assertThat((Object)((String)parsedRequestLine2.get((Object)"quote")), (Matcher)Is.is((Object)"I've missed more than 9000 shots in my career. I've lost almost 300 games. 26 times, I've been trusted to take the game winning shot and missed. I've failed over and over and over again in my life. And that is why I succeed."));
        JSONArray permissions = (JSONArray)parsedRequestLine2.get((Object)"permissions");
        Assert.assertTrue((boolean)permissions.contains((Object)"vizir"));
        Assert.assertTrue((boolean)permissions.contains((Object)"goleador"));
        Assert.assertThat((Object)((Long)parsedRequestLine2.get((Object)"lastUpdatedDate")), (Matcher)Is.is((Object)601171200000L));
        Assert.assertThat((Object)((String)parsedRequestLine2.get((Object)"url")), (Matcher)Is.is((Object)"MyUrlBaby"));
    }

    private void initElasticServiceConnectorMock() {
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.getConnectorName()).thenReturn((Object)"test2");
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.getIndexAlias()).thenReturn((Object)"test");
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.getReplicas()).thenReturn((Object)2);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.getShards()).thenReturn((Object)3);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.create("1")).thenReturn((Object)this.document);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.update("1")).thenReturn((Object)this.document);
    }

    private void initDocumentMock() throws java.text.ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Mockito.when((Object)this.document.getLastUpdatedDate()).thenReturn((Object)sdf.parse("19/01/1989"));
        Mockito.lenient().when((Object)this.document.getId()).thenReturn((Object)"1");
        Mockito.lenient().when((Object)this.document.getUrl()).thenReturn((Object)"MyUrlBaby");
        Mockito.lenient().when((Object)this.document.getPermissions()).thenReturn(new HashSet<String>(Arrays.asList("vizir", "goleador")));
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("quote", "I've missed more than 9000 shots in my career. I've lost almost 300 games. 26 times, I've been trusted to take the game winning shot and missed. I've failed over and over and over again in my life. And that is why I succeed.");
        fields.put("author", "Michael Jordan");
        Mockito.when((Object)this.document.getFields()).thenReturn(fields);
        Mockito.when((Object)this.document.toJSON()).thenCallRealMethod();
        Mockito.when((Object)this.document.toJsonObject()).thenCallRealMethod();
    }
}

