/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.elasticsearch;

import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.RestClients;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;

@Configuration
@EnableElasticsearchRepositories(basePackages={"io.meeds.deeds.elasticsearch"})
public class ElasticSearchConfig {
    @Value(value="${meeds.elasticsearch.username:}")
    private String esUsername;
    @Value(value="${meeds.elasticsearch.password:}")
    private String esPassword;
    @Value(value="${meeds.elasticsearch.url:http://127.0.0.1:9200}")
    private String esUrl;

    @Bean
    public RestHighLevelClient client() {
        ClientConfiguration.ClientConfigurationBuilderWithRequiredEndpoint builder = ClientConfiguration.builder();
        String hostAndPort = this.esUrl.split("//")[1];
        ClientConfiguration.MaybeSecureClientConfigurationBuilder connectionBuilder = builder.connectedTo(hostAndPort);
        if (this.esUrl.contains("https://")) {
            connectionBuilder.usingSsl();
        }
        if (StringUtils.isNotBlank((CharSequence)this.esPassword) && StringUtils.isNotBlank((CharSequence)this.esUsername)) {
            connectionBuilder.withBasicAuth(this.esUsername, this.esPassword);
        }
        ClientConfiguration clientConfiguration = connectionBuilder.build();
        return RestClients.create((ClientConfiguration)clientConfiguration).rest();
    }

    @Bean
    public ElasticsearchOperations elasticsearchTemplate(RestHighLevelClient client) {
        return new ElasticsearchRestTemplate(client);
    }
}

