/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.listerner.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.deeds.listerner.model.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSerialization
extends StdDeserializer<Event> {
    public static final ObjectMapper OBJECT_MAPPER;
    private static final long serialVersionUID = -5369587672932623714L;
    private static final Logger LOG;

    public EventSerialization() {
        this(null);
    }

    public EventSerialization(Class<?> vc) {
        super(vc);
    }

    public Event deserialize(JsonParser p, DeserializationContext ctxt) {
        try {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            String eventName = node.get("eventName").asText();
            String dataClassName = node.get("dataClassName").asText();
            String dataJson = node.get("data").toString();
            Object data = OBJECT_MAPPER.readValue(dataJson, Class.forName(dataClassName));
            return new Event(eventName, data, dataClassName);
        }
        catch (Exception e) {
            LOG.debug("Error reading value of event", (Throwable)e);
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(EventSerialization.class);
        OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

