/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.service;

import io.meeds.deeds.listerner.model.EmailSendingCommand;
import io.meeds.deeds.service.ListenerService;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AuthorizationCodeService {
    private SecureRandom secureRandomCodeGenerator;
    @Value(value="${meeds.authorizationCode.maxCodeValidityInMinutes:120}")
    private int maxCodeValidityInMinutes;
    @Value(value="${meeds.authorizationCode.maxCodeSending:3}")
    private int maxCodeSending;
    @Value(value="${meeds.authorizationCode.maxCodeVerification:20}")
    private int maxCodeVerification;
    private Duration maxCodeValidity;
    private Map<String, AuthorizationCode> authorizationCodes = new ConcurrentHashMap<String, AuthorizationCode>();
    @Autowired
    private ListenerService listenerService;

    public AuthorizationCodeService() throws NoSuchAlgorithmException {
        try {
            this.secureRandomCodeGenerator = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            this.secureRandomCodeGenerator = SecureRandom.getInstanceStrong();
        }
    }

    @PostConstruct
    public void init() {
        this.maxCodeValidity = Duration.ofMinutes(this.maxCodeValidityInMinutes);
    }

    public void generateCode(String key, String email, Object data) throws IllegalAccessException {
        if (!this.hasValidDateCode(key)) {
            this.authorizationCodes.put(key, this.newAuthorizationCode());
        }
        AuthorizationCode authorizationCode = this.authorizationCodes.get(key);
        authorizationCode.incrementSendingCount();
        authorizationCode.setData(data);
        this.sendEmailWithCode(email, authorizationCode);
    }

    public void checkValidity(String key, int code) throws IllegalAccessException {
        if (!this.isValidCode(key, code, false)) {
            throw new IllegalAccessException("Code " + code + " isn't valid for key " + key);
        }
    }

    public Object validateAndGetData(String key, int code) throws IllegalAccessException {
        if (this.isValidCode(key, code, true)) {
            AuthorizationCode authorizationCode = this.authorizationCodes.remove(key);
            return authorizationCode.getData();
        }
        throw new IllegalAccessException("No Code found for designated key " + key);
    }

    private boolean isValidCode(String key, int code, boolean ignoreMaxTentativesTopBorder) throws IllegalAccessException {
        return StringUtils.isNotBlank((CharSequence)key) && this.authorizationCodes.containsKey(key) && this.authorizationCodes.get(key).isValid(code, ignoreMaxTentativesTopBorder);
    }

    private boolean hasValidDateCode(String key) {
        return StringUtils.isNotBlank((CharSequence)key) && this.authorizationCodes.containsKey(key) && this.authorizationCodes.get(key).isDateValid();
    }

    private void sendEmailWithCode(String email, AuthorizationCode authorizationCode) {
        EmailSendingCommand emailCommand = new EmailSendingCommand(email, "EMAIL_CONFIRMATION_CODE", Collections.singletonMap("emailCode", String.format("%06d", authorizationCode.getCode())));
        this.listenerService.publishEvent("deed.event.sendEmailTemplateCommand", emailCommand);
    }

    private synchronized AuthorizationCode newAuthorizationCode() {
        return new AuthorizationCode();
    }

    public int getMaxCodeValidityInMinutes() {
        return this.maxCodeValidityInMinutes;
    }

    public int getMaxCodeSending() {
        return this.maxCodeSending;
    }

    public int getMaxCodeVerification() {
        return this.maxCodeVerification;
    }

    public class AuthorizationCode {
        private final Instant generationTime = Instant.now();
        private final Instant maxValidTime;
        private final int code;
        private int sentTentatives;
        private int verificationTentatives;
        private Object data;

        public AuthorizationCode() {
            this.maxValidTime = this.generationTime.plus(AuthorizationCodeService.this.maxCodeValidity);
            this.code = AuthorizationCodeService.this.secureRandomCodeGenerator.nextInt(1000000);
        }

        public boolean isValid(int codeToVerify, boolean ignoreMaxTentativesTopBorder) throws IllegalAccessException {
            this.incrementVerificationCount(ignoreMaxTentativesTopBorder);
            return this.isDateValid() && codeToVerify == this.code;
        }

        private void incrementSendingCount() throws IllegalAccessException {
            this.checkVerificationCount();
            if (this.sentTentatives++ >= AuthorizationCodeService.this.maxCodeSending) {
                throw new IllegalAccessException("Max sending tentatives of code sending reached");
            }
        }

        private void checkVerificationCount() throws IllegalAccessException {
            if (this.verificationTentatives >= AuthorizationCodeService.this.maxCodeVerification) {
                throw new IllegalAccessException("Max verification tentatives of code sending reached");
            }
        }

        private void incrementVerificationCount(boolean ignoreMaxTentativesTopBorder) throws IllegalAccessException {
            if (!(this.verificationTentatives++ < AuthorizationCodeService.this.maxCodeVerification || ignoreMaxTentativesTopBorder && this.verificationTentatives <= AuthorizationCodeService.this.maxCodeVerification + 1)) {
                throw new IllegalAccessException("Max verification tentatives of code sending reached");
            }
        }

        private boolean isDateValid() {
            return Instant.now().isBefore(this.maxValidTime);
        }

        private int getCode() {
            return this.code;
        }

        private Object getData() {
            return this.data;
        }

        private void setData(Object data) {
            this.data = data;
        }
    }
}

