/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.listerner.model.EmailSendingCommand;
import io.meeds.deeds.common.service.AuthorizationCodeService;
import io.meeds.deeds.common.service.ListenerService;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest(classes={AuthorizationCodeService.class})
@TestPropertySource(properties={"meeds.authorizationCode.maxCodeValidityInMinutes=1", "meeds.authorizationCode.maxCodeSending=2", "meeds.authorizationCode.maxCodeVerification=3", "meeds.generationCode.limit=16"})
class AuthorizationCodeServiceTest {
    private static final String EMAIL = "email";
    private static final String DATA = "data";
    private static final String CLIENTIP = "clientIp";
    private static SecureRandom secureRandomCodeGenerator;
    private String key;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private AuthorizationCodeService authorizationCodeService;

    AuthorizationCodeServiceTest() {
    }

    @BeforeEach
    void setup() throws NoSuchAlgorithmException {
        this.key = String.valueOf(secureRandomCodeGenerator.nextInt(1000000));
    }

    @Test
    void testParameters() throws IllegalAccessException {
        Assertions.assertEquals((int)1, (int)this.authorizationCodeService.getMaxCodeValidityInMinutes());
        Assertions.assertEquals((int)2, (int)this.authorizationCodeService.getMaxCodeSending());
        Assertions.assertEquals((int)3, (int)this.authorizationCodeService.getMaxCodeVerification());
    }

    @Test
    void testGenerateNewCode() throws IllegalAccessException {
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        this.verifyEmailSending();
    }

    @Test
    void testGenerateCodeExceptionally() throws IllegalAccessException {
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP));
    }

    @Test
    void testCheckValidity() throws IllegalAccessException {
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        int generatedCode = this.getGeneratedCode();
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.authorizationCodeService.checkValidity(this.key, generatedCode + 1));
    }

    @Test
    void testCheckValidityExceptionally() throws IllegalAccessException {
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        int generatedCode = this.getGeneratedCode();
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.authorizationCodeService.checkValidity(this.key, generatedCode));
    }

    @Test
    void testValidateAndGetData() throws IllegalAccessException {
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        int generatedCode = this.getGeneratedCode();
        Object data = this.authorizationCodeService.validateAndGetData(this.key, generatedCode);
        Assertions.assertEquals((Object)DATA, (Object)data);
    }

    @Test
    void testValidateAndGetDataWhenVerificationChecksReachedMax() throws IllegalAccessException {
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        int generatedCode = this.getGeneratedCode();
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        Object data = this.authorizationCodeService.validateAndGetData(this.key, generatedCode);
        Assertions.assertEquals((Object)DATA, (Object)data);
    }

    @Test
    void testValidateAndGetDataWhenVerificationChecksReachedMaxPlusOne() throws IllegalAccessException {
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        int generatedCode = this.getGeneratedCode();
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.authorizationCodeService.checkValidity(this.key, generatedCode));
        Assertions.assertThrows(IllegalAccessException.class, () -> this.authorizationCodeService.validateAndGetData(this.key, generatedCode));
    }

    @Test
    void testValidateAndGetDataWhenVerificationCodeNotValid() throws IllegalAccessException {
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        int generatedCode = this.getGeneratedCode();
        Assertions.assertThrows(IllegalAccessException.class, () -> this.authorizationCodeService.validateAndGetData(this.key, generatedCode + 1));
    }

    @Test
    void testReinitializeCodeVerificationProcessAfterValidCheck() throws IllegalAccessException {
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        int generatedCode = this.getGeneratedCode();
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        Object data = this.authorizationCodeService.validateAndGetData(this.key, generatedCode);
        Assertions.assertEquals((Object)DATA, (Object)data);
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        int newlyGeneratedCode = this.getGeneratedCode(2);
        this.authorizationCodeService.checkValidity(this.key, newlyGeneratedCode);
        this.authorizationCodeService.checkValidity(this.key, newlyGeneratedCode);
        this.authorizationCodeService.checkValidity(this.key, newlyGeneratedCode);
        Assertions.assertNotEquals((int)generatedCode, (int)newlyGeneratedCode);
    }

    @Test
    void testCantGenerateCodeWhenMaxCheckReached() throws IllegalAccessException {
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        int generatedCode = this.getGeneratedCode();
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP));
    }

    @Test
    void testCanGenerateCodeWhenNotMaxCheckReached() throws IllegalAccessException {
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        int generatedCode = this.getGeneratedCode();
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        this.authorizationCodeService.checkValidity(this.key, generatedCode);
        this.authorizationCodeService.generateCode(this.key, EMAIL, (Object)DATA, CLIENTIP);
        int newlyGeneratedCode = this.getGeneratedCode(2);
        Assertions.assertEquals((int)generatedCode, (int)newlyGeneratedCode);
    }

    private int getGeneratedCode() {
        return this.getGeneratedCode(1);
    }

    private int getGeneratedCode(int times) {
        final AtomicInteger code = new AtomicInteger();
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)times))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.sendEmailTemplateCommand"), ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Object>(){

            public boolean matches(Object argument) {
                Assertions.assertNotNull((Object)argument);
                Assertions.assertEquals(EmailSendingCommand.class, argument.getClass());
                EmailSendingCommand emailSendingCommand = (EmailSendingCommand)argument;
                Assertions.assertEquals((Object)AuthorizationCodeServiceTest.EMAIL, (Object)emailSendingCommand.getEmail());
                Assertions.assertEquals((Object)"EMAIL_CONFIRMATION_CODE", (Object)emailSendingCommand.getTemplate());
                Assertions.assertNotNull((Object)emailSendingCommand.getParameters());
                Assertions.assertEquals((int)1, (int)emailSendingCommand.getParameters().size());
                code.set(Integer.parseInt((String)emailSendingCommand.getParameters().get("emailCode")));
                return true;
            }
        }));
        return code.get();
    }

    private void verifyEmailSending() {
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.sendEmailTemplateCommand"), ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Object>(){

            public boolean matches(Object argument) {
                Assertions.assertNotNull((Object)argument);
                Assertions.assertEquals(EmailSendingCommand.class, argument.getClass());
                EmailSendingCommand emailSendingCommand = (EmailSendingCommand)argument;
                Assertions.assertEquals((Object)AuthorizationCodeServiceTest.EMAIL, (Object)emailSendingCommand.getEmail());
                Assertions.assertEquals((Object)"EMAIL_CONFIRMATION_CODE", (Object)emailSendingCommand.getTemplate());
                Assertions.assertNotNull((Object)emailSendingCommand.getParameters());
                Assertions.assertEquals((int)1, (int)emailSendingCommand.getParameters().size());
                Assertions.assertTrue((boolean)emailSendingCommand.getParameters().containsKey("emailCode"));
                return true;
            }
        }));
    }

    static {
        try {
            secureRandomCodeGenerator = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                secureRandomCodeGenerator = SecureRandom.getInstanceStrong();
            }
            catch (NoSuchAlgorithmException e1) {
                throw new IllegalStateException("Error retrieving a SecureRandom Strong Instance", e1);
            }
        }
    }
}

