/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.constant.BlockchainOfferStatus;
import io.meeds.deeds.common.constant.DeedCard;
import io.meeds.deeds.common.constant.DeedCity;
import io.meeds.deeds.common.constant.ExpirationDuration;
import io.meeds.deeds.common.constant.NoticePeriod;
import io.meeds.deeds.common.constant.OfferType;
import io.meeds.deeds.common.constant.RentalDuration;
import io.meeds.deeds.common.constant.RentalPaymentPeriodicity;
import io.meeds.deeds.common.constant.TenantProvisioningStatus;
import io.meeds.deeds.common.constant.TransactionStatus;
import io.meeds.deeds.common.constant.UnauthorizedOperationException;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.elasticsearch.model.DeedTenantOffer;
import io.meeds.deeds.common.elasticsearch.storage.OfferRepository;
import io.meeds.deeds.common.model.DeedOfferBlockchainState;
import io.meeds.deeds.common.model.DeedTenantOfferDTO;
import io.meeds.deeds.common.model.OfferFilter;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.deeds.common.service.OfferService;
import io.meeds.deeds.common.service.TenantService;
import io.meeds.deeds.common.utils.DeedTenantOfferMapper;
import io.meeds.wom.api.constant.ObjectAlreadyExistsException;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import java.math.BigInteger;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.Query;

@SpringBootTest(classes={OfferService.class})
class OfferServiceTest {
    private static final String ADDRESS = "address";
    private static final String EMAIL = "email";
    @MockBean
    private OfferRepository offerRepository;
    @MockBean
    private ElasticsearchOperations elasticsearchOperations;
    @MockBean
    private BlockchainService blockchainService;
    @MockBean
    private TenantService tenantService;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private OfferService offerService;

    OfferServiceTest() {
    }

    @Test
    void testGetOffersListByNftId() {
        long nftId = 2L;
        String offerId = "offerId";
        DeedTenantOffer offer = this.newOffer(offerId, nftId);
        Pageable pageable = (Pageable)Mockito.mock(Pageable.class);
        SearchHit searchHit = (SearchHit)Mockito.mock(SearchHit.class);
        Mockito.when((Object)((DeedTenantOffer)searchHit.getContent())).thenReturn((Object)offer);
        SearchHits searchHits = (SearchHits)Mockito.mock(SearchHits.class);
        Mockito.when((Object)searchHits.getSearchHits()).thenReturn(Collections.singletonList(searchHit));
        Mockito.when((Object)searchHits.getTotalHits()).thenReturn((Object)1L);
        this.assertElasticSearchQuery((SearchHits<DeedTenantOffer>)searchHits, "nftId");
        OfferFilter offerFilter = new OfferFilter();
        offerFilter.setNftId(nftId);
        Page result = this.offerService.getOffers(offerFilter, pageable);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.getSize());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)result.getTotalElements());
        org.junit.jupiter.api.Assertions.assertEquals((Object)DeedTenantOfferMapper.toDTO((DeedTenantOffer)offer), result.get().findFirst().orElse(null));
    }

    @Test
    void testGetOffersListWithInvalidNetworkId() {
        long nftId = 2L;
        String offerId = "offerId";
        DeedTenantOffer offer = this.newOffer(offerId, nftId);
        Pageable pageable = (Pageable)Mockito.mock(Pageable.class);
        SearchHit searchHit = (SearchHit)Mockito.mock(SearchHit.class);
        Mockito.when((Object)((DeedTenantOffer)searchHit.getContent())).thenReturn((Object)offer);
        SearchHits searchHits = (SearchHits)Mockito.mock(SearchHits.class);
        Mockito.when((Object)searchHits.getSearchHits()).thenReturn(Collections.singletonList(searchHit));
        Mockito.when((Object)searchHits.getTotalHits()).thenReturn((Object)1L);
        Mockito.when((Object)this.tenantService.isBlockchainNetworkValid(2L)).thenReturn((Object)true);
        this.assertElasticSearchQuery((SearchHits<DeedTenantOffer>)searchHits, "nftId");
        OfferFilter offerFilter = new OfferFilter();
        offerFilter.setNftId(nftId);
        Page result = this.offerService.getOffers(offerFilter, pageable);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.getSize());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)result.getTotalElements());
        org.junit.jupiter.api.Assertions.assertEquals((Object)DeedTenantOfferMapper.toDTO((DeedTenantOffer)offer), result.get().findFirst().orElse(null));
    }

    @Test
    void testGetOffersListByOwned() {
        long nftId = 2L;
        String offerId = "offerId";
        String ownerAddress = "ownerAddress";
        DeedTenantOffer offer = this.newOffer(offerId, nftId);
        Pageable pageable = (Pageable)Mockito.mock(Pageable.class);
        SearchHit searchHit = (SearchHit)Mockito.mock(SearchHit.class);
        Mockito.when((Object)((DeedTenantOffer)searchHit.getContent())).thenReturn((Object)offer);
        SearchHits searchHits = (SearchHits)Mockito.mock(SearchHits.class);
        Mockito.when((Object)searchHits.getSearchHits()).thenReturn(Collections.singletonList(searchHit));
        Mockito.when((Object)searchHits.getTotalHits()).thenReturn((Object)1L);
        this.assertElasticSearchQuery((SearchHits<DeedTenantOffer>)searchHits, "owner");
        OfferFilter offerFilter = new OfferFilter();
        offerFilter.setOwnerAddress(ownerAddress);
        Page result = this.offerService.getOffers(offerFilter, pageable);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.getSize());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)result.getTotalElements());
        org.junit.jupiter.api.Assertions.assertEquals((Object)DeedTenantOfferMapper.toDTO((DeedTenantOffer)offer), result.get().findFirst().orElse(null));
    }

    @Test
    void testGetOffersListByCardTypes() {
        long nftId = 2L;
        String offerId = "offerId";
        List<DeedCard> cardTypes = Arrays.asList(DeedCard.COMMON, DeedCard.RARE);
        DeedTenantOffer offer = this.newOffer(offerId, nftId);
        Pageable pageable = (Pageable)Mockito.mock(Pageable.class);
        SearchHit searchHit = (SearchHit)Mockito.mock(SearchHit.class);
        Mockito.when((Object)((DeedTenantOffer)searchHit.getContent())).thenReturn((Object)offer);
        SearchHits searchHits = (SearchHits)Mockito.mock(SearchHits.class);
        Mockito.when((Object)searchHits.getSearchHits()).thenReturn(Collections.singletonList(searchHit));
        Mockito.when((Object)searchHits.getTotalHits()).thenReturn((Object)1L);
        this.assertElasticSearchQuery((SearchHits<DeedTenantOffer>)searchHits, "cardType");
        OfferFilter offerFilter = new OfferFilter();
        offerFilter.setCardTypes(cardTypes);
        Page result = this.offerService.getOffers(offerFilter, pageable);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.getSize());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)result.getTotalElements());
        org.junit.jupiter.api.Assertions.assertEquals((Object)DeedTenantOfferMapper.toDTO((DeedTenantOffer)offer), result.get().findFirst().orElse(null));
    }

    @Test
    void testGetOffersListWithCurrentAddress() {
        long nftId = 2L;
        String offerId = "offerId";
        DeedTenantOffer offer = this.newOffer(offerId, nftId);
        Pageable pageable = (Pageable)Mockito.mock(Pageable.class);
        SearchHit searchHit = (SearchHit)Mockito.mock(SearchHit.class);
        Mockito.when((Object)((DeedTenantOffer)searchHit.getContent())).thenReturn((Object)offer);
        SearchHits searchHits = (SearchHits)Mockito.mock(SearchHits.class);
        Mockito.when((Object)searchHits.getSearchHits()).thenReturn(Collections.singletonList(searchHit));
        Mockito.when((Object)searchHits.getTotalHits()).thenReturn((Object)1L);
        String currentAddress = ADDRESS;
        this.assertElasticSearchQuery((SearchHits<DeedTenantOffer>)searchHits, "viewAddresses");
        OfferFilter offerFilter = new OfferFilter();
        offerFilter.setCurrentAddress(currentAddress);
        Page result = this.offerService.getOffers(offerFilter, pageable);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.getSize());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)result.getTotalElements());
        org.junit.jupiter.api.Assertions.assertEquals((Object)DeedTenantOfferMapper.toDTO((DeedTenantOffer)offer), result.get().findFirst().orElse(null));
    }

    @Test
    void testGetOffersListByOfferTypes() {
        long nftId = 2L;
        String offerId = "offerId";
        List<OfferType> offerTypes = Arrays.asList(OfferType.RENTING, OfferType.SALE);
        DeedTenantOffer offer = this.newOffer(offerId, nftId);
        Pageable pageable = (Pageable)Mockito.mock(Pageable.class);
        SearchHit searchHit = (SearchHit)Mockito.mock(SearchHit.class);
        Mockito.when((Object)((DeedTenantOffer)searchHit.getContent())).thenReturn((Object)offer);
        SearchHits searchHits = (SearchHits)Mockito.mock(SearchHits.class);
        Mockito.when((Object)searchHits.getSearchHits()).thenReturn(Collections.singletonList(searchHit));
        Mockito.when((Object)searchHits.getTotalHits()).thenReturn((Object)1L);
        this.assertElasticSearchQuery((SearchHits<DeedTenantOffer>)searchHits, "offerType");
        OfferFilter offerFilter = new OfferFilter();
        offerFilter.setOfferTypes(offerTypes);
        Page result = this.offerService.getOffers(offerFilter, pageable);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.getSize());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)result.getTotalElements());
        org.junit.jupiter.api.Assertions.assertEquals((Object)DeedTenantOfferMapper.toDTO((DeedTenantOffer)offer), result.get().findFirst().orElse(null));
    }

    @Test
    void testGetOffersListByEnabled() {
        long nftId = 2L;
        String offerId = "offerId";
        DeedTenantOffer offer = this.newOffer(offerId, nftId);
        Pageable pageable = (Pageable)Mockito.mock(Pageable.class);
        SearchHit searchHit = (SearchHit)Mockito.mock(SearchHit.class);
        Mockito.when((Object)((DeedTenantOffer)searchHit.getContent())).thenReturn((Object)offer);
        SearchHits searchHits = (SearchHits)Mockito.mock(SearchHits.class);
        Mockito.when((Object)searchHits.getSearchHits()).thenReturn(Collections.singletonList(searchHit));
        Mockito.when((Object)searchHits.getTotalHits()).thenReturn((Object)1L);
        this.assertElasticSearchQuery((SearchHits<DeedTenantOffer>)searchHits, "enabled");
        OfferFilter offerFilter = new OfferFilter();
        offerFilter.setExcludeDisabled(true);
        Page result = this.offerService.getOffers(offerFilter, pageable);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.getSize());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)result.getTotalElements());
        org.junit.jupiter.api.Assertions.assertEquals((Object)DeedTenantOfferMapper.toDTO((DeedTenantOffer)offer), result.get().findFirst().orElse(null));
    }

    @Test
    void testGetOffersListByDateExpiration() {
        long nftId = 2L;
        String offerId = "offerId";
        DeedTenantOffer offer = this.newOffer(offerId, nftId);
        Pageable pageable = (Pageable)Mockito.mock(Pageable.class);
        SearchHit searchHit = (SearchHit)Mockito.mock(SearchHit.class);
        Mockito.when((Object)((DeedTenantOffer)searchHit.getContent())).thenReturn((Object)offer);
        SearchHits searchHits = (SearchHits)Mockito.mock(SearchHits.class);
        Mockito.when((Object)searchHits.getSearchHits()).thenReturn(Collections.singletonList(searchHit));
        Mockito.when((Object)searchHits.getTotalHits()).thenReturn((Object)1L);
        this.assertElasticSearchQuery((SearchHits<DeedTenantOffer>)searchHits, "expirationDate");
        OfferFilter offerFilter = new OfferFilter();
        offerFilter.setExcludeExpired(true);
        Page result = this.offerService.getOffers(offerFilter, pageable);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.getSize());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)result.getTotalElements());
        org.junit.jupiter.api.Assertions.assertEquals((Object)DeedTenantOfferMapper.toDTO((DeedTenantOffer)offer), result.get().findFirst().orElse(null));
    }

    @Test
    void testGetOffer() throws Exception {
        String offerId = "offerId";
        DeedTenantOffer offer = new DeedTenantOffer();
        offer.setId(offerId);
        offer.setViewAddresses(Collections.singletonList("ALL"));
        offer.setEnabled(true);
        Mockito.when((Object)this.offerRepository.findById((Object)offerId)).thenReturn(Optional.of(offer));
        DeedTenantOfferDTO deedTenantOfferDTO = this.offerService.getOffer(offerId, ADDRESS, false);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)deedTenantOfferDTO);
        org.junit.jupiter.api.Assertions.assertEquals((Object)offerId, (Object)deedTenantOfferDTO.getId());
    }

    @Test
    void testCreateRentingOfferBySimpleUser() {
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.offerService.createRentingOffer(ADDRESS, EMAIL, new DeedTenantOfferDTO()));
    }

    @Test
    void testCreateRentingOfferByOwnerButNotManager() {
        long nftId = 2L;
        String walletAddress = ADDRESS;
        DeedTenantOfferDTO deedTenantOfferDTO = new DeedTenantOfferDTO();
        deedTenantOfferDTO.setNftId(nftId);
        Mockito.when((Object)this.tenantService.isDeedOwner(walletAddress, nftId)).thenReturn((Object)true);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.offerService.createRentingOffer(walletAddress, EMAIL, deedTenantOfferDTO));
    }

    @Test
    void testCreateRentingOfferByOwnerWhenNftNotExists() throws Exception {
        long nftId = 2L;
        String walletAddress = ADDRESS;
        DeedTenantOfferDTO deedTenantOfferDTO = new DeedTenantOfferDTO();
        deedTenantOfferDTO.setNftId(nftId);
        deedTenantOfferDTO.setOfferTransactionHash("transactionHash");
        Mockito.when((Object)this.tenantService.isDeedOwner(walletAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantService.isDeedManager(walletAddress, nftId)).thenReturn((Object)true);
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.offerService.createRentingOffer(walletAddress, EMAIL, deedTenantOfferDTO));
    }

    @Test
    void testCreateRentingOfferByOwnerWhenTenantIsUsed() throws Exception {
        long nftId = 2L;
        String walletAddress = ADDRESS;
        DeedTenantOfferDTO deedTenantOfferDTO = new DeedTenantOfferDTO();
        deedTenantOfferDTO.setNftId(nftId);
        DeedTenant deedTenant = new DeedTenant();
        deedTenant.setNftId(nftId);
        deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.START_IN_PROGRESS);
        Mockito.when((Object)this.tenantService.isDeedOwner(walletAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantService.isDeedManager(walletAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(walletAddress, Long.valueOf(nftId))).thenReturn((Object)deedTenant);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.offerService.createRentingOffer(walletAddress, EMAIL, deedTenantOfferDTO));
    }

    @Test
    void testCreateRentingOfferByOwnerWhenTenantNotUsed() throws Exception {
        long nftId = 2L;
        String offerId = "offerId";
        String walletAddress = ADDRESS;
        DeedTenantOfferDTO deedTenantOfferDTO = new DeedTenantOfferDTO();
        deedTenantOfferDTO.setNftId(nftId);
        deedTenantOfferDTO.setCardType(DeedCard.LEGENDARY);
        deedTenantOfferDTO.setCity(DeedCity.ASHTARTE);
        deedTenantOfferDTO.setOwner("otherWallet");
        deedTenantOfferDTO.setDescription("description");
        deedTenantOfferDTO.setAmount(12.0);
        deedTenantOfferDTO.setOfferType(OfferType.SALE);
        deedTenantOfferDTO.setExpirationDuration(ExpirationDuration.ONE_MONTH);
        deedTenantOfferDTO.setDuration(RentalDuration.SIX_MONTHS);
        deedTenantOfferDTO.setPaymentPeriodicity(RentalPaymentPeriodicity.ONE_MONTH);
        deedTenantOfferDTO.setOwnerMintingPercentage(50);
        deedTenantOfferDTO.setMintingPower(50.0);
        deedTenantOfferDTO.setExpirationDate(Instant.now().plus(500L, ChronoUnit.DAYS));
        deedTenantOfferDTO.setCreatedDate(Instant.now().plus(500L, ChronoUnit.DAYS));
        deedTenantOfferDTO.setModifiedDate(Instant.now().plus(700L, ChronoUnit.DAYS));
        deedTenantOfferDTO.setEnabled(false);
        deedTenantOfferDTO.setOfferTransactionHash("transactionHash");
        DeedTenant deedTenant = new DeedTenant();
        deedTenant.setNftId(nftId);
        deedTenant.setCardType((short)DeedCard.UNCOMMON.ordinal());
        deedTenant.setCityIndex((short)DeedCity.MELQART.ordinal());
        Mockito.when((Object)this.tenantService.isDeedOwner(walletAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantService.isDeedManager(walletAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(walletAddress, Long.valueOf(nftId))).thenReturn((Object)deedTenant);
        Mockito.when((Object)this.offerRepository.save((Object)((DeedTenantOffer)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            DeedTenantOffer offer = (DeedTenantOffer)invocation.getArgument(0, DeedTenantOffer.class);
            offer.setId(offerId);
            return offer;
        });
        SearchHits searchHits = (SearchHits)Mockito.mock(SearchHits.class);
        Mockito.when((Object)searchHits.getSearchHits()).thenReturn(Collections.emptyList());
        Mockito.when((Object)searchHits.getTotalHits()).thenReturn((Object)0L);
        Mockito.when((Object)this.elasticsearchOperations.search((Query)ArgumentMatchers.any(Query.class), (Class)ArgumentMatchers.eq(DeedTenantOffer.class))).thenReturn((Object)searchHits);
        DeedTenantOfferDTO createdRentingOffer = this.offerService.createRentingOffer(walletAddress, EMAIL, deedTenantOfferDTO);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)createdRentingOffer);
        org.junit.jupiter.api.Assertions.assertEquals((Object)offerId, (Object)createdRentingOffer.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)OfferType.RENTING, (Object)createdRentingOffer.getOfferType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)DeedCity.MELQART, (Object)createdRentingOffer.getCity());
        org.junit.jupiter.api.Assertions.assertEquals((Object)DeedCard.UNCOMMON, (Object)createdRentingOffer.getCardType());
        org.junit.jupiter.api.Assertions.assertEquals((double)DeedCard.UNCOMMON.getMintingPower(), (double)createdRentingOffer.getMintingPower());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)createdRentingOffer.getCreatedDate());
        org.junit.jupiter.api.Assertions.assertEquals((Object)createdRentingOffer.getCreatedDate(), (Object)createdRentingOffer.getModifiedDate());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)createdRentingOffer.isEnabled());
        org.junit.jupiter.api.Assertions.assertEquals((Object)walletAddress, (Object)createdRentingOffer.getOwner());
        org.junit.jupiter.api.Assertions.assertEquals((Object)deedTenantOfferDTO.getExpirationDuration(), (Object)createdRentingOffer.getExpirationDuration());
        org.junit.jupiter.api.Assertions.assertEquals((Object)deedTenantOfferDTO.getDuration(), (Object)createdRentingOffer.getDuration());
        org.junit.jupiter.api.Assertions.assertEquals((int)deedTenantOfferDTO.getOwnerMintingPercentage(), (int)createdRentingOffer.getOwnerMintingPercentage());
        org.junit.jupiter.api.Assertions.assertEquals((Object)deedTenantOfferDTO.getPaymentPeriodicity(), (Object)createdRentingOffer.getPaymentPeriodicity());
        org.junit.jupiter.api.Assertions.assertEquals((double)deedTenantOfferDTO.getAmount(), (double)createdRentingOffer.getAmount());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)deedTenantOfferDTO.getExpirationDate(), (Object)createdRentingOffer.getExpirationDate());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)deedTenantOfferDTO.getCreatedDate(), (Object)createdRentingOffer.getCreatedDate());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)deedTenantOfferDTO.getModifiedDate(), (Object)createdRentingOffer.getModifiedDate());
    }

    @Test
    void testUpdateRentingOfferBySimpleUser() {
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.offerService.updateRentingOffer(ADDRESS, new DeedTenantOfferDTO()));
    }

    @Test
    void testUpdateRentingOfferByOwnerWhenNftNotExists() throws Exception {
        long nftId = 2L;
        String walletAddress = ADDRESS;
        DeedTenantOfferDTO deedTenantOfferDTO = new DeedTenantOfferDTO();
        deedTenantOfferDTO.setNftId(nftId);
        deedTenantOfferDTO.setOfferTransactionHash("transactionHash");
        deedTenantOfferDTO.setEnabled(true);
        Mockito.when((Object)this.tenantService.isDeedOwner(walletAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantService.isDeedManager(walletAddress, nftId)).thenReturn((Object)true);
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.offerService.updateRentingOffer(walletAddress, deedTenantOfferDTO));
    }

    @Test
    void testUpdateRentingOfferByOwnerWhenTenantNotUsed() throws Exception {
        long nftId = 2L;
        String offerId = "offerId";
        String walletAddress = ADDRESS;
        DeedTenantOfferDTO deedTenantOfferDTO = new DeedTenantOfferDTO();
        deedTenantOfferDTO.setId(offerId);
        deedTenantOfferDTO.setNftId(nftId);
        deedTenantOfferDTO.setCardType(DeedCard.LEGENDARY);
        deedTenantOfferDTO.setCity(DeedCity.ASHTARTE);
        deedTenantOfferDTO.setOwner("otherWallet");
        deedTenantOfferDTO.setDescription("description updated");
        deedTenantOfferDTO.setAmount(15.0);
        deedTenantOfferDTO.setOfferType(OfferType.SALE);
        deedTenantOfferDTO.setExpirationDuration(ExpirationDuration.ONE_WEEK);
        deedTenantOfferDTO.setNoticePeriod(NoticePeriod.ONE_MONTH);
        deedTenantOfferDTO.setDuration(RentalDuration.ONE_YEAR);
        deedTenantOfferDTO.setPaymentPeriodicity(RentalPaymentPeriodicity.ONE_YEAR);
        deedTenantOfferDTO.setOwnerMintingPercentage(85);
        deedTenantOfferDTO.setMintingPower(50.0);
        deedTenantOfferDTO.setExpirationDate(Instant.now().plus(500L, ChronoUnit.DAYS));
        deedTenantOfferDTO.setCreatedDate(Instant.now().plus(500L, ChronoUnit.DAYS));
        deedTenantOfferDTO.setModifiedDate(Instant.now().plus(700L, ChronoUnit.DAYS));
        deedTenantOfferDTO.setEnabled(false);
        deedTenantOfferDTO.setOfferTransactionHash("TransactionHash");
        Mockito.when((Object)this.tenantService.isDeedOwner(walletAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantService.isDeedManager(walletAddress, nftId)).thenReturn((Object)true);
        DeedTenantOffer existingDeedTenantOffer = this.newOffer(offerId, nftId);
        Mockito.when((Object)this.offerRepository.findById((Object)offerId)).thenReturn(Optional.of(existingDeedTenantOffer));
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.offerService.updateRentingOffer(walletAddress, deedTenantOfferDTO));
        deedTenantOfferDTO.setEnabled(true);
        Mockito.when((Object)this.offerRepository.save((Object)((DeedTenantOffer)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            DeedTenantOffer offer = (DeedTenantOffer)invocation.getArgument(0, DeedTenantOffer.class);
            offer.setId(offerId);
            return offer;
        });
        DeedTenantOfferDTO updatedRentingOffer = this.offerService.updateRentingOffer(walletAddress, deedTenantOfferDTO);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)updatedRentingOffer);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)updatedRentingOffer.getUpdateId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)OfferType.RENTING, (Object)updatedRentingOffer.getOfferType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)existingDeedTenantOffer.getCity(), (Object)updatedRentingOffer.getCity());
        org.junit.jupiter.api.Assertions.assertEquals((Object)existingDeedTenantOffer.getCardType(), (Object)updatedRentingOffer.getCardType());
        org.junit.jupiter.api.Assertions.assertEquals((double)existingDeedTenantOffer.getCardType().getMintingPower(), (double)updatedRentingOffer.getMintingPower());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)updatedRentingOffer.isEnabled());
        org.junit.jupiter.api.Assertions.assertEquals((Object)existingDeedTenantOffer.getOwner(), (Object)updatedRentingOffer.getOwner());
        org.junit.jupiter.api.Assertions.assertEquals((int)existingDeedTenantOffer.getExpirationDays(), (int)updatedRentingOffer.getExpirationDuration().getDays());
        org.junit.jupiter.api.Assertions.assertEquals((int)existingDeedTenantOffer.getMonths(), (int)updatedRentingOffer.getDuration().getMonths());
        org.junit.jupiter.api.Assertions.assertEquals((int)existingDeedTenantOffer.getOwnerMintingPercentage(), (int)updatedRentingOffer.getOwnerMintingPercentage());
        org.junit.jupiter.api.Assertions.assertEquals((Object)existingDeedTenantOffer.getPaymentPeriodicity(), (Object)updatedRentingOffer.getPaymentPeriodicity());
        org.junit.jupiter.api.Assertions.assertEquals((double)existingDeedTenantOffer.getAmount(), (double)updatedRentingOffer.getAmount());
        org.junit.jupiter.api.Assertions.assertEquals((double)existingDeedTenantOffer.getAllDurationAmount(), (double)updatedRentingOffer.getAllDurationAmount());
        org.junit.jupiter.api.Assertions.assertEquals((int)existingDeedTenantOffer.getNoticePeriod(), (int)updatedRentingOffer.getNoticePeriod().getMonths());
    }

    @Test
    void testUpdateRentingOfferByOwnerWhenNeverExpires() throws Exception {
        long nftId = 2L;
        String offerId = "offerId";
        String walletAddress = ADDRESS;
        DeedTenantOfferDTO deedTenantOfferDTO = new DeedTenantOfferDTO();
        deedTenantOfferDTO.setId(offerId);
        deedTenantOfferDTO.setNftId(nftId);
        deedTenantOfferDTO.setCardType(DeedCard.LEGENDARY);
        deedTenantOfferDTO.setCity(DeedCity.ASHTARTE);
        deedTenantOfferDTO.setOwner("otherWallet");
        deedTenantOfferDTO.setDescription("description updated");
        deedTenantOfferDTO.setAmount(15.0);
        deedTenantOfferDTO.setOfferType(OfferType.SALE);
        deedTenantOfferDTO.setDuration(RentalDuration.ONE_YEAR);
        deedTenantOfferDTO.setPaymentPeriodicity(RentalPaymentPeriodicity.ONE_YEAR);
        deedTenantOfferDTO.setOwnerMintingPercentage(85);
        deedTenantOfferDTO.setMintingPower(50.0);
        deedTenantOfferDTO.setExpirationDate(Instant.now().plus(500L, ChronoUnit.DAYS));
        deedTenantOfferDTO.setCreatedDate(Instant.now().plus(500L, ChronoUnit.DAYS));
        deedTenantOfferDTO.setModifiedDate(Instant.now().plus(700L, ChronoUnit.DAYS));
        deedTenantOfferDTO.setEnabled(true);
        deedTenantOfferDTO.setOfferTransactionHash("transactionHash");
        Mockito.when((Object)this.tenantService.isDeedOwner(walletAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantService.isDeedManager(walletAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.offerRepository.save((Object)((DeedTenantOffer)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0, DeedTenantOffer.class));
        DeedTenantOffer existingDeedTenantOffer = new DeedTenantOffer();
        existingDeedTenantOffer.setId(offerId);
        existingDeedTenantOffer.setNftId(nftId);
        existingDeedTenantOffer.setCardType(DeedCard.UNCOMMON);
        existingDeedTenantOffer.setCity(DeedCity.MELQART);
        existingDeedTenantOffer.setOwner("otherWallet");
        existingDeedTenantOffer.setDescription("description");
        existingDeedTenantOffer.setAmount(12.0);
        existingDeedTenantOffer.setOfferType(OfferType.RENTING);
        existingDeedTenantOffer.setExpirationDays(30);
        existingDeedTenantOffer.setMonths(6);
        existingDeedTenantOffer.setPaymentPeriodicity(RentalPaymentPeriodicity.ONE_MONTH);
        existingDeedTenantOffer.setOwnerMintingPercentage(50);
        existingDeedTenantOffer.setMintingPower(DeedCard.UNCOMMON.getMintingPower());
        existingDeedTenantOffer.setExpirationDate(Instant.now().plus(5L, ChronoUnit.DAYS));
        existingDeedTenantOffer.setCreatedDate(Instant.now());
        existingDeedTenantOffer.setModifiedDate(Instant.now());
        existingDeedTenantOffer.setEnabled(true);
        existingDeedTenantOffer.setOfferTransactionHash("TransactionHash");
        Mockito.when((Object)this.offerRepository.findById((Object)offerId)).thenReturn(Optional.of(existingDeedTenantOffer));
        DeedTenantOfferDTO updatedRentingOffer = this.offerService.updateRentingOffer(walletAddress, deedTenantOfferDTO);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)updatedRentingOffer);
        org.junit.jupiter.api.Assertions.assertEquals((Object)OfferType.RENTING, (Object)updatedRentingOffer.getOfferType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)existingDeedTenantOffer.getCity(), (Object)updatedRentingOffer.getCity());
        org.junit.jupiter.api.Assertions.assertEquals((Object)existingDeedTenantOffer.getCardType(), (Object)updatedRentingOffer.getCardType());
        org.junit.jupiter.api.Assertions.assertEquals((double)existingDeedTenantOffer.getCardType().getMintingPower(), (double)updatedRentingOffer.getMintingPower());
        org.junit.jupiter.api.Assertions.assertEquals((Object)existingDeedTenantOffer.getOwner(), (Object)updatedRentingOffer.getOwner());
        org.junit.jupiter.api.Assertions.assertEquals((int)existingDeedTenantOffer.getMonths(), (int)updatedRentingOffer.getDuration().getPeriod().getMonths());
        org.junit.jupiter.api.Assertions.assertEquals((int)existingDeedTenantOffer.getOwnerMintingPercentage(), (int)updatedRentingOffer.getOwnerMintingPercentage());
        org.junit.jupiter.api.Assertions.assertEquals((Object)existingDeedTenantOffer.getPaymentPeriodicity(), (Object)updatedRentingOffer.getPaymentPeriodicity());
        org.junit.jupiter.api.Assertions.assertEquals((double)existingDeedTenantOffer.getAmount(), (double)updatedRentingOffer.getAmount());
    }

    @Test
    void testDeleteRentingOfferWhenNotExists() throws Exception {
        String offerId = "offerId";
        String walletAddress = ADDRESS;
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.offerService.deleteRentingOffer(walletAddress, offerId, ""));
    }

    @Test
    void testDeleteRentingOfferWhenExistsAndNotOwner() throws Exception {
        long nftId = 2L;
        String offerId = "offerId";
        String walletAddress = ADDRESS;
        DeedTenantOffer offer = new DeedTenantOffer();
        offer.setNftId(nftId);
        Mockito.lenient().when((Object)this.tenantService.isDeedManager(walletAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.offerRepository.findById((Object)offerId)).thenReturn(Optional.of(offer));
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.offerService.deleteRentingOffer(walletAddress, offerId, null), (String)"even Deed Manager shouldn't be able to delete Offer");
    }

    @Test
    void testDeleteRentingOfferWhenExistsAndOwner() throws Exception {
        long nftId = 2L;
        String offerId = "offerId";
        String walletAddress = ADDRESS;
        DeedTenantOffer offer = new DeedTenantOffer();
        offer.setNftId(nftId);
        offer.setEnabled(true);
        offer.setOfferTransactionHash("TransactionHash");
        Mockito.when((Object)this.tenantService.isDeedOwner(walletAddress, nftId)).thenReturn((Object)true);
        Mockito.when((Object)this.offerRepository.findById((Object)offerId)).thenReturn(Optional.of(offer));
        Mockito.when((Object)this.offerRepository.save((Object)((DeedTenantOffer)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.offerService.deleteRentingOffer(walletAddress, offerId, null));
        this.offerService.deleteRentingOffer(walletAddress, offerId, "transactionHash");
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.never())).deleteById((Object)((String)ArgumentMatchers.any()));
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.atLeast((int)1))).save((Object)((DeedTenantOffer)ArgumentMatchers.any()));
    }

    @Test
    void testCancelRentingOfferWhenExists() throws Exception {
        long nftId = 2L;
        String walletAddress = ADDRESS;
        DeedTenantOffer offer = new DeedTenantOffer();
        offer.setNftId(nftId);
        offer.setOfferTransactionHash("TransactionHash");
        List<DeedTenantOffer> offers = Collections.singletonList(offer);
        Mockito.when((Object)this.offerRepository.findByOwnerNotAndNftIdAndEnabledTrue(walletAddress, nftId)).thenReturn(offers);
        Mockito.when((Object)this.offerRepository.save((Object)((DeedTenantOffer)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0));
        this.offerService.cancelOffers(walletAddress, nftId);
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.never())).deleteById((Object)((String)ArgumentMatchers.any()));
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenantOffer)ArgumentMatchers.any()));
    }

    @Test
    void testGetPendingTransactions() throws Exception {
        DeedTenantOffer offer = this.newOffer("1", 5L);
        Mockito.when((Object)this.offerRepository.findByOfferTransactionStatusInOrderByCreatedDateAsc(Arrays.asList(TransactionStatus.IN_PROGRESS))).thenReturn(Collections.singletonList(offer));
        List pendingTransactions = this.offerService.getPendingTransactions();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)pendingTransactions);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)pendingTransactions.size());
        DeedTenantOfferDTO deedTenantOfferDTO = (DeedTenantOfferDTO)pendingTransactions.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)offer.getId(), (Object)deedTenantOfferDTO.getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)offer.getNftId(), (long)deedTenantOfferDTO.getNftId());
    }

    @Test
    void testUpdateRentingOfferStatusFromBlockchain() throws Exception {
        String id = "offerId";
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.offerService.updateRentingOfferStatusFromBlockchain(id, Collections.singletonMap(BlockchainOfferStatus.OFFER_ACQUIRED, (DeedOfferBlockchainState)Mockito.mock(DeedOfferBlockchainState.class))));
        DeedTenantOffer offer = this.newOffer(id, 5L);
        Mockito.when((Object)this.offerRepository.findById((Object)id)).thenReturn(Optional.of(offer));
        offer.setOfferId(10L);
        Mockito.when((Object)this.blockchainService.isOfferEnabled(10L)).thenReturn((Object)true);
        this.offerService.updateRentingOfferStatusFromBlockchain(id, Collections.emptyMap());
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.never())).delete((Object)((DeedTenantOffer)ArgumentMatchers.any()));
        Mockito.when((Object)this.blockchainService.isOfferEnabled(10L)).thenReturn((Object)false);
        this.offerService.updateRentingOfferStatusFromBlockchain(id, Collections.emptyMap());
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.times((int)1))).delete((Object)((DeedTenantOffer)ArgumentMatchers.any()));
    }

    @Test
    void testMarkOfferAcquisitionInProgress() throws Exception {
        long nftId = 2L;
        long blockchainOfferId = 6L;
        String transactionHash = "transactionHash";
        Instant validStartDate = Instant.now();
        this.offerService.markOfferAcquisitionInProgress(nftId, null, validStartDate);
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.never())).save((Object)((DeedTenantOffer)ArgumentMatchers.any()));
        DeedTenantOffer anotherDeedTenant = this.newOffer("anotherId", nftId);
        Mockito.when((Object)this.offerRepository.findByOfferTransactionHash(StringUtils.lowerCase((String)transactionHash))).thenReturn((Object)anotherDeedTenant);
        org.junit.jupiter.api.Assertions.assertThrows(ObjectAlreadyExistsException.class, () -> this.offerService.markOfferAcquisitionInProgress(nftId, transactionHash, validStartDate));
        DeedTenantOffer acquiredOffer = this.newOffer("acquiredOfferId", nftId);
        Mockito.when((Object)this.offerRepository.findByOfferIdAndParentIdIsNull(blockchainOfferId)).thenReturn(Collections.singletonList(acquiredOffer));
        String anotherTransactionHash = "transactionHash2";
        this.offerService.markOfferAcquisitionInProgress(nftId, anotherTransactionHash, validStartDate);
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.never())).save((Object)((DeedTenantOffer)ArgumentMatchers.any()));
        String offerId = "offerId";
        final DeedTenantOffer existingDeedTenant = this.newOffer(offerId, nftId);
        existingDeedTenant.setStartDate(validStartDate.minusSeconds(5L));
        List<DeedTenantOffer> offers = Collections.singletonList(existingDeedTenant);
        Mockito.when((Object)this.offerRepository.findByNftId(nftId)).thenReturn(offers);
        existingDeedTenant.setAcquired(true);
        this.offerService.markOfferAcquisitionInProgress(nftId, anotherTransactionHash, validStartDate);
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.never())).save((Object)((DeedTenantOffer)ArgumentMatchers.any()));
        existingDeedTenant.setAcquired(false);
        existingDeedTenant.setEnabled(false);
        this.offerService.markOfferAcquisitionInProgress(nftId, anotherTransactionHash, validStartDate);
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.never())).save((Object)((DeedTenantOffer)ArgumentMatchers.any()));
        existingDeedTenant.setEnabled(true);
        existingDeedTenant.setParentId("parentOfferId");
        this.offerService.markOfferAcquisitionInProgress(nftId, anotherTransactionHash, validStartDate);
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.never())).save((Object)((DeedTenantOffer)ArgumentMatchers.any()));
        existingDeedTenant.setParentId(null);
        existingDeedTenant.setOfferTransactionStatus(TransactionStatus.ERROR);
        this.offerService.markOfferAcquisitionInProgress(nftId, anotherTransactionHash, validStartDate);
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.never())).save((Object)((DeedTenantOffer)ArgumentMatchers.any()));
        existingDeedTenant.setOfferTransactionStatus(TransactionStatus.VALIDATED);
        existingDeedTenant.setStartDate(validStartDate);
        this.offerService.markOfferAcquisitionInProgress(nftId, anotherTransactionHash, validStartDate);
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.never())).save((Object)((DeedTenantOffer)ArgumentMatchers.any()));
        existingDeedTenant.setStartDate(validStartDate.minusSeconds(5L));
        this.mockOfferSaving();
        this.offerService.markOfferAcquisitionInProgress(nftId, anotherTransactionHash, validStartDate);
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.atLeast((int)1))).save((Object)((DeedTenantOffer)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenantOffer>(){

            public boolean matches(DeedTenantOffer offer) {
                return StringUtils.equals((CharSequence)offer.getId(), (CharSequence)existingDeedTenant.getId()) && offer.getAcquisitionIds().size() == 1;
            }
        })));
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.atLeast((int)1))).save((Object)((DeedTenantOffer)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenantOffer>(){

            public boolean matches(DeedTenantOffer offer) {
                return !StringUtils.equals((CharSequence)offer.getId(), (CharSequence)existingDeedTenant.getId()) && StringUtils.equals((CharSequence)offer.getParentId(), (CharSequence)existingDeedTenant.getId());
            }
        })));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent("deed.event.offerAcquisitionInProgress", (Object)existingDeedTenant);
    }

    @Test
    void testGetOfferWithBlockchainRefresh() throws Exception {
        long nftId = 2L;
        long blockchainOfferId = 6L;
        String offerId = "offerId";
        String walletAddress = "walletAddress";
        String authorizedAddress = "authorizedAddress";
        org.junit.jupiter.api.Assertions.assertThrows(ObjectNotFoundException.class, () -> this.offerService.getOffer(offerId, null, false));
        DeedTenantOffer offer = this.newOffer(offerId, nftId);
        offer.setOwner(walletAddress);
        offer.setHostAddress(authorizedAddress);
        Mockito.when((Object)this.offerRepository.findById((Object)offerId)).thenReturn(Optional.of(offer));
        offer.setEnabled(false);
        org.junit.jupiter.api.Assertions.assertThrows(UnauthorizedOperationException.class, () -> this.offerService.getOffer(offerId, null, false));
        offer.setEnabled(true);
        DeedTenantOfferDTO offerDTO = this.offerService.getOffer(offerId, null, false);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)offerDTO);
        org.junit.jupiter.api.Assertions.assertEquals((Object)offer.getId(), (Object)offerDTO.getId());
        offer.setOfferId(0L);
        offer.setOfferTransactionStatus(TransactionStatus.VALIDATED);
        offerDTO = this.offerService.getOffer(offerId, walletAddress, true);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)offerDTO);
        org.junit.jupiter.api.Assertions.assertEquals((Object)offer.getId(), (Object)offerDTO.getId());
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.never())).save((Object)((DeedTenantOffer)ArgumentMatchers.any()));
        this.offerService.releaseExplicitOfferRefreshLock(offerId);
        this.offerService.releaseExplicitOfferRefreshLock(offerId);
        offer.setOfferTransactionStatus(TransactionStatus.IN_PROGRESS);
        offerDTO = this.offerService.getOffer(offerId, walletAddress, true);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)offerDTO);
        org.junit.jupiter.api.Assertions.assertEquals((Object)offer.getId(), (Object)offerDTO.getId());
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.never())).save((Object)((DeedTenantOffer)ArgumentMatchers.any()));
        final BigInteger price = BigInteger.valueOf(12L);
        final BigInteger allDurationPrice = BigInteger.valueOf(7L);
        final DeedOfferBlockchainState blockchainState = this.newOfferBlockchainState(nftId, blockchainOfferId, walletAddress, authorizedAddress, offer.getOfferTransactionHash(), price, allDurationPrice);
        Mockito.when((Object)this.blockchainService.getOfferTransactionEvents(offer.getOfferTransactionHash())).thenReturn(Collections.singletonMap(BlockchainOfferStatus.OFFER_CREATED, blockchainState));
        this.mockOfferSaving();
        this.offerService.releaseExplicitOfferRefreshLock(offerId);
        Mockito.when((Object)this.blockchainService.isOfferEnabled(blockchainOfferId)).thenReturn((Object)true);
        offerDTO = this.offerService.getOffer(offerId, walletAddress, true);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)offerDTO);
        org.junit.jupiter.api.Assertions.assertEquals((Object)offer.getId(), (Object)offerDTO.getId());
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenantOffer)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenantOffer>(){

            public boolean matches(DeedTenantOffer persistedOffer) {
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getId().longValue(), (long)persistedOffer.getOfferId());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getDeedId().longValue(), (long)persistedOffer.getNftId());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getBlockNumber().longValue(), (long)persistedOffer.getLastCheckedBlock());
                org.junit.jupiter.api.Assertions.assertEquals((Object)StringUtils.lowerCase((String)blockchainState.getCreator()), (Object)persistedOffer.getOwner());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getMonths().longValue(), (long)persistedOffer.getMonths());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getNoticePeriod().longValue(), (long)persistedOffer.getNoticePeriod());
                org.junit.jupiter.api.Assertions.assertEquals((double)price.doubleValue(), (double)persistedOffer.getAmount());
                org.junit.jupiter.api.Assertions.assertEquals((double)allDurationPrice.doubleValue(), (double)persistedOffer.getAllDurationAmount());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getOfferStartDate().longValue(), (long)(persistedOffer.getStartDate().toEpochMilli() / 1000L));
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getOfferExpirationDate().longValue(), (long)(persistedOffer.getExpirationDate().toEpochMilli() / 1000L));
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getOfferExpirationDays().longValue(), (long)persistedOffer.getExpirationDays());
                org.junit.jupiter.api.Assertions.assertEquals((Object)StringUtils.lowerCase((String)blockchainState.getAuthorizedTenant()), (Object)persistedOffer.getHostAddress());
                return true;
            }
        })));
    }

    @Test
    void testGetOfferByBlockchainId() throws Exception {
        long nftId = 2L;
        long blockchainOfferId = 6L;
        String offerId = "offerId";
        String walletAddress = "walletAddress";
        String authorizedAddress = "authorizedAddress";
        String transactionHash = "transactionHash";
        final BigInteger price = BigInteger.valueOf(12L);
        final BigInteger allDurationPrice = BigInteger.valueOf(7L);
        org.junit.jupiter.api.Assertions.assertNull((Object)this.offerService.getOfferByBlockchainId(blockchainOfferId));
        final DeedOfferBlockchainState blockchainState = this.newOfferBlockchainState(nftId, blockchainOfferId, walletAddress, authorizedAddress, transactionHash, price, allDurationPrice);
        Mockito.when((Object)this.blockchainService.getOfferById(BigInteger.valueOf(blockchainOfferId), null, null)).thenReturn((Object)blockchainState);
        DeedTenant deedTenant = new DeedTenant();
        deedTenant.setNftId(nftId);
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(blockchainState.getCreator(), Long.valueOf(nftId))).thenReturn((Object)deedTenant);
        this.mockOfferSaving();
        DeedTenantOfferDTO offerByBlockchainId = this.offerService.getOfferByBlockchainId(blockchainOfferId);
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenantOffer)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenantOffer>(){

            public boolean matches(DeedTenantOffer persistedOffer) {
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getId().longValue(), (long)persistedOffer.getOfferId());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getDeedId().longValue(), (long)persistedOffer.getNftId());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getBlockNumber().longValue(), (long)persistedOffer.getLastCheckedBlock());
                org.junit.jupiter.api.Assertions.assertEquals((Object)StringUtils.lowerCase((String)blockchainState.getCreator()), (Object)persistedOffer.getOwner());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getMonths().longValue(), (long)persistedOffer.getMonths());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getNoticePeriod().longValue(), (long)persistedOffer.getNoticePeriod());
                org.junit.jupiter.api.Assertions.assertEquals((double)price.doubleValue(), (double)persistedOffer.getAmount());
                org.junit.jupiter.api.Assertions.assertEquals((double)allDurationPrice.doubleValue(), (double)persistedOffer.getAllDurationAmount());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getOfferStartDate().longValue(), (long)(persistedOffer.getStartDate().toEpochMilli() / 1000L));
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getOfferExpirationDate().longValue(), (long)(persistedOffer.getExpirationDate().toEpochMilli() / 1000L));
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getOfferExpirationDays().longValue(), (long)persistedOffer.getExpirationDays());
                org.junit.jupiter.api.Assertions.assertEquals((Object)StringUtils.lowerCase((String)blockchainState.getAuthorizedTenant()), (Object)persistedOffer.getHostAddress());
                return true;
            }
        })));
        DeedTenantOffer offer = this.newOffer(offerId, nftId);
        List<DeedTenantOffer> offers = Arrays.asList(offer, this.newOffer("otherOfferId", nftId));
        Mockito.when((Object)this.offerRepository.findByOfferIdAndParentIdIsNull(blockchainOfferId)).thenReturn(offers);
        offerByBlockchainId = this.offerService.getOfferByBlockchainId(blockchainOfferId);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)offerByBlockchainId);
        org.junit.jupiter.api.Assertions.assertEquals((Object)offer.getId(), (Object)offerByBlockchainId.getId());
    }

    @Test
    void testUpdateOfferFromBlockchain() throws Exception {
        long nftId = 2L;
        long blockchainOfferId = 6L;
        String offerId = "offerId";
        String walletAddress = "walletAddress";
        String authorizedAddress = "authorizedAddress";
        final String transactionHash = "transactionHash";
        final BigInteger price = BigInteger.valueOf(12L);
        final BigInteger allDurationPrice = BigInteger.valueOf(7L);
        this.mockOfferSaving();
        final DeedOfferBlockchainState blockchainState = this.newOfferBlockchainState(nftId, blockchainOfferId, walletAddress, authorizedAddress, transactionHash, price, allDurationPrice);
        DeedTenant deedTenant = new DeedTenant();
        deedTenant.setNftId(nftId);
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(blockchainState.getCreator(), Long.valueOf(nftId))).thenReturn((Object)deedTenant);
        DeedTenantOffer existingOffer = this.newOffer(offerId, nftId);
        Mockito.when((Object)this.offerRepository.findByOfferIdAndParentIdIsNull(blockchainOfferId)).thenReturn(Collections.singletonList(existingOffer));
        DeedTenantOffer createdOffer = this.offerService.updateOfferFromBlockchain(blockchainState, true);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)createdOffer);
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenantOffer)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenantOffer>(){

            public boolean matches(DeedTenantOffer persistedOffer) {
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getId().longValue(), (long)persistedOffer.getOfferId());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getDeedId().longValue(), (long)persistedOffer.getNftId());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getBlockNumber().longValue(), (long)persistedOffer.getLastCheckedBlock());
                org.junit.jupiter.api.Assertions.assertEquals((Object)StringUtils.lowerCase((String)blockchainState.getCreator()), (Object)persistedOffer.getOwner());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getMonths().longValue(), (long)persistedOffer.getMonths());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getNoticePeriod().longValue(), (long)persistedOffer.getNoticePeriod());
                org.junit.jupiter.api.Assertions.assertEquals((double)price.doubleValue(), (double)persistedOffer.getAmount());
                org.junit.jupiter.api.Assertions.assertEquals((double)allDurationPrice.doubleValue(), (double)persistedOffer.getAllDurationAmount());
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getOfferStartDate().longValue(), (long)(persistedOffer.getStartDate().toEpochMilli() / 1000L));
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getOfferExpirationDate().longValue(), (long)(persistedOffer.getExpirationDate().toEpochMilli() / 1000L));
                org.junit.jupiter.api.Assertions.assertEquals((long)blockchainState.getOfferExpirationDays().longValue(), (long)persistedOffer.getExpirationDays());
                org.junit.jupiter.api.Assertions.assertEquals((Object)StringUtils.lowerCase((String)blockchainState.getAuthorizedTenant()), (Object)persistedOffer.getHostAddress());
                org.junit.jupiter.api.Assertions.assertEquals((Object)StringUtils.lowerCase((String)transactionHash), (Object)StringUtils.lowerCase((String)persistedOffer.getOfferTransactionHash()));
                return true;
            }
        })));
    }

    @Test
    void testMarkOfferAsAcquired() throws Exception {
        long nftId = 2L;
        long blockchainOfferId = 6L;
        String offerId = "offerId";
        String parentOfferId = "parentOfferId";
        String walletAddress = "walletAddress";
        String authorizedAddress = "authorizedAddress";
        Instant leaseEndDate = Instant.now();
        this.mockOfferSaving();
        DeedTenantOffer parentOffer = this.newOffer(parentOfferId, nftId);
        parentOffer.setOwner(walletAddress);
        parentOffer.setHostAddress(authorizedAddress);
        parentOffer.setAcquisitionIds(Collections.singleton(offerId));
        parentOffer.setOfferId(blockchainOfferId);
        DeedTenantOffer offer = this.newOffer(offerId, nftId);
        offer.setOwner(walletAddress);
        offer.setHostAddress(authorizedAddress);
        offer.setParentId(parentOfferId);
        offer.setOfferId(blockchainOfferId);
        Mockito.when((Object)this.offerRepository.findById((Object)offerId)).thenReturn(Optional.of(offer));
        Mockito.when((Object)this.offerRepository.findById((Object)parentOfferId)).thenReturn(Optional.of(parentOffer));
        DeedTenantOffer existingOffer = this.newOffer("existingOfferId", nftId);
        existingOffer.setStartDate(leaseEndDate.minusSeconds(5L));
        List<DeedTenantOffer> offers = Collections.singletonList(existingOffer);
        Mockito.when((Object)this.offerRepository.findByNftId(nftId)).thenReturn(offers);
        Mockito.when((Object)this.offerRepository.findByOfferIdAndParentIdIsNull(blockchainOfferId)).thenReturn(Collections.singletonList(parentOffer));
        offer.setAcquired(false);
        parentOffer.setAcquired(false);
        this.offerService.markOfferAsAcquired(offer.getOfferId(), leaseEndDate);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)parentOffer.isAcquired());
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.atLeast((int)1))).save((Object)parentOffer);
        ((OfferRepository)Mockito.verify((Object)this.offerRepository, (VerificationMode)Mockito.times((int)1))).deleteByParentId(parentOfferId);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent("deed.event.offerCanceled", (Object)existingOffer);
    }

    private void mockOfferSaving() {
        Mockito.when((Object)this.offerRepository.save((Object)((DeedTenantOffer)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            DeedTenantOffer offerToPersist = (DeedTenantOffer)invocation.getArgument(0, DeedTenantOffer.class);
            if (StringUtils.isBlank((CharSequence)offerToPersist.getId())) {
                offerToPersist.setId(String.valueOf(Math.random()));
                Mockito.when((Object)this.offerRepository.findById((Object)offerToPersist.getId())).thenReturn(Optional.of(offerToPersist));
            }
            return offerToPersist;
        });
    }

    private DeedOfferBlockchainState newOfferBlockchainState(long nftId, long blockchainOfferId, String walletAddress, String authorizedAddress, String transactionHash, BigInteger price, BigInteger allDurationPrice) {
        return new DeedOfferBlockchainState(BigInteger.valueOf(blockchainOfferId), BigInteger.valueOf(3L), BigInteger.valueOf(nftId), walletAddress, BigInteger.valueOf(4L), BigInteger.valueOf(5L), price.multiply(BigInteger.valueOf(10L).pow(18)), allDurationPrice.multiply(BigInteger.valueOf(10L).pow(18)), BigInteger.valueOf(8L), BigInteger.valueOf(9L), BigInteger.valueOf(10L), authorizedAddress, BigInteger.valueOf(11L), transactionHash);
    }

    private DeedTenantOffer newOffer(String offerId, long nftId) {
        DeedTenantOffer offer = new DeedTenantOffer();
        offer.setId(offerId);
        offer.setNftId(nftId);
        offer.setCardType(DeedCard.UNCOMMON);
        offer.setCity(DeedCity.MELQART);
        offer.setOwner("otherWallet");
        offer.setDescription("description");
        offer.setAmount(12.0);
        offer.setOfferType(OfferType.RENTING);
        offer.setExpirationDays(30);
        offer.setMonths(6);
        offer.setPaymentPeriodicity(RentalPaymentPeriodicity.ONE_MONTH);
        offer.setOwnerMintingPercentage(50);
        offer.setMintingPower(DeedCard.UNCOMMON.getMintingPower());
        offer.setExpirationDate(Instant.now().plus(5L, ChronoUnit.DAYS));
        offer.setCreatedDate(Instant.now());
        offer.setModifiedDate(Instant.now());
        offer.setOfferTransactionHash("TransactionHash");
        offer.setEnabled(true);
        Mockito.lenient().when((Object)this.offerRepository.findById((Object)offer.getId())).thenReturn(Optional.of(offer));
        return offer;
    }

    private void assertElasticSearchQuery(SearchHits<DeedTenantOffer> searchHits, final String filedName) {
        Mockito.when((Object)this.elasticsearchOperations.search((Query)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Query>(){

            public boolean matches(Query query) {
                OfferServiceTest.this.assertQueryCriteriaNotNull(query, filedName);
                return true;
            }
        }), (Class)ArgumentMatchers.eq(DeedTenantOffer.class))).thenReturn(searchHits);
    }

    private void assertQueryCriteriaNotNull(Query query, String filedName) {
        CriteriaQuery criteriaQuery = (CriteriaQuery)query;
        Criteria criteria = criteriaQuery.getCriteria();
        List criteriaChain = criteria.getCriteriaChain();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)criteriaChain);
        for (Criteria subCriteria : criteriaChain) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)subCriteria);
            if (!StringUtils.equals((CharSequence)filedName, (CharSequence)subCriteria.getField().getName())) continue;
            return;
        }
        Assertions.fail((String)"Field not found");
    }
}

