/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.blockchain;

import io.meeds.deeds.common.blockchain.PolygonWomRawTransactionManager;
import java.io.IOException;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.methods.response.EthChainId;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.response.PollingTransactionReceiptProcessor;
import org.web3j.tx.response.TransactionReceiptProcessor;

public class PolygonTransactionManagerProxy
extends TransactionManager {
    private static final Logger LOG = LoggerFactory.getLogger(PolygonTransactionManagerProxy.class);
    private static TransactionManager transactionManager;
    private static Web3j web3j;

    public PolygonTransactionManagerProxy() {
        super((TransactionReceiptProcessor)new PollingTransactionReceiptProcessor(web3j, 15000L, 40), null);
    }

    public static void initTransactionManager(ECKeyPair ecKeyPair) {
        transactionManager = new PolygonWomRawTransactionManager(web3j, Credentials.create((ECKeyPair)ecKeyPair), PolygonTransactionManagerProxy.getPolygonNetworkId());
    }

    public EthSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, boolean constructor) throws IOException {
        return transactionManager.sendTransaction(gasPrice, gasLimit, to, data, value, constructor);
    }

    public EthSendTransaction sendEIP1559Transaction(long chainId, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, BigInteger value, boolean constructor) throws IOException {
        return transactionManager.sendEIP1559Transaction(chainId, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, value, constructor);
    }

    public String sendCall(String to, String data, DefaultBlockParameter defaultBlockParameter) throws IOException {
        return transactionManager.sendCall(to, data, defaultBlockParameter);
    }

    public EthGetCode getCode(String contractAddress, DefaultBlockParameter defaultBlockParameter) throws IOException {
        return transactionManager.getCode(contractAddress, defaultBlockParameter);
    }

    public EthSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value) throws IOException {
        return transactionManager.sendTransaction(gasPrice, gasLimit, to, data, value);
    }

    public EthSendTransaction sendEIP1559Transaction(long chainId, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, BigInteger value) throws IOException {
        return transactionManager.sendEIP1559Transaction(chainId, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, data, value);
    }

    public String getFromAddress() {
        return transactionManager.getFromAddress();
    }

    private static long getPolygonNetworkId() {
        try {
            return ((EthChainId)web3j.ethChainId().send()).getChainId().longValue();
        }
        catch (IOException e) {
            LOG.warn("Error retrieving Network Identifier", (Throwable)e);
            return 137L;
        }
    }

    public static void setTransactionManager(TransactionManager transactionManager) {
        PolygonTransactionManagerProxy.transactionManager = transactionManager;
    }

    public static void setWeb3j(Web3j web3j) {
        PolygonTransactionManagerProxy.web3j = web3j;
    }
}

