/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.elasticsearch.model.HubReportEntity;
import io.meeds.deeds.common.elasticsearch.model.UemRewardEntity;
import io.meeds.deeds.common.elasticsearch.storage.HubReportRepository;
import io.meeds.deeds.common.elasticsearch.storage.UemRewardRepository;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.deeds.common.utils.HubReportMapper;
import io.meeds.wom.api.constant.WomAuthorizationException;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.HubReport;
import io.meeds.wom.api.model.HubReportPayload;
import io.meeds.wom.api.model.HubReportVerifiableData;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class HubReportService {
    public static final String HUB_REPORT_SAVED = "uem.report.saved";
    @Autowired
    private BlockchainService blockchainService;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private HubReportRepository reportRepository;
    @Autowired
    private UemRewardRepository rewardRepository;

    public Page<HubReport> getReportsByHub(String hubAddress, Pageable pageable) {
        return this.getReports(hubAddress, 0L, pageable);
    }

    public Page<HubReport> getReportsByRewardId(long rewardId, Pageable pageable) {
        return this.getReports(null, rewardId, pageable);
    }

    public List<HubReport> getReportsByRewardId(long rewardId) {
        return this.reportRepository.findByRewardId(rewardId).map(HubReportMapper::fromEntity).toList();
    }

    public Page<HubReport> getReports(String hubAddress, long rewardId, Pageable pageable) {
        Page<HubReportEntity> page;
        if (StringUtils.isBlank((CharSequence)hubAddress) && rewardId == 0L) {
            pageable = pageable.isUnpaged() ? pageable : PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageable.getSortOr(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"fromDate"})));
            page = this.reportRepository.findAll(pageable);
        } else if (rewardId == 0L) {
            pageable = pageable.isUnpaged() ? pageable : PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageable.getSortOr(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"sentDate"})));
            page = this.reportRepository.findByHubAddress(StringUtils.lowerCase((String)hubAddress), pageable);
        } else if (StringUtils.isBlank((CharSequence)hubAddress)) {
            pageable = pageable.isUnpaged() ? pageable : PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageable.getSortOr(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"sentDate"})));
            page = this.reportRepository.findByRewardId(rewardId, pageable);
        } else {
            page = this.reportRepository.findByRewardIdAndHubAddress(rewardId, StringUtils.lowerCase((String)hubAddress), pageable);
        }
        return page.map(HubReportMapper::fromEntity);
    }

    public HubReport getReport(long reportId) {
        return this.reportRepository.findById(reportId).map(HubReportMapper::fromEntity).orElseGet(() -> this.refreshReport(reportId));
    }

    public HubReport getReport(long rewardId, String hubAddress) {
        return this.reportRepository.findByRewardIdAndHubAddress(rewardId, StringUtils.lowerCase((String)hubAddress)).map(HubReportMapper::fromEntity).orElse(null);
    }

    public HubReport saveReport(HubReportVerifiableData reportData) throws WomException {
        if (!reportData.isValid()) {
            throw new WomAuthorizationException("wom.invalidSignedMessage");
        }
        HubReport report = new HubReport((HubReportPayload)reportData);
        this.blockchainService.retrieveReportProperties(report);
        this.reportRepository.save(HubReportMapper.toEntity(report));
        this.listenerService.publishEvent(HUB_REPORT_SAVED, report.getReportId());
        return report;
    }

    public HubReport refreshReport(long reportId) {
        HubReportEntity hubReportEntity = this.reportRepository.findById(reportId).orElse(null);
        HubReport report = null;
        if (hubReportEntity != null) {
            report = HubReportMapper.fromEntity(hubReportEntity);
            this.blockchainService.retrieveReportProperties(report);
        } else {
            report = this.blockchainService.retrieveReportProperties(reportId);
        }
        this.reportRepository.save(HubReportMapper.toEntity(report));
        this.listenerService.publishEvent(HUB_REPORT_SAVED, reportId);
        return report;
    }

    public HubReport refreshReportFraud(long reportId) {
        HubReportEntity hubReportEntity = this.reportRepository.findById(reportId).orElse(null);
        if (hubReportEntity == null) {
            return null;
        }
        boolean reportFraud = this.blockchainService.isReportFraud(reportId);
        hubReportEntity.setFraud(reportFraud);
        this.reportRepository.save(hubReportEntity);
        this.listenerService.publishEvent(HUB_REPORT_SAVED, reportId);
        return HubReportMapper.fromEntity(hubReportEntity);
    }

    public void computeUemReward(HubReport report, double periodFixedGlobalIndex, double periodRewardAmount) {
        double uemRewardAmount = 0.0;
        if (!report.isFraud()) {
            uemRewardAmount = BigDecimal.valueOf(report.getFixedRewardIndex()).multiply(BigDecimal.valueOf(periodRewardAmount)).divide(BigDecimal.valueOf(periodFixedGlobalIndex), MathContext.DECIMAL128).doubleValue();
        }
        boolean changed = uemRewardAmount != report.getUemRewardAmount();
        report.setUemRewardAmount(uemRewardAmount);
        if (changed) {
            this.reportRepository.findById(report.getReportId()).ifPresent(hubReportEntity -> {
                hubReportEntity.setUemRewardAmount(report.getUemRewardAmount());
                this.reportRepository.save(hubReportEntity);
            });
        }
        this.computeEngagementScore(report.getReportId());
    }

    public double computeEngagementScore(long reportId) {
        HubReportEntity hubReportEntity = (HubReportEntity)this.reportRepository.findById(reportId).orElseThrow();
        boolean isRewardedPeriod = hubReportEntity.getSentDate().atZone(ZoneOffset.UTC).toLocalDate().isBefore(LocalDate.now().with(DayOfWeek.MONDAY));
        if (!isRewardedPeriod) {
            return 0.0;
        }
        if (hubReportEntity.getEngagementScore() > 0.0) {
            return hubReportEntity.getEngagementScore();
        }
        UemRewardEntity rewardEntity = (UemRewardEntity)this.rewardRepository.findById(hubReportEntity.getRewardId()).orElseThrow();
        BigDecimal averageIndex = BigDecimal.valueOf(rewardEntity.getFixedGlobalIndex()).divide(BigDecimal.valueOf(rewardEntity.getReportIds().size()), MathContext.DECIMAL128);
        hubReportEntity.setEngagementScore(BigDecimal.valueOf(hubReportEntity.getFixedRewardIndex()).multiply(BigDecimal.TEN).divide(averageIndex, MathContext.DECIMAL128).setScale(3, RoundingMode.HALF_EVEN).doubleValue());
        hubReportEntity = (HubReportEntity)this.reportRepository.save(hubReportEntity);
        return hubReportEntity.getEngagementScore();
    }
}

