/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.utils;

import io.meeds.deeds.common.constant.NoticePeriod;
import io.meeds.deeds.common.constant.TenantProvisioningStatus;
import io.meeds.deeds.common.constant.TenantStatus;
import io.meeds.deeds.common.constant.TransactionStatus;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.elasticsearch.model.DeedTenantLease;
import io.meeds.deeds.common.model.DeedTenantLeaseDTO;
import io.meeds.deeds.common.model.DeedTenantOfferDTO;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DeedTenantLeaseMapper {
    public static final Instant MAX_DATE_VALUE = Instant.ofEpochSecond(165241780471L);
    public static final String EVERYONE = "ALL";

    private DeedTenantLeaseMapper() {
    }

    public static DeedTenantLeaseDTO toDTO(DeedTenantLease deedTenantLease, TenantStatus tenantStatus, TenantProvisioningStatus provisioningStatus) {
        if (deedTenantLease == null) {
            return null;
        }
        boolean confirmed = deedTenantLease.isConfirmed();
        Instant endDate = confirmed ? deedTenantLease.getEndDate() : null;
        Instant startDate = confirmed ? deedTenantLease.getStartDate() : null;
        int noticePeriod = deedTenantLease.getNoticePeriod();
        return new DeedTenantLeaseDTO(deedTenantLease.getId(), deedTenantLease.getNftId(), deedTenantLease.getCity(), deedTenantLease.getCardType(), tenantStatus, provisioningStatus, deedTenantLease.getMonths(), deedTenantLease.getPaidMonths(), deedTenantLease.getMonthPaymentInProgress(), deedTenantLease.getOwner(), deedTenantLease.getManager(), deedTenantLease.getPaymentPeriodicity(), deedTenantLease.getAmount(), deedTenantLease.getAllDurationAmount(), deedTenantLease.getDistributedAmount(), NoticePeriod.fromMonths(noticePeriod), deedTenantLease.getOwnerMintingPercentage(), deedTenantLease.getMintingPower(), deedTenantLease.getTransactionStatus(), startDate, endDate, deedTenantLease.getNoticeDate(), deedTenantLease.getPaidRentsDate(), confirmed, deedTenantLease.isEndingLease(), deedTenantLease.getEndingLeaseAddress());
    }

    public static DeedTenantLease fromOffer(DeedTenantOfferDTO deedTenantOffer, DeedTenant deedTenant, String managerAddress, String managerEmail, String transactionHash) {
        if (deedTenantOffer == null || deedTenant == null) {
            return null;
        }
        List<String> pendingTransactions = StringUtils.isEmpty((CharSequence)transactionHash) ? Collections.emptyList() : Collections.singletonList(transactionHash.toLowerCase());
        TransactionStatus transactionStatus = StringUtils.isEmpty((CharSequence)transactionHash) ? TransactionStatus.VALIDATED : TransactionStatus.IN_PROGRESS;
        NoticePeriod noticePeriod = deedTenantOffer.getNoticePeriod();
        return new DeedTenantLease(deedTenantOffer.getOfferId(), deedTenantOffer.getNftId(), deedTenantOffer.getCity(), deedTenantOffer.getCardType(), (int)deedTenantOffer.getDuration().getPeriod().toTotalMonths(), 0, noticePeriod == null ? 0 : noticePeriod.getMonths(), 0, deedTenantOffer.getOwner(), managerAddress, managerEmail, Arrays.asList(managerAddress, deedTenant.getOwnerAddress()), deedTenantOffer.getPaymentPeriodicity(), deedTenantOffer.getAmount(), deedTenantOffer.getAllDurationAmount(), 0.0, deedTenantOffer.getOwnerMintingPercentage(), deedTenantOffer.getMintingPower(), pendingTransactions, transactionStatus, Instant.now(), MAX_DATE_VALUE, null, null, Instant.now(), false, true, false, null, 0L);
    }
}

