/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.elasticsearch.model.DeedTenantEvent;
import io.meeds.deeds.common.elasticsearch.storage.DeedTenantEventRepository;
import io.meeds.deeds.common.listener.EventListener;
import io.meeds.deeds.common.listerner.model.Event;
import io.meeds.deeds.common.listerner.model.EventSerialization;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.deeds.common.service.SettingService;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={ListenerService.class}, properties={"meeds.elasticsearch.listener.clientName=dApp", "meeds.elasticsearch.listener.events.cleanupHoursPeriodicity=1"})
class ListenerServiceTest {
    public static final String CLIENT_NAME = "dApp";
    public static final long CLEANUP_HOURS_PERIODICITY = 1L;
    private static final String EVENT_NAME = "test.event";
    private static final String OTHER_EVENT_NAME = "test.otherevent";
    private static final String LISENER_NAME = "listener.event";
    @MockBean
    private SettingService settingService;
    @MockBean
    private DeedTenantEventRepository deedTenantEventRepository;
    @Autowired
    private ListenerService listenerService;
    long persistentEventId;
    EventData eventData;
    ListenerTest eventListener;

    ListenerServiceTest() {
    }

    @BeforeEach
    public void setup() {
        ListenerService.LISTENERS.clear();
        ListenerService.EVENT_LISTENERS.clear();
        ListenerService.persistentFeatureEnabled = true;
        this.eventData = this.newData(2);
        this.eventListener = new ListenerTest();
        this.listenerService.addListener((EventListener)this.eventListener);
        Mockito.when((Object)this.deedTenantEventRepository.save((Object)((DeedTenantEvent)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            DeedTenantEvent persistedEvent = (DeedTenantEvent)invocation.getArgument(0, DeedTenantEvent.class);
            if (persistedEvent.getId() == null) {
                persistedEvent.setId(String.valueOf(++this.persistentEventId));
            }
            return persistedEvent;
        });
    }

    @Test
    void testPublishEvent() {
        this.listenerService.publishEvent("otherEvent", (Object)this.eventData);
        Assertions.assertEquals((int)0, (int)this.eventListener.getEventCount());
        Assertions.assertNull((Object)this.eventListener.getEventData());
        Assertions.assertNull((Object)this.eventListener.getEventName());
        this.listenerService.publishEvent(EVENT_NAME, (Object)this.eventData);
        Assertions.assertEquals((int)1, (int)this.eventListener.getEventCount());
        Assertions.assertEquals((Object)this.eventData, (Object)this.eventListener.getEventData());
        Assertions.assertEquals((Object)EVENT_NAME, (Object)this.eventListener.getEventName());
    }

    @Test
    void testRemoveListener() {
        this.listenerService.removeListsner(LISENER_NAME);
        this.listenerService.publishEvent(EVENT_NAME, (Object)this.eventData);
        Assertions.assertEquals((int)0, (int)this.eventListener.getEventCount());
        Assertions.assertNull((Object)this.eventListener.getEventData());
        Assertions.assertNull((Object)this.eventListener.getEventName());
        this.listenerService.publishEvent(OTHER_EVENT_NAME, (Object)this.eventData);
        Assertions.assertEquals((int)0, (int)this.eventListener.getEventCount());
        Assertions.assertNull((Object)this.eventListener.getEventData());
        Assertions.assertNull((Object)this.eventListener.getEventName());
    }

    @Test
    void testRemoveListenerByEventName() {
        this.listenerService.removeListsner(EVENT_NAME, LISENER_NAME);
        this.listenerService.publishEvent(EVENT_NAME, (Object)this.eventData);
        Assertions.assertEquals((int)0, (int)this.eventListener.getEventCount());
        Assertions.assertNull((Object)this.eventListener.getEventData());
        Assertions.assertNull((Object)this.eventListener.getEventName());
        this.listenerService.publishEvent(OTHER_EVENT_NAME, (Object)this.eventData);
        Assertions.assertEquals((int)1, (int)this.eventListener.getEventCount());
        Assertions.assertEquals((Object)this.eventData, (Object)this.eventListener.getEventData());
        Assertions.assertEquals((Object)OTHER_EVENT_NAME, (Object)this.eventListener.getEventName());
    }

    @Test
    void testTriggerElasticSearchEvents() throws Exception {
        long currentTimeMillis = System.currentTimeMillis();
        Instant now = Instant.ofEpochMilli(currentTimeMillis);
        String lastScannedValue = String.valueOf(currentTimeMillis);
        Mockito.when((Object)this.settingService.get("ES-LAST-SCANNED-DATE-dApp")).thenReturn((Object)lastScannedValue);
        Instant eventDate = now.plusSeconds(5L);
        List consumers = Collections.emptyList();
        String objectJson = EventSerialization.OBJECT_MAPPER.writeValueAsString((Object)new Event(EVENT_NAME, (Object)this.eventData, this.eventData.getClass().getName()));
        List<DeedTenantEvent> events = Collections.singletonList(new DeedTenantEvent(EVENT_NAME, objectJson, consumers, eventDate));
        Mockito.when((Object)this.deedTenantEventRepository.findByDateGreaterThanEqualAndConsumersNotOrderByDateAsc(now, CLIENT_NAME)).thenReturn(events);
        Assertions.assertEquals((int)0, (int)this.eventListener.getEventCount());
        Assertions.assertNull((Object)this.eventListener.getEventData());
        Assertions.assertNull((Object)this.eventListener.getEventName());
        this.listenerService.triggerElasticSearchEvents();
        Assertions.assertEquals((int)1, (int)this.eventListener.getEventCount());
        Assertions.assertEquals((Object)this.eventData, (Object)this.eventListener.getEventData());
        Assertions.assertEquals((Object)EVENT_NAME, (Object)this.eventListener.getEventName());
        ((DeedTenantEventRepository)Mockito.verify((Object)this.deedTenantEventRepository, (VerificationMode)Mockito.times((int)1))).save((Object)((DeedTenantEvent)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<DeedTenantEvent>(this){

            public boolean matches(DeedTenantEvent deedTenantEvent) {
                return deedTenantEvent != null && deedTenantEvent.getConsumers().contains(ListenerServiceTest.CLIENT_NAME);
            }
        })));
    }

    @Test
    void testCleanupElasticsearchEvents() throws Exception {
        long currentTimeMillis = System.currentTimeMillis();
        Instant now = Instant.ofEpochMilli(currentTimeMillis);
        String lastScannedValue = String.valueOf(currentTimeMillis);
        Mockito.when((Object)this.settingService.get("ES-LAST-SCANNED-DATE-dApp")).thenReturn((Object)lastScannedValue);
        this.listenerService.cleanupElasticsearchEvents();
        ((DeedTenantEventRepository)Mockito.verify((Object)this.deedTenantEventRepository, (VerificationMode)Mockito.times((int)1))).deleteByDateLessThan(now.minus(1L, ChronoUnit.HOURS));
    }

    private EventData newData(int data) {
        return new EventData(data);
    }

    public static class EventData {
        private int data;

        @Generated
        public int getData() {
            return this.data;
        }

        @Generated
        public void setData(int data) {
            this.data = data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventData)) {
                return false;
            }
            EventData other = (EventData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getData() == other.getData();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EventData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getData();
            return result;
        }

        @Generated
        public String toString() {
            return "ListenerServiceTest.EventData(data=" + this.getData() + ")";
        }

        @Generated
        public EventData(int data) {
            this.data = data;
        }

        @Generated
        public EventData() {
        }
    }

    public static class ListenerTest
    implements EventListener<EventData> {
        private int eventCount;
        private String eventName;
        private EventData eventData;

        public void onEvent(String name, EventData data) throws Exception {
            ++this.eventCount;
            this.eventName = name;
            this.eventData = data;
        }

        public List<String> getSupportedEvents() {
            return Arrays.asList(ListenerServiceTest.EVENT_NAME, ListenerServiceTest.OTHER_EVENT_NAME);
        }

        public String getName() {
            return ListenerServiceTest.LISENER_NAME;
        }

        @Generated
        public int getEventCount() {
            return this.eventCount;
        }

        @Generated
        public String getEventName() {
            return this.eventName;
        }

        @Generated
        public EventData getEventData() {
            return this.eventData;
        }
    }
}

