package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 4.8.9.
 */
@SuppressWarnings("rawtypes")
public class Deed extends Contract {
    public static final String BINARY = "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";

    public static final String FUNC_ADDMANAGER = "addManager";

    public static final String FUNC_ADDSTRATEGY = "addStrategy";

    public static final String FUNC_BALANCEOF = "balanceOf";

    public static final String FUNC_BALANCEOFBATCH = "balanceOfBatch";

    public static final String FUNC_CARDTYPE = "cardType";

    public static final String FUNC_CITYINDEX = "cityIndex";

    public static final String FUNC_CREATE = "create";

    public static final String FUNC_CREATORS = "creators";

    public static final String FUNC_ENDUSINGNFT = "endUsingNFT";

    public static final String FUNC_GETSTRATEGYUSECOUNT = "getStrategyUseCount";

    public static final String FUNC_GETTOTALUSECOUNT = "getTotalUseCount";

    public static final String FUNC_ISAPPROVEDFORALL = "isApprovedForAll";

    public static final String FUNC_ISMANAGER = "isManager";

    public static final String FUNC_ISOWNER = "isOwner";

    public static final String FUNC_ISSTRATEGY = "isStrategy";

    public static final String FUNC_MAXSUPPLY = "maxSupply";

    public static final String FUNC_NAME = "name";

    public static final String FUNC_NFTSOF = "nftsOf";

    public static final String FUNC_OWNER = "owner";

    public static final String FUNC_PROXYREGISTRYADDRESS = "proxyRegistryAddress";

    public static final String FUNC_REMOVEMANAGER = "removeManager";

    public static final String FUNC_REMOVESTRATEGY = "removeStrategy";

    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";

    public static final String FUNC_SAFEBATCHTRANSFERFROM = "safeBatchTransferFrom";

    public static final String FUNC_SAFETRANSFERFROM = "safeTransferFrom";

    public static final String FUNC_SETAPPROVALFORALL = "setApprovalForAll";

    public static final String FUNC_STARTUSINGNFT = "startUsingNFT";

    public static final String FUNC_SUPPORTSINTERFACE = "supportsInterface";

    public static final String FUNC_SYMBOL = "symbol";

    public static final String FUNC_TOKENCITYINDEX = "tokenCityIndex";

    public static final String FUNC_TOKENMAXSUPPLY = "tokenMaxSupply";

    public static final String FUNC_TOKENSUPPLY = "tokenSupply";

    public static final String FUNC_TOKENTYPE = "tokenType";

    public static final String FUNC_TOKENURI = "tokenUri";

    public static final String FUNC_totalSupply = "totalSupply";

    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";

    public static final String FUNC_URI = "uri";

    public static final Event APPROVALFORALL_EVENT = new Event("ApprovalForAll", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Bool>() {}));
    ;

    public static final Event ENDEDUSINGNFT_EVENT = new Event("EndedUsingNFT", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>(true) {}, new TypeReference<Address>(true) {}));
    ;

    public static final Event MANAGERADDED_EVENT = new Event("ManagerAdded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event MANAGERREMOVED_EVENT = new Event("ManagerRemoved", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}));
    ;

    public static final Event STARTEDUSINGNFT_EVENT = new Event("StartedUsingNFT", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>(true) {}, new TypeReference<Address>(true) {}));
    ;

    public static final Event STRATEGYADDED_EVENT = new Event("StrategyAdded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event STRATEGYREMOVED_EVENT = new Event("StrategyRemoved", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event TRANSFERBATCH_EVENT = new Event("TransferBatch", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<DynamicArray<Uint256>>() {}, new TypeReference<DynamicArray<Uint256>>() {}));
    ;

    public static final Event TRANSFERSINGLE_EVENT = new Event("TransferSingle", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event URI_EVENT = new Event("URI", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}, new TypeReference<Uint256>(true) {}));
    ;

    @Deprecated
    protected Deed(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected Deed(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected Deed(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected Deed(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public List<ApprovalForAllEventResponse> getApprovalForAllEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(APPROVALFORALL_EVENT, transactionReceipt);
        ArrayList<ApprovalForAllEventResponse> responses = new ArrayList<ApprovalForAllEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._owner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._operator = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._approved = (Boolean) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalForAllEventResponse> approvalForAllEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, ApprovalForAllEventResponse>() {
            @Override
            public ApprovalForAllEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(APPROVALFORALL_EVENT, log);
                ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
                typedResponse.log = log;
                typedResponse._owner = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._operator = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._approved = (Boolean) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalForAllEventResponse> approvalForAllEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(APPROVALFORALL_EVENT));
        return approvalForAllEventFlowable(filter);
    }

    public List<EndedUsingNFTEventResponse> getEndedUsingNFTEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(ENDEDUSINGNFT_EVENT, transactionReceipt);
        ArrayList<EndedUsingNFTEventResponse> responses = new ArrayList<EndedUsingNFTEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            EndedUsingNFTEventResponse typedResponse = new EndedUsingNFTEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.id = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
            typedResponse.strategy = (String) eventValues.getIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<EndedUsingNFTEventResponse> endedUsingNFTEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, EndedUsingNFTEventResponse>() {
            @Override
            public EndedUsingNFTEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(ENDEDUSINGNFT_EVENT, log);
                EndedUsingNFTEventResponse typedResponse = new EndedUsingNFTEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.id = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
                typedResponse.strategy = (String) eventValues.getIndexedValues().get(2).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<EndedUsingNFTEventResponse> endedUsingNFTEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(ENDEDUSINGNFT_EVENT));
        return endedUsingNFTEventFlowable(filter);
    }

    public List<ManagerAddedEventResponse> getManagerAddedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(MANAGERADDED_EVENT, transactionReceipt);
        ArrayList<ManagerAddedEventResponse> responses = new ArrayList<ManagerAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, ManagerAddedEventResponse>() {
            @Override
            public ManagerAddedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(MANAGERADDED_EVENT, log);
                ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MANAGERADDED_EVENT));
        return managerAddedEventFlowable(filter);
    }

    public List<ManagerRemovedEventResponse> getManagerRemovedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(MANAGERREMOVED_EVENT, transactionReceipt);
        ArrayList<ManagerRemovedEventResponse> responses = new ArrayList<ManagerRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, ManagerRemovedEventResponse>() {
            @Override
            public ManagerRemovedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(MANAGERREMOVED_EVENT, log);
                ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MANAGERREMOVED_EVENT));
        return managerRemovedEventFlowable(filter);
    }

    public List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.newOwner = (String) eventValues.getIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, OwnershipTransferredEventResponse>() {
            @Override
            public OwnershipTransferredEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, log);
                OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
                typedResponse.log = log;
                typedResponse.previousOwner = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.newOwner = (String) eventValues.getIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(OWNERSHIPTRANSFERRED_EVENT));
        return ownershipTransferredEventFlowable(filter);
    }

    public List<StartedUsingNFTEventResponse> getStartedUsingNFTEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(STARTEDUSINGNFT_EVENT, transactionReceipt);
        ArrayList<StartedUsingNFTEventResponse> responses = new ArrayList<StartedUsingNFTEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            StartedUsingNFTEventResponse typedResponse = new StartedUsingNFTEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.id = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
            typedResponse.strategy = (String) eventValues.getIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<StartedUsingNFTEventResponse> startedUsingNFTEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, StartedUsingNFTEventResponse>() {
            @Override
            public StartedUsingNFTEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(STARTEDUSINGNFT_EVENT, log);
                StartedUsingNFTEventResponse typedResponse = new StartedUsingNFTEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.id = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
                typedResponse.strategy = (String) eventValues.getIndexedValues().get(2).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<StartedUsingNFTEventResponse> startedUsingNFTEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(STARTEDUSINGNFT_EVENT));
        return startedUsingNFTEventFlowable(filter);
    }

    public List<StrategyAddedEventResponse> getStrategyAddedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(STRATEGYADDED_EVENT, transactionReceipt);
        ArrayList<StrategyAddedEventResponse> responses = new ArrayList<StrategyAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            StrategyAddedEventResponse typedResponse = new StrategyAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<StrategyAddedEventResponse> strategyAddedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, StrategyAddedEventResponse>() {
            @Override
            public StrategyAddedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(STRATEGYADDED_EVENT, log);
                StrategyAddedEventResponse typedResponse = new StrategyAddedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<StrategyAddedEventResponse> strategyAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(STRATEGYADDED_EVENT));
        return strategyAddedEventFlowable(filter);
    }

    public List<StrategyRemovedEventResponse> getStrategyRemovedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(STRATEGYREMOVED_EVENT, transactionReceipt);
        ArrayList<StrategyRemovedEventResponse> responses = new ArrayList<StrategyRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            StrategyRemovedEventResponse typedResponse = new StrategyRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<StrategyRemovedEventResponse> strategyRemovedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, StrategyRemovedEventResponse>() {
            @Override
            public StrategyRemovedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(STRATEGYREMOVED_EVENT, log);
                StrategyRemovedEventResponse typedResponse = new StrategyRemovedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<StrategyRemovedEventResponse> strategyRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(STRATEGYREMOVED_EVENT));
        return strategyRemovedEventFlowable(filter);
    }

    public List<TransferBatchEventResponse> getTransferBatchEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFERBATCH_EVENT, transactionReceipt);
        ArrayList<TransferBatchEventResponse> responses = new ArrayList<TransferBatchEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferBatchEventResponse typedResponse = new TransferBatchEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._operator = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._from = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._to = (String) eventValues.getIndexedValues().get(2).getValue();
            typedResponse._ids = (List<BigInteger>) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse._amounts = (List<BigInteger>) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferBatchEventResponse> transferBatchEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, TransferBatchEventResponse>() {
            @Override
            public TransferBatchEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFERBATCH_EVENT, log);
                TransferBatchEventResponse typedResponse = new TransferBatchEventResponse();
                typedResponse.log = log;
                typedResponse._operator = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._from = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._to = (String) eventValues.getIndexedValues().get(2).getValue();
                typedResponse._ids = (List<BigInteger>) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse._amounts = (List<BigInteger>) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferBatchEventResponse> transferBatchEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFERBATCH_EVENT));
        return transferBatchEventFlowable(filter);
    }

    public List<TransferSingleEventResponse> getTransferSingleEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFERSINGLE_EVENT, transactionReceipt);
        ArrayList<TransferSingleEventResponse> responses = new ArrayList<TransferSingleEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferSingleEventResponse typedResponse = new TransferSingleEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._operator = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._from = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._to = (String) eventValues.getIndexedValues().get(2).getValue();
            typedResponse._id = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse._amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferSingleEventResponse> transferSingleEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, TransferSingleEventResponse>() {
            @Override
            public TransferSingleEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFERSINGLE_EVENT, log);
                TransferSingleEventResponse typedResponse = new TransferSingleEventResponse();
                typedResponse.log = log;
                typedResponse._operator = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._from = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._to = (String) eventValues.getIndexedValues().get(2).getValue();
                typedResponse._id = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse._amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferSingleEventResponse> transferSingleEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFERSINGLE_EVENT));
        return transferSingleEventFlowable(filter);
    }

    public List<URIEventResponse> getURIEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(URI_EVENT, transactionReceipt);
        ArrayList<URIEventResponse> responses = new ArrayList<URIEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            URIEventResponse typedResponse = new URIEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._id = (BigInteger) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._amount = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<URIEventResponse> uRIEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, URIEventResponse>() {
            @Override
            public URIEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(URI_EVENT, log);
                URIEventResponse typedResponse = new URIEventResponse();
                typedResponse.log = log;
                typedResponse._id = (BigInteger) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._amount = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<URIEventResponse> uRIEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(URI_EVENT));
        return uRIEventFlowable(filter);
    }

    public RemoteFunctionCall<TransactionReceipt> addManager(String account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_ADDMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> addStrategy(String account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_ADDSTRATEGY, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> balanceOf(String _owner, BigInteger _id) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOF, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _owner), 
                new org.web3j.abi.datatypes.generated.Uint256(_id)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<List> balanceOfBatch(List<String> _owners, List<BigInteger> _ids) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOFBATCH, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Address>(
                        org.web3j.abi.datatypes.Address.class,
                        org.web3j.abi.Utils.typeMap(_owners, org.web3j.abi.datatypes.Address.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                        org.web3j.abi.datatypes.generated.Uint256.class,
                        org.web3j.abi.Utils.typeMap(_ids, org.web3j.abi.datatypes.generated.Uint256.class))), 
                Arrays.<TypeReference<?>>asList(new TypeReference<DynamicArray<Uint256>>() {}));
        return new RemoteFunctionCall<List>(function,
                new Callable<List>() {
                    @Override
                    @SuppressWarnings("unchecked")
                    public List call() throws Exception {
                        List<Type> result = (List<Type>) executeCallSingleValueReturn(function, List.class);
                        return convertToNative(result);
                    }
                });
    }

    public RemoteFunctionCall<BigInteger> cardType(BigInteger _id) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CARDTYPE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_id)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> cityIndex(BigInteger _id) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CITYINDEX, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_id)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> create(String _initialOwner, BigInteger _initialSupply, BigInteger _maxSupply, String _uri, BigInteger _cityIndex, BigInteger _type, byte[] _data) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_CREATE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _initialOwner), 
                new org.web3j.abi.datatypes.generated.Uint256(_initialSupply), 
                new org.web3j.abi.datatypes.generated.Uint256(_maxSupply), 
                new org.web3j.abi.datatypes.Utf8String(_uri), 
                new org.web3j.abi.datatypes.generated.Uint8(_cityIndex), 
                new org.web3j.abi.datatypes.generated.Uint8(_type), 
                new org.web3j.abi.datatypes.DynamicBytes(_data)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> creators(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CREATORS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> endUsingNFT(String _account, BigInteger _id) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_ENDUSINGNFT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _account), 
                new org.web3j.abi.datatypes.generated.Uint256(_id)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> getStrategyUseCount(String _account, BigInteger _id, String _strategy) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETSTRATEGYUSECOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _account), 
                new org.web3j.abi.datatypes.generated.Uint256(_id), 
                new org.web3j.abi.datatypes.Address(160, _strategy)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> getTotalUseCount(String _account, BigInteger _id) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETTOTALUSECOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _account), 
                new org.web3j.abi.datatypes.generated.Uint256(_id)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Boolean> isApprovedForAll(String _owner, String _operator) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISAPPROVEDFORALL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _owner), 
                new org.web3j.abi.datatypes.Address(160, _operator)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isManager(String account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISOWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isStrategy(String account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISSTRATEGY, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<BigInteger> maxSupply(BigInteger _id) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_MAXSUPPLY, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_id)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> name() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_NAME, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<List> nftsOf(String _account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_NFTSOF, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _account)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<DynamicArray<Uint256>>() {}));
        return new RemoteFunctionCall<List>(function,
                new Callable<List>() {
                    @Override
                    @SuppressWarnings("unchecked")
                    public List call() throws Exception {
                        List<Type> result = (List<Type>) executeCallSingleValueReturn(function, List.class);
                        return convertToNative(result);
                    }
                });
    }

    public RemoteFunctionCall<String> owner() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_OWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> proxyRegistryAddress() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_PROXYREGISTRYADDRESS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> removeManager(String account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_REMOVEMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> removeStrategy(String account) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_REMOVESTRATEGY, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_RENOUNCEOWNERSHIP, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> safeBatchTransferFrom(String _from, String _to, List<BigInteger> _ids, List<BigInteger> _amounts, byte[] _data) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_SAFEBATCHTRANSFERFROM, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _from), 
                new org.web3j.abi.datatypes.Address(160, _to), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                        org.web3j.abi.datatypes.generated.Uint256.class,
                        org.web3j.abi.Utils.typeMap(_ids, org.web3j.abi.datatypes.generated.Uint256.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                        org.web3j.abi.datatypes.generated.Uint256.class,
                        org.web3j.abi.Utils.typeMap(_amounts, org.web3j.abi.datatypes.generated.Uint256.class)), 
                new org.web3j.abi.datatypes.DynamicBytes(_data)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> safeTransferFrom(String _from, String _to, BigInteger _id, BigInteger _amount, byte[] _data) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_SAFETRANSFERFROM, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _from), 
                new org.web3j.abi.datatypes.Address(160, _to), 
                new org.web3j.abi.datatypes.generated.Uint256(_id), 
                new org.web3j.abi.datatypes.generated.Uint256(_amount), 
                new org.web3j.abi.datatypes.DynamicBytes(_data)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setApprovalForAll(String _operator, Boolean _approved) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_SETAPPROVALFORALL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _operator), 
                new org.web3j.abi.datatypes.Bool(_approved)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> startUsingNFT(String _account, BigInteger _id) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_STARTUSINGNFT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _account), 
                new org.web3j.abi.datatypes.generated.Uint256(_id)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> supportsInterface(byte[] _interfaceID) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SUPPORTSINTERFACE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Bytes4(_interfaceID)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> symbol() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SYMBOL, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> tokenCityIndex(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENCITYINDEX, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> tokenMaxSupply(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENMAXSUPPLY, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> tokenSupply(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENSUPPLY, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> tokenType(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENTYPE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> tokenUri(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENURI, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> totalSupply() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_totalSupply, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> totalSupply(BigInteger _id) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_totalSupply, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_id)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_TRANSFEROWNERSHIP, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, newOwner)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> uri(BigInteger _id) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_URI, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_id)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    @Deprecated
    public static Deed load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new Deed(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static Deed load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new Deed(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static Deed load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new Deed(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static Deed load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new Deed(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<Deed> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String _proxyRegistryAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _proxyRegistryAddress)));
        return deployRemoteCall(Deed.class, web3j, credentials, contractGasProvider, BINARY, encodedConstructor);
    }

    public static RemoteCall<Deed> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String _proxyRegistryAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _proxyRegistryAddress)));
        return deployRemoteCall(Deed.class, web3j, transactionManager, contractGasProvider, BINARY, encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<Deed> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String _proxyRegistryAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _proxyRegistryAddress)));
        return deployRemoteCall(Deed.class, web3j, credentials, gasPrice, gasLimit, BINARY, encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<Deed> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String _proxyRegistryAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _proxyRegistryAddress)));
        return deployRemoteCall(Deed.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, encodedConstructor);
    }

    public static class ApprovalForAllEventResponse extends BaseEventResponse {
        public String _owner;

        public String _operator;

        public Boolean _approved;
    }

    public static class EndedUsingNFTEventResponse extends BaseEventResponse {
        public String account;

        public BigInteger id;

        public String strategy;
    }

    public static class ManagerAddedEventResponse extends BaseEventResponse {
        public String account;
    }

    public static class ManagerRemovedEventResponse extends BaseEventResponse {
        public String account;
    }

    public static class OwnershipTransferredEventResponse extends BaseEventResponse {
        public String previousOwner;

        public String newOwner;
    }

    public static class StartedUsingNFTEventResponse extends BaseEventResponse {
        public String account;

        public BigInteger id;

        public String strategy;
    }

    public static class StrategyAddedEventResponse extends BaseEventResponse {
        public String account;
    }

    public static class StrategyRemovedEventResponse extends BaseEventResponse {
        public String account;
    }

    public static class TransferBatchEventResponse extends BaseEventResponse {
        public String _operator;

        public String _from;

        public String _to;

        public List<BigInteger> _ids;

        public List<BigInteger> _amounts;
    }

    public static class TransferSingleEventResponse extends BaseEventResponse {
        public String _operator;

        public String _from;

        public String _to;

        public BigInteger _id;

        public BigInteger _amount;
    }

    public static class URIEventResponse extends BaseEventResponse {
        public BigInteger _id;

        public String _amount;
    }
}
