/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes4;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class ERC1155Tradable
extends Contract {
    public static final String BINARY = "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";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_BALANCEOFBATCH = "balanceOfBatch";
    public static final String FUNC_CARDTYPE = "cardType";
    public static final String FUNC_CITYINDEX = "cityIndex";
    public static final String FUNC_CREATE = "create";
    public static final String FUNC_CREATORS = "creators";
    public static final String FUNC_ISAPPROVEDFORALL = "isApprovedForAll";
    public static final String FUNC_ISOWNER = "isOwner";
    public static final String FUNC_MAXSUPPLY = "maxSupply";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_PROXYREGISTRYADDRESS = "proxyRegistryAddress";
    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";
    public static final String FUNC_SAFEBATCHTRANSFERFROM = "safeBatchTransferFrom";
    public static final String FUNC_SAFETRANSFERFROM = "safeTransferFrom";
    public static final String FUNC_SETAPPROVALFORALL = "setApprovalForAll";
    public static final String FUNC_SUPPORTSINTERFACE = "supportsInterface";
    public static final String FUNC_SYMBOL = "symbol";
    public static final String FUNC_TOKENCITYINDEX = "tokenCityIndex";
    public static final String FUNC_TOKENMAXSUPPLY = "tokenMaxSupply";
    public static final String FUNC_TOKENSUPPLY = "tokenSupply";
    public static final String FUNC_TOKENTYPE = "tokenType";
    public static final String FUNC_TOKENURI = "tokenUri";
    public static final String FUNC_TOTALSUPPLY = "totalSupply";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String FUNC_URI = "uri";
    public static final Event APPROVALFORALL_EVENT = new Event("ApprovalForAll", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Bool>(){}));
    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}));
    public static final Event TRANSFERBATCH_EVENT = new Event("TransferBatch", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<DynamicArray<Uint256>>(){}, new TypeReference<DynamicArray<Uint256>>(){}));
    public static final Event TRANSFERSINGLE_EVENT = new Event("TransferSingle", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}));
    public static final Event URI_EVENT = new Event("URI", Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Uint256>(true){}));

    @Deprecated
    protected ERC1155Tradable(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected ERC1155Tradable(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected ERC1155Tradable(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected ERC1155Tradable(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public List<ApprovalForAllEventResponse> getApprovalForAllEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(APPROVALFORALL_EVENT, transactionReceipt);
        ArrayList<ApprovalForAllEventResponse> responses = new ArrayList<ApprovalForAllEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._approved = (Boolean)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalForAllEventResponse> approvalForAllEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ApprovalForAllEventResponse>(){

            public ApprovalForAllEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERC1155Tradable.this.extractEventParametersWithLog(APPROVALFORALL_EVENT, log);
                ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
                typedResponse.log = log;
                typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._approved = (Boolean)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalForAllEventResponse> approvalForAllEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVALFORALL_EVENT));
        return this.approvalForAllEventFlowable(filter);
    }

    public List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, OwnershipTransferredEventResponse>(){

            public OwnershipTransferredEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERC1155Tradable.this.extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, log);
                OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
                typedResponse.log = log;
                typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OWNERSHIPTRANSFERRED_EVENT));
        return this.ownershipTransferredEventFlowable(filter);
    }

    public List<TransferBatchEventResponse> getTransferBatchEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFERBATCH_EVENT, transactionReceipt);
        ArrayList<TransferBatchEventResponse> responses = new ArrayList<TransferBatchEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferBatchEventResponse typedResponse = new TransferBatchEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
            typedResponse._ids = (List)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse._amounts = (List)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferBatchEventResponse> transferBatchEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferBatchEventResponse>(){

            public TransferBatchEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERC1155Tradable.this.extractEventParametersWithLog(TRANSFERBATCH_EVENT, log);
                TransferBatchEventResponse typedResponse = new TransferBatchEventResponse();
                typedResponse.log = log;
                typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
                typedResponse._ids = (List)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse._amounts = (List)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferBatchEventResponse> transferBatchEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFERBATCH_EVENT));
        return this.transferBatchEventFlowable(filter);
    }

    public List<TransferSingleEventResponse> getTransferSingleEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFERSINGLE_EVENT, transactionReceipt);
        ArrayList<TransferSingleEventResponse> responses = new ArrayList<TransferSingleEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferSingleEventResponse typedResponse = new TransferSingleEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
            typedResponse._id = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse._amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferSingleEventResponse> transferSingleEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferSingleEventResponse>(){

            public TransferSingleEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERC1155Tradable.this.extractEventParametersWithLog(TRANSFERSINGLE_EVENT, log);
                TransferSingleEventResponse typedResponse = new TransferSingleEventResponse();
                typedResponse.log = log;
                typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
                typedResponse._id = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse._amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferSingleEventResponse> transferSingleEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFERSINGLE_EVENT));
        return this.transferSingleEventFlowable(filter);
    }

    public List<URIEventResponse> getURIEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(URI_EVENT, transactionReceipt);
        ArrayList<URIEventResponse> responses = new ArrayList<URIEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            URIEventResponse typedResponse = new URIEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._amount = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<URIEventResponse> uRIEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, URIEventResponse>(){

            public URIEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERC1155Tradable.this.extractEventParametersWithLog(URI_EVENT, log);
                URIEventResponse typedResponse = new URIEventResponse();
                typedResponse.log = log;
                typedResponse._id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._amount = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<URIEventResponse> uRIEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)URI_EVENT));
        return this.uRIEventFlowable(filter);
    }

    public RemoteFunctionCall<BigInteger> balanceOf(String _owner, BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOF, Arrays.asList(new Address(160, _owner), new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<List> balanceOfBatch(List<String> _owners, List<BigInteger> _ids) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOFBATCH, Arrays.asList(new DynamicArray(Address.class, Utils.typeMap(_owners, Address.class)), new DynamicArray(Uint256.class, Utils.typeMap(_ids, Uint256.class))), Arrays.asList(new TypeReference<DynamicArray<Uint256>>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<List>(){

            @Override
            public List call() throws Exception {
                List result = (List)ERC1155Tradable.this.executeCallSingleValueReturn(function, List.class);
                return ERC1155Tradable.convertToNative((List)result);
            }
        });
    }

    public RemoteFunctionCall<BigInteger> cardType(BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CARDTYPE, Arrays.asList(new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> cityIndex(BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CITYINDEX, Arrays.asList(new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> create(String _initialOwner, BigInteger _initialSupply, BigInteger _maxSupply, String _uri, BigInteger _cityIndex, BigInteger _type, byte[] _data) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CREATE, Arrays.asList(new Address(160, _initialOwner), new Uint256(_initialSupply), new Uint256(_maxSupply), new Utf8String(_uri), new Uint8(_cityIndex), new Uint8(_type), new DynamicBytes(_data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> creators(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CREATORS, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<Boolean> isApprovedForAll(String _owner, String _operator) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISAPPROVEDFORALL, Arrays.asList(new Address(160, _owner), new Address(160, _operator)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISOWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<BigInteger> maxSupply(BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_MAXSUPPLY, Arrays.asList(new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> name() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_NAME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> owner() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> proxyRegistryAddress() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_PROXYREGISTRYADDRESS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_RENOUNCEOWNERSHIP, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> safeBatchTransferFrom(String _from, String _to, List<BigInteger> _ids, List<BigInteger> _amounts, byte[] _data) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SAFEBATCHTRANSFERFROM, Arrays.asList(new Address(160, _from), new Address(160, _to), new DynamicArray(Uint256.class, Utils.typeMap(_ids, Uint256.class)), new DynamicArray(Uint256.class, Utils.typeMap(_amounts, Uint256.class)), new DynamicBytes(_data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> safeTransferFrom(String _from, String _to, BigInteger _id, BigInteger _amount, byte[] _data) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SAFETRANSFERFROM, Arrays.asList(new Address(160, _from), new Address(160, _to), new Uint256(_id), new Uint256(_amount), new DynamicBytes(_data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setApprovalForAll(String _operator, Boolean _approved) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETAPPROVALFORALL, Arrays.asList(new Address(160, _operator), new Bool(_approved)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> supportsInterface(byte[] _interfaceID) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SUPPORTSINTERFACE, Arrays.asList(new Bytes4(_interfaceID)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> symbol() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SYMBOL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> tokenCityIndex(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENCITYINDEX, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> tokenMaxSupply(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENMAXSUPPLY, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> tokenSupply(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENSUPPLY, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> tokenType(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENTYPE, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> tokenUri(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOKENURI, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> totalSupply(BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOTALSUPPLY, Arrays.asList(new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(160, newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> uri(BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_URI, Arrays.asList(new Uint256(_id)), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    @Deprecated
    public static ERC1155Tradable load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERC1155Tradable(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static ERC1155Tradable load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERC1155Tradable(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static ERC1155Tradable load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new ERC1155Tradable(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static ERC1155Tradable load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new ERC1155Tradable(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<ERC1155Tradable> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String _name, String _symbol, String _proxyRegistryAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Utf8String(_name), new Utf8String(_symbol), new Address(160, _proxyRegistryAddress)));
        return ERC1155Tradable.deployRemoteCall(ERC1155Tradable.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    public static RemoteCall<ERC1155Tradable> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String _name, String _symbol, String _proxyRegistryAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Utf8String(_name), new Utf8String(_symbol), new Address(160, _proxyRegistryAddress)));
        return ERC1155Tradable.deployRemoteCall(ERC1155Tradable.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<ERC1155Tradable> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String _name, String _symbol, String _proxyRegistryAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Utf8String(_name), new Utf8String(_symbol), new Address(160, _proxyRegistryAddress)));
        return ERC1155Tradable.deployRemoteCall(ERC1155Tradable.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<ERC1155Tradable> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String _name, String _symbol, String _proxyRegistryAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Utf8String(_name), new Utf8String(_symbol), new Address(160, _proxyRegistryAddress)));
        return ERC1155Tradable.deployRemoteCall(ERC1155Tradable.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    public static class URIEventResponse
    extends BaseEventResponse {
        public BigInteger _id;
        public String _amount;
    }

    public static class TransferSingleEventResponse
    extends BaseEventResponse {
        public String _operator;
        public String _from;
        public String _to;
        public BigInteger _id;
        public BigInteger _amount;
    }

    public static class TransferBatchEventResponse
    extends BaseEventResponse {
        public String _operator;
        public String _from;
        public String _to;
        public List<BigInteger> _ids;
        public List<BigInteger> _amounts;
    }

    public static class OwnershipTransferredEventResponse
    extends BaseEventResponse {
        public String previousOwner;
        public String newOwner;
    }

    public static class ApprovalForAllEventResponse
    extends BaseEventResponse {
        public String _owner;
        public String _operator;
        public Boolean _approved;
    }
}

