/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class StrategyHandler
extends Contract {
    public static final String BINARY = "";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_BALANCEOFBATCH = "balanceOfBatch";
    public static final String FUNC_ENDUSINGNFT = "endUsingNFT";
    public static final String FUNC_GETSTRATEGYUSECOUNT = "getStrategyUseCount";
    public static final String FUNC_GETTOTALUSECOUNT = "getTotalUseCount";
    public static final String FUNC_ISAPPROVEDFORALL = "isApprovedForAll";
    public static final String FUNC_SAFEBATCHTRANSFERFROM = "safeBatchTransferFrom";
    public static final String FUNC_SAFETRANSFERFROM = "safeTransferFrom";
    public static final String FUNC_SETAPPROVALFORALL = "setApprovalForAll";
    public static final String FUNC_STARTUSINGNFT = "startUsingNFT";
    public static final Event APPROVALFORALL_EVENT = new Event("ApprovalForAll", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Bool>(){}));
    public static final Event TRANSFERBATCH_EVENT = new Event("TransferBatch", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<DynamicArray<Uint256>>(){}, new TypeReference<DynamicArray<Uint256>>(){}));
    public static final Event TRANSFERSINGLE_EVENT = new Event("TransferSingle", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}));
    public static final Event URI_EVENT = new Event("URI", Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Uint256>(true){}));

    @Deprecated
    protected StrategyHandler(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected StrategyHandler(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected StrategyHandler(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected StrategyHandler(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public List<ApprovalForAllEventResponse> getApprovalForAllEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(APPROVALFORALL_EVENT, transactionReceipt);
        ArrayList<ApprovalForAllEventResponse> responses = new ArrayList<ApprovalForAllEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._approved = (Boolean)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalForAllEventResponse> approvalForAllEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ApprovalForAllEventResponse>(){

            public ApprovalForAllEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = StrategyHandler.this.extractEventParametersWithLog(APPROVALFORALL_EVENT, log);
                ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
                typedResponse.log = log;
                typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._approved = (Boolean)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalForAllEventResponse> approvalForAllEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVALFORALL_EVENT));
        return this.approvalForAllEventFlowable(filter);
    }

    public List<TransferBatchEventResponse> getTransferBatchEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFERBATCH_EVENT, transactionReceipt);
        ArrayList<TransferBatchEventResponse> responses = new ArrayList<TransferBatchEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferBatchEventResponse typedResponse = new TransferBatchEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
            typedResponse._ids = (List)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse._amounts = (List)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferBatchEventResponse> transferBatchEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferBatchEventResponse>(){

            public TransferBatchEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = StrategyHandler.this.extractEventParametersWithLog(TRANSFERBATCH_EVENT, log);
                TransferBatchEventResponse typedResponse = new TransferBatchEventResponse();
                typedResponse.log = log;
                typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
                typedResponse._ids = (List)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse._amounts = (List)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferBatchEventResponse> transferBatchEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFERBATCH_EVENT));
        return this.transferBatchEventFlowable(filter);
    }

    public List<TransferSingleEventResponse> getTransferSingleEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFERSINGLE_EVENT, transactionReceipt);
        ArrayList<TransferSingleEventResponse> responses = new ArrayList<TransferSingleEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferSingleEventResponse typedResponse = new TransferSingleEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
            typedResponse._id = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse._amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferSingleEventResponse> transferSingleEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferSingleEventResponse>(){

            public TransferSingleEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = StrategyHandler.this.extractEventParametersWithLog(TRANSFERSINGLE_EVENT, log);
                TransferSingleEventResponse typedResponse = new TransferSingleEventResponse();
                typedResponse.log = log;
                typedResponse._operator = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
                typedResponse._id = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse._amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferSingleEventResponse> transferSingleEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFERSINGLE_EVENT));
        return this.transferSingleEventFlowable(filter);
    }

    public List<URIEventResponse> getURIEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(URI_EVENT, transactionReceipt);
        ArrayList<URIEventResponse> responses = new ArrayList<URIEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            URIEventResponse typedResponse = new URIEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._amount = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<URIEventResponse> uRIEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, URIEventResponse>(){

            public URIEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = StrategyHandler.this.extractEventParametersWithLog(URI_EVENT, log);
                URIEventResponse typedResponse = new URIEventResponse();
                typedResponse.log = log;
                typedResponse._id = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._amount = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<URIEventResponse> uRIEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)URI_EVENT));
        return this.uRIEventFlowable(filter);
    }

    public RemoteFunctionCall<BigInteger> balanceOf(String _owner, BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOF, Arrays.asList(new Address(160, _owner), new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<List> balanceOfBatch(List<String> _owners, List<BigInteger> _ids) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOFBATCH, Arrays.asList(new DynamicArray(Address.class, Utils.typeMap(_owners, Address.class)), new DynamicArray(Uint256.class, Utils.typeMap(_ids, Uint256.class))), Arrays.asList(new TypeReference<DynamicArray<Uint256>>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<List>(){

            @Override
            public List call() throws Exception {
                List result = (List)StrategyHandler.this.executeCallSingleValueReturn(function, List.class);
                return StrategyHandler.convertToNative((List)result);
            }
        });
    }

    public RemoteFunctionCall<TransactionReceipt> endUsingNFT(String _account, BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ENDUSINGNFT, Arrays.asList(new Address(160, _account), new Uint256(_id)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> getStrategyUseCount(String _account, BigInteger _id, String _strategy) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETSTRATEGYUSECOUNT, Arrays.asList(new Address(160, _account), new Uint256(_id), new Address(160, _strategy)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> getTotalUseCount(String _account, BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETTOTALUSECOUNT, Arrays.asList(new Address(160, _account), new Uint256(_id)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Boolean> isApprovedForAll(String _owner, String _operator) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISAPPROVEDFORALL, Arrays.asList(new Address(160, _owner), new Address(160, _operator)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> safeBatchTransferFrom(String _from, String _to, List<BigInteger> _ids, List<BigInteger> _amounts, byte[] _data) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SAFEBATCHTRANSFERFROM, Arrays.asList(new Address(160, _from), new Address(160, _to), new DynamicArray(Uint256.class, Utils.typeMap(_ids, Uint256.class)), new DynamicArray(Uint256.class, Utils.typeMap(_amounts, Uint256.class)), new DynamicBytes(_data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> safeTransferFrom(String _from, String _to, BigInteger _id, BigInteger _amount, byte[] _data) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SAFETRANSFERFROM, Arrays.asList(new Address(160, _from), new Address(160, _to), new Uint256(_id), new Uint256(_amount), new DynamicBytes(_data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setApprovalForAll(String _operator, Boolean _approved) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETAPPROVALFORALL, Arrays.asList(new Address(160, _operator), new Bool(_approved)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> startUsingNFT(String _account, BigInteger _id) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_STARTUSINGNFT, Arrays.asList(new Address(160, _account), new Uint256(_id)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    @Deprecated
    public static StrategyHandler load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new StrategyHandler(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static StrategyHandler load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new StrategyHandler(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static StrategyHandler load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new StrategyHandler(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static StrategyHandler load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new StrategyHandler(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<StrategyHandler> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return StrategyHandler.deployRemoteCall(StrategyHandler.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)BINARY);
    }

    @Deprecated
    public static RemoteCall<StrategyHandler> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return StrategyHandler.deployRemoteCall(StrategyHandler.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)BINARY);
    }

    public static RemoteCall<StrategyHandler> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return StrategyHandler.deployRemoteCall(StrategyHandler.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)BINARY);
    }

    @Deprecated
    public static RemoteCall<StrategyHandler> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return StrategyHandler.deployRemoteCall(StrategyHandler.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)BINARY);
    }

    public static class URIEventResponse
    extends BaseEventResponse {
        public BigInteger _id;
        public String _amount;
    }

    public static class TransferSingleEventResponse
    extends BaseEventResponse {
        public String _operator;
        public String _from;
        public String _to;
        public BigInteger _id;
        public BigInteger _amount;
    }

    public static class TransferBatchEventResponse
    extends BaseEventResponse {
        public String _operator;
        public String _from;
        public String _to;
        public List<BigInteger> _ids;
        public List<BigInteger> _amounts;
    }

    public static class ApprovalForAllEventResponse
    extends BaseEventResponse {
        public String _owner;
        public String _operator;
        public Boolean _approved;
    }
}

